<?php
namespace App\Models;

use App\Helpers\DateHelper;

class TodaystatModel extends BaseModel {
    protected $table      = 'today_statistics';
    protected $primaryKey = 'id';

    protected $allowedFields = ['todayorder','todaypayment','todaysales','todaymember','totalproduct','eventproduct','newproduct','bestproduct','recomproduct','brandproduct','nshopproduct','active_flg','del_flg'];



    protected $returnType = 'App\Entities\Todaystat';
    protected $useSoftDeletes = false;

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [
        'todayorder' => 'required',
        'todaypayment' => 'required',
        'todaysales' => 'required',
        'todaymember' => 'required',
    ];
    
    protected $validationMessages = [];
    protected $skipValidation     = true;

    public function getTodaystat($limit){
        $queryBuilder = $this->where('del_flg', DELETE_FLG_OFF);
        $queryBuilder = $this->where('active_flg', 1);
        $queryBuilder = $this->orderBy('created_at ASC');

        return $this->executePaginate($queryBuilder, $limit);
    }


    public function findInfoById($id){
        $tableTodaystat = $this::getTableName();
        return $this->where('id', esc($id))->select("$tableTodaystat.*")->first();
    }

    // SELECT * FROM "today_statistics" ORDER BY "id" DESC LIMIT 1

    public function getSearch($condition = [], $limit = 20){
        $tableTodaystat = $this::getTableName();
        $queryBuilder = $this->where("$tableTodaystat.del_flg", DELETE_FLG_OFF);
        
        if(isset($condition['todaypayment']) && $this->checkSearchItem($condition['todaypayment'])){
            $queryBuilder->where("$tableTodaystat.todaypayment", esc($condition['todaypayment']));
        }
        if(isset($condition['todayorder']) && $this->checkSearchItem($condition['todayorder'])){
            $queryBuilder->like("$tableTodaystat.todayorder", esc($condition['todayorder']));
        }
        if(isset($condition['todayorder']) && $this->checkSearchItem($condition['from_date'])){
            $queryBuilder->where("$tableTodaystat.created_at >=", DateHelper::setFirstHourMinuteDate(esc($condition['from_date'])));
        }
        if(isset($condition['to_date']) && $this->checkSearchItem($condition['to_date'])){
            $queryBuilder->where("$tableTodaystat.created_at <=",DateHelper::setLastHourMinuteDate(esc($condition['to_date'])));
        }

        $queryBuilder->select("$tableTodaystat.*");
        $queryBuilder->orderBy('created_at desc');
        if(!isset($limit)) $limit = 20;
        return $this->executePaginate($queryBuilder, $limit);
    }

}