<?php
//Define Router Product Quote
$routes->get('product/quote', 'QuoteController::index',['as' => 'admin.product.quote.index']);
$routes->get('product/quote/detail/(:num)', 'QuoteController::showDetail/$1',['as' => 'admin.product.quote.detail']);
$routes->delete('product/quote/delete/(:any)', 'QuoteController::delete/$1',['as' => 'admin.product.quote.delete']);

//Define Router Product List
$routes->get('products', 'ProductController::index',['as' => 'admin.product.index']);
$routes->get('products/create', 'ProductController::showCreate',['as' => 'admin.product.show_create']);
$routes->post('products/create', 'ProductController::create',['as' => 'admin.product.create']);
$routes->get('products/update/(:num)', 'ProductController::showUpdate/$1',['as' => 'admin.product.show_update']);
$routes->post('products/update/(:num)', 'ProductController::update/$1',['as' => 'admin.product.update']);
$routes->post('products/upshowwindow/(:num)', 'ProductController::upshowwindow/$1',['as' => 'admin.product.upshowwindow']);

$routes->delete('products/delete/(:any)', 'ProductController::delete/$1',['as' => 'admin.product.delete']);
$routes->delete('products/delete-all', 'ProductController::deleteAll',['as' => 'admin.product.delete_all']);

$routes->get('products/excel/download', 'ProductController::downloadExcel',['as' => 'admin.product.download_excel']);

$routes->get('productcreate', 'ProductController::showCreate',['as' => 'admin.productcreate']);
$routes->get('productcreate/create_ok', 'ProductController::createOk',['as' => 'admin.productcreate.create_ok']);
$routes->get('products/updateprice', 'ProductController::updatePrice',['as' => 'admin.product.updateprice']);

//Define Router Upload Excel
$routes->get('product/excel/upload', 'ExcelUploadController::index', ['as' => 'admin.product.excel_upload.index']);
$routes->get('product/excel/upload/download-template', 'ExcelUploadController::downloadTemplate', ['as' => 'admin.product.excel_upload.download_template']);
$routes->post('product/excel/upload/import', 'ExcelUploadController::upload', ['as' => 'admin.product.excel_upload.import']);

$routes->get('product/loop/', 'ExcelloopController::index', ['as' => 'admin.product.loop.index']);
$routes->get('product/loop/upload/download-template', 'ExcelloopController::downloadTemplate', ['as' => 'admin.product.loop_upload.download_template']);
$routes->match(['get', 'post'], 'product/ExcelloopController/importCsvToDb', 'ExcelloopController::importCsvToDb', ['as' => 'admin.product.loop.importCsvToDb']);

$routes->get('product/loop/curlupload', 'LoopUploadController::curlupload', ['as' => 'admin.product.loop_upload.curlupload']);

//Input
$routes->get('product/input', 'ItemController::index',['as' => 'admin.product.item.index']);
$routes->post('product/input/create','ItemController::save',['as'=>'admin.product.item.create']);