<?php
//Define Router Sale Quote
$routes->get('sale/quote', 'QuoteController::index',['as' => 'admin.sale.quote.index']);
$routes->get('sale/quote/detail/(:num)', 'QuoteController::showDetail/$1',['as' => 'admin.sale.quote.detail']);
$routes->delete('sale/quote/delete/(:any)', 'QuoteController::delete/$1',['as' => 'admin.sale.quote.delete']);

//Define Router Sale List
$routes->get('sales', 'SaleController::index',['as' => 'admin.sale.index']);
$routes->get('sales/create', 'SaleController::showCreate',['as' => 'admin.sale.show_create']);
$routes->post('sales/create', 'SaleController::create',['as' => 'admin.sale.create']);
$routes->get('sales/update/(:num)', 'SaleController::showUpdate/$1',['as' => 'admin.sale.show_update']);
$routes->post('sales/update/(:num)', 'SaleController::update/$1',['as' => 'admin.sale.update']);
$routes->delete('sales/delete/(:any)', 'SaleController::delete/$1',['as' => 'admin.sale.delete']);
$routes->delete('sales/delete-all', 'SaleController::deleteAll',['as' => 'admin.sale.delete_all']);
$routes->get('sales/excel/download', 'SaleController::downloadExcel',['as' => 'admin.sale.download_excel']);

//Define Router Upload Excel
$routes->get('sale/excel/upload', 'ExcelUploadController::index', ['as' => 'admin.sale.excel_upload.index']);
$routes->get('sale/excel/upload/download-template', 'ExcelUploadController::downloadTemplate', ['as' => 'admin.sale.excel_upload.download_template']);
$routes->post('sale/excel/upload/import', 'ExcelUploadController::upload', ['as' => 'admin.sale.excel_upload.import']);

//Input
$routes->get('sale/input', 'ItemController::index',['as' => 'admin.sale.item.index']);
$routes->post('sale/input/create','ItemController::save',['as'=>'admin.sale.item.create']);