<?php
//Define Router Home
$routes->get('/estimate', 'EstimateController::index', ['as' => 'guest.estimate']);
$routes->get('/estimate/detail/(:num)', 'EstimateController::detail/$1', ['as' => 'guest.estimate.detail']);
$routes->get('/estimate/detaillogin/(:num)', 'EstimateController::detaillogin/$1', ['as' => 'guest.estimate.detaillogin']);
$routes->post('/estimate/detailpost/(:num)', 'EstimateController::detailpost/$1', ['as' => 'guest.estimate.detailpost']);

$routes->get('/estimate/view-file/(:num)/(:num)', 'EstimateController::viewFile/$1/$2', ['as' => 'guest.estimate.view_file']);
$routes->get('/estimate/create', 'EstimateController::showCreate',['as' => 'guest.estimate.show_create']);
$routes->post('/estimate/create', 'EstimateController::create',['as' => 'guest.estimate.create']);

$routes->get('/estimate/update/(:num)/delete/(:num)', 'EstimateController::deleteFile/$1/$2',['as' => 'guest.estimate.delete_file']);
$routes->get('/estimate/update/(:num)', 'EstimateController::showUpdate/$1',['as' => 'guest.estimate.show_update']);
$routes->post('/estimate/update/(:num)', 'EstimateController::update/$1',['as' => 'guest.estimate.update']);
$routes->delete('/estimate/delete/(:any)', 'EstimateController::deleteEstimate/$1',['as' => 'guest.estimate.delete']);
$routes->get('/estimate/downloadbom', 'EstimateController::downloadBom', ['as' => 'guest.estimate.downloadbom']);