<?php
namespace App\Services;

use App\Helpers\AuthHelpers;
use App\Helpers\FileHelper;
use App\Helpers\DateHelper;

use App\Entities\AccountManager;
use App\Models\AccountManagerModel;
use CodeIgniter\HTTP\RequestInterface;

class AccountManagerService extends BaseService {

    public function saveAccountManager(RequestInterface $request){
        //Save account
        $account = new AccountManager();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        $inputs['password'] = md5($inputs['password']);
        $account->fill($inputs);

        $insertId = $this->accountModel->insert($account, true);
        if($insertId > 0){
            $info = $this->accountModel->find($insertId);
            $fileImage = $request->getFile('avatar_dir');
            if(isset($fileImage) && !empty($fileImage)){
                $fileImagePath = FileHelper::saveFile($fileImage, FileHelper::FOLDER_PATCH_UPLOAD_ACCOUNT, $insertId);
                $info->avatar_dir = $fileImagePath;
            }

            $this->accountModel->save($info);
        }

    }

    public function updateAccountManager($id, RequestInterface $request){
        $accountItem = $this->accountModel->find($id);
        if(isset($accountItem)){
            $inputs = $request->getPost();
            $inputs['public_flg'] = get_public_id($inputs['public_flg']);
            $accountItem->fill($inputs);

            $this->accountModel->save($accountItem);
            $files = $request->getFiles();
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $accountFile = new AccountManagerFile([
                            'account_id' => esc($id),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->newFileModel->save($accountFile);
                    }
                }
            }
        }
    }

    public function deleteAccountManager($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->accountModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->accountModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}