<?php
namespace App\Services;

use App\Entities\ApiDatalogs;
use App\Models\ApiDatalogsModel;
use CodeIgniter\HTTP\RequestInterface;

class ApiDatalogsService extends BaseService {
    public function saveApiDatalogs(RequestInterface $request){
        $apiDatalogs = new ApiDatalogs();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        
        $apiDatalogs->fill($inputs);
        $insertId = $this->apiDatalogsModel->insert($apiDatalogs, true);
    }

    public function updateApiDatalogs($id, RequestInterface $request){
        $apiDatalogsItem = $this->apiDatalogsModel->find($id);

        if(isset($apiDatalogsItem)){
            $inputs = $request->getPost();
            $inputs['public_flg'] = get_public_id($inputs['public_flg']);
            $apiDatalogsItem->fill($inputs);

            $this->apiDatalogsModel->save($apiDatalogsItem);
        }
    }

    public function deleteApiDatalogs($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->apiDatalogsModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->apiDatalogsModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}