<?php
namespace App\Services;

use App\Entities\ApiProductinfo;
use App\Helpers\FileHelper;
use App\Models\ApiProductinfoModel;
use CodeIgniter\HTTP\RequestInterface;

class ApiProductinfoService extends BaseService {

    public function saveApiProductinfo(RequestInterface $request,$loginId){
        //Save apiProductinfo
        $apiProductinfo = new ApiProductinfo();
        $inputs = $request->getPost();
        $apiProductinfo->fill($inputs);
        //var_dump ($apiProductinfo);
        //exit;
        $this->apiProductinfoModel->insert($apiProductinfo, true);
    }

    public function updateApiProductinfo($id, RequestInterface $request){
 
        $apiProductinfoItem = $this->apiProductinfoModel->find($id);
        if(isset($apiProductinfoItem)){
            $inputs = $request->getPost();
            $apiProductinfoItem->fill($inputs);
            $this->apiProductinfoModel->save($apiProductinfoItem);
            //exit;
        }
    }

    public function deleteApiProductinfo($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->apiProductinfoModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->apiProductinfoModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}