<?php
namespace App\Services;

use App\Entities\Apiinfo;
use App\Helpers\FileHelper;
use App\Models\ApiinfoModel;
use CodeIgniter\HTTP\RequestInterface;

class ApiinfoService extends BaseService {

    public function saveApiinfo(RequestInterface $request){
        $apiinfo = new Apiinfo();
        $inputs = $request->getPost();
        $apiinfo->fill($inputs);

        $insertId = $this->apiinfoModel->insert($apiinfo, true);
    }

    public function updateApiinfo($id, RequestInterface $request){
        $apiinfoItem = $this->apiinfoModel->find($id);
        if(isset($apiinfoItem)){
            $inputs = $request->getPost();
            $apiinfoItem->fill($inputs);

            $this->apiinfoModel->save($apiinfoItem);
        }
    }

    public function deleteApiinfo($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->apiinfoModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->apiinfoModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}