<?php
namespace App\Services;

use App\Entities\BannerinfoFile;
use App\Entities\Bannerinfos;
use App\Helpers\FileHelper;
use App\Models\BannerinfoModel;
use CodeIgniter\HTTP\RequestInterface;

class BannerinfosService extends BaseService {
    public function saveBannerinfos(RequestInterface $request,$loginId){
        //Save bannerinfos
        $bannerinfos = new Bannerinfos();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        $inputs['active_flg'] = get_public_id($inputs['active_flg']);
        $inputs['account_manager_id'] = $loginId;
        $bannerinfos->fill($inputs);
        // var_dump ($bannerinfos);
        // exit;
        $insertId = $this->bannerinfosModel->insert($bannerinfos, true);

        if($insertId > 0){
            $bannerinfoDb = $this->bannerinfosModel->find($insertId);
            $fileImage = $request->getFile('image_file');

            if(isset($fileImage) && !empty($fileImage->getClientName())){
                $fileImagePath = FileHelper::saveImageItem($fileImage, FileHelper::FOLDER_PATH_UPLOAD_BANNERINFO, $insertId);
                $bannerinfoDb->image_dir = $fileImagePath[FileHelper::IMAGE_ORIGIN_NAME];
                $this->bannerinfosModel->save($bannerinfoDb);
            }

        }
    }

    public function updateBannerinfos($id, RequestInterface $request){
        $bannerinfosItem = $this->bannerinfosModel->find($id);

        if(isset($bannerinfosItem)){
            $inputs = $request->getPost();
            $inputs['active_flg'] = get_public_id($inputs['active_flg']);
             $bannerinfosItem->fill($inputs);
            
            $fileImage = $request->getFile('image_file');
            if(isset($fileImage)){
                $fileName = $fileImage->getClientName();
                if(isset($fileName) && !empty($fileName)){
                    FileHelper::deleteFile( $bannerinfosItem->image_dir);
                    $fileImagePath = FileHelper::saveImageItem($fileImage, FileHelper::FOLDER_PATH_UPLOAD_BANNERINFO, $id);
                     $bannerinfosItem->image_dir = $fileImagePath[FileHelper::IMAGE_ORIGIN_NAME];
                }
                
                $this->bannerinfosModel->save($bannerinfosItem);
            }

            $this->db->transComplete();
        }

    }

    public function deleteBannerinfos($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->bannerinfosModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->bannerinfosModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}