<?php
namespace App\Services;

use App\Entities\Categorylevel1;
use App\Helpers\FileHelper;
use App\Models\Categorylevel1Model;
use CodeIgniter\HTTP\RequestInterface;

class Categorylevel1Service extends BaseService {

    public function deleteCategorylevel1($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->categorylevel1Model->find($id);

                    if(isset($item)){
                        $item['active_flg'] = 0;
                        $item['del_flg'] = PUBLIC_FLG_ON;   
                        $this->categorylevel1Model->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }

}