<?php
namespace App\Services;

use App\Entities\Categorylevel2;
use App\Helpers\FileHelper;
use App\Models\Categorylevel2Model;
use CodeIgniter\HTTP\RequestInterface;

class Categorylevel2Service extends BaseService {

    public function deleteCategorylevel2($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->categorylevel2Model->find($id);
                    if(isset($item)){
                        $item['active_flg'] = 0;
                        $item['del_flg'] = PUBLIC_FLG_ON;   
                        $categorylevel2_code = $item['categorylevel2_code'];
                        $this->categorylevel2Model->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }

    public function acceptCategorylevel2($ids, $active_flg = MEMBER_ACCEPT_ON){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->categorylevel2Model->find($id);
                    if(isset($item)){
                        $item['active_flg'] = $active_flg;

                        //var_dump ($item);
                        //exit;

                        $this->categorylevel2Model->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }

}