<?php
namespace App\Services;

use App\Entities\DisplayinfoFile;
use App\Entities\Displayinfo;
use App\Helpers\FileHelper;
use App\Models\DisplayinfoModel;
use CodeIgniter\HTTP\RequestInterface;

class DisplayinfoService extends BaseService {

    public function saveDisplayinfo(RequestInterface $request,$loginId){
        //Save displayinfo
        $displayinfo = new Displayinfo();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        $displayinfo->fill($inputs);
        //var_dump ($displayinfo);
        //exit;

        //$manufactureId = $request->getPost('manufacturer_id');
        //var_dump ($manufactureId);
        //exit;
        //$manufacturer = $this->manufacturerModel->findById($manufactureId);
        //$displayinfo ->manufacturer_id = $manufacturer->code;

        $insertId = $this->displayinfoModel->insert($displayinfo, true);

        if($insertId > 0){
            $displayDb = $this->displayinfoModel->find($insertId);
            $fileImage = $request->getFile('image_file');

            if(isset($fileImage) && !empty($fileImage->getClientName())){
                $fileImagePath = FileHelper::saveFile($fileImage, FileHelper::FOLDER_PATCH_UPLOAD_DISPLAY, $insertId);
                $displayDb->display_file_dir = $fileImagePath;
                $this->displayinfoModel->save($displayDb);
            }

        }
        
        $this->db->transComplete();
        //return true;

    }

    public function updateDisplayinfo($id, RequestInterface $request){
 
        $displayinfoItem = $this->displayinfoModel->find($id);
        if(isset($displayinfoItem)){
            $inputs = $request->getPost();
            $inputs['public_flg'] = get_public_id($inputs['public_flg']);
            $displayinfoItem->fill($inputs);

            $fileImage = $request->getFile('image_file');

            if(isset($fileImage)){
                $fileName = $fileImage->getClientName();
                if(isset($fileName) && !empty($fileName)){
                    FileHelper::deleteFile($displayinfoItem->image_dir);
                    $fileImagePath = FileHelper::saveImageItem($fileImage, FileHelper::FOLDER_PATCH_UPLOAD_DISPLAY, $id);
                    $displayinfoItem->display_file_dir = $fileImagePath[FileHelper::IMAGE_ORIGIN_NAME];
                }
            }

            $this->displayinfoModel->save($displayinfoItem);
            //exit;
            $this->db->transComplete();
        }
    }

    public function deleteDisplayinfo($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->displayinfoModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->displayinfoModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}
