<?php
namespace App\Services;

use App\Entities\EventinfoFile;
use App\Entities\Eventinfo;
use App\Helpers\FileHelper;
use App\Models\EventinfoModel;
use CodeIgniter\HTTP\RequestInterface;

class EventinfoService extends BaseService {

    public function saveEventinfo(RequestInterface $request,$loginId){
        //Save eventinfo
        $eventinfo = new Eventinfo();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        // $inputs['account_manager_id'] = $loginId;
        $eventinfo->fill($inputs);
        //var_dump ($eventinfo);
        //exit;
        $insertId = $this->eventinfoModel->insert($eventinfo, true);

        if($insertId > 0){
            $eventDb = $this->eventinfoModel->find($insertId);
            $fileImage = $request->getFile('image_file');

        //var_dump ($fileImage);
        //exit;

            if(isset($fileImage) && !empty($fileImage->getClientName())){
                $fileImagePath = FileHelper::saveFile($fileImage, FileHelper::FOLDER_PATCH_UPLOAD_EVENT, $insertId);
                $eventDb->file_dir = $fileImagePath;
            }

            $this->eventinfoModel->save($eventDb);
        }
        $this->db->transComplete();
        return true;
    }

    public function updateEventinfo($id, RequestInterface $request){
 
        $eventinfoItem = $this->eventinfoModel->find($id);
        if(isset($eventinfoItem)){
            $inputs = $request->getPost();
            $inputs['public_flg'] = get_public_id($inputs['public_flg']);
            $eventinfoItem->fill($inputs);

            $fileImage = $request->getFile('image_file');

            if(isset($fileImage)){
                $fileName = $fileImage->getClientName();
                if(isset($fileName) && !empty($fileName)){
                    FileHelper::deleteFile($eventinfoItem->image_dir);
                    $fileImagePath = FileHelper::saveImageItem($fileImage, FileHelper::FOLDER_PATCH_UPLOAD_EVENT, $id);
                    $eventinfoItem->file_dir = $fileImagePath[FileHelper::IMAGE_ORIGIN_NAME];
                }
            }

            $this->eventinfoModel->save($eventinfoItem);
            //exit;
            $this->db->transComplete();
        }
    }

    public function deleteEventinfo($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->eventinfoModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->eventinfoModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}