<?php
namespace App\Services;

use App\Entities\InquiryFile;
use App\Entities\Inquiry;
use App\Helpers\FileHelper;
use App\Models\InquiryModel;
use CodeIgniter\HTTP\RequestInterface;

class InquiryService extends BaseService {
    // public function saveInquiry(RequestInterface $request,$loginId){
    public function saveInquiry(RequestInterface $request){
        //Save inquiry
        $inquiry = new Inquiry();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        $inputs['account_manager_id'] = $loginId;
        $inquiry->fill($inputs);
        //var_dump ($inquiry);
        //exit;
        $insertId = $this->inquiryModel->insert($inquiry, true);
        if($insertId > 0){
            $files = $request->getFiles();;
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $inquiryFile = new InquiryFile([
                            'inquiry_id' => esc($insertId),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->inquiryFileModel->save($inquiryFile);
                    }
                }
            }
        }
    }

    public function updateInquiry($id, RequestInterface $request){
        $inquiryItem = $this->inquiryModel->find($id);
        if(isset($inquiryItem)){
            $inputs = $request->getPost();
            $inputs['public_flg'] = get_public_id($inputs['public_flg']);
            $inquiryItem->fill($inputs);

            $this->inquiryModel->save($inquiryItem);
            $files = $request->getFiles();
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $inquiryFile = new InquiryFile([
                            'inquiry_id' => esc($id),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->inquiryFileModel->save($inquiryFile);
                    }
                }
            }
        }
    }

    public function deleteInquiry($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->inquiryModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->inquiryModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}