<?php
namespace App\Services;

use App\Entities\NewFile;
use App\Entities\News;
use App\Helpers\FileHelper;
use App\Models\NewModel;
use CodeIgniter\HTTP\RequestInterface;

class InquiryService extends BaseService {

    public function deleteInquiry($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->inquiryModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->inquiryModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}