<?php
namespace App\Services;

use App\Entities\LeadtimeCategory;
use App\Helpers\FileHelper;
use App\Models\LeadtimeCategoryModel;
use CodeIgniter\HTTP\RequestInterface;

class LeadtimeCategorysService extends BaseService {

    public function saveLeadtimeCategory(RequestInterface $request){
        $leadtimecategorys = new LeadtimeCategory();
        $inputs = $request->getPost();
        $leadtimecategorys->fill($inputs);

        // var_dump($leadtimecategorys);
        // exit;

        $insertId = $this->leadtimeCategorysModel->insert($leadtimecategorys, true);
    }

    public function updateLeadtimeCategory($leadtime_id, RequestInterface $request){
        $leadtimecategorysItem = $this->leadtimeCategorysModel->find($leadtime_id);
        if(isset($leadtimecategorysItem)){
            $inputs = $request->getPost();
            $leadtimecategorysItem->fill($inputs);

            $this->leadtimeCategorysModel->save($leadtimecategorysItem);
        }
    }

    public function deleteLeadtimeCategory($leadtime_ids){
        if(isset($leadtime_ids)){
            try{
                $this->db->transBegin();
                foreach ($leadtime_ids as $leadtime_id){
                    $item = $this->leadtimeCategorysModel->find($leadtime_id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->leadtimeCategorysModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}