<?php
namespace App\Services;

use App\Entities\LocationinfoFile;
use App\Entities\Locationinfo;
use App\Helpers\FileHelper;
use App\Models\LocationinfoModel;
use CodeIgniter\HTTP\RequestInterface;

class LocationinfoService extends BaseService {

    public function saveLocationinfo(RequestInterface $request,$loginId){
        //Save locationinfo
        $locationinfo = new Locationinfo();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        // $inputs['account_manager_id'] = $loginId;
        $locationinfo->fill($inputs);
        //var_dump ($locationinfo);
        //exit;
        $this->locationinfoModel->insert($locationinfo, true);
    }

    public function updateLocationinfo($id, RequestInterface $request){
 
        $locationinfoItem = $this->locationinfoModel->find($id);
        if(isset($locationinfoItem)){
            $inputs = $request->getPost();
            $inputs['public_flg'] = get_public_id($inputs['public_flg']);
            $locationinfoItem->fill($inputs);

            $this->locationinfoModel->save($locationinfoItem);
            //exit;
        }
    }

    public function deleteLocationinfo($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->locationinfoModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->locationinfoModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}