<?php
namespace App\Services;

use App\Entities\NewFile;
use App\Entities\News;
use App\Helpers\FileHelper;
use App\Models\NewModel;
use CodeIgniter\HTTP\RequestInterface;

class NewsService extends BaseService {
    public function saveNews(RequestInterface $request,$loginId){
        //Save news
        $news = new News();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        $inputs['account_manager_id'] = $loginId;
        $news->fill($inputs);
        // var_dump ($news);
        // exit;
        $insertId = $this->newsModel->insert($news, true);
        if($insertId > 0){
            $files = $request->getFiles();;
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $newsFile = new NewFile([
                            'news_id' => esc($insertId),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->newFileModel->save($newsFile);
                    }
                }
            }
        }
    }

    public function updateNews($id, RequestInterface $request){
        $newsItem = $this->newsModel->find($id);
        if(isset($newsItem)){
            $inputs = $request->getPost();
            $inputs['public_flg'] = get_public_id($inputs['public_flg']);
            $newsItem->fill($inputs);

            $this->newsModel->save($newsItem);
            $files = $request->getFiles();
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $newsFile = new NewFile([
                            'news_id' => esc($id),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->newFileModel->save($newsFile);
                    }
                }
            }
        }
    }

    public function deleteNews($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->newsModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->newsModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}