<?php
namespace App\Services;

use App\Entities\NoticeFile;
use App\Entities\Notice;
use App\Helpers\FileHelper;
use App\Models\NoticeModel;
use CodeIgniter\HTTP\RequestInterface;

class NoticeService extends BaseService {
    // public function saveNotice(RequestInterface $request,$loginId){
    public function saveNotice(RequestInterface $request){
        //Save notice
        $notice = new Notice();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        $inputs['account_manager_id'] = $loginId;
        $notice->fill($inputs);
        //var_dump ($notice);
        //exit;
        $insertId = $this->noticeModel->insert($notice, true);
        if($insertId > 0){
            $files = $request->getFiles();;
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $noticeFile = new NoticeFile([
                            'notice_id' => esc($insertId),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->noticeFileModel->save($noticeFile);
                    }
                }
            }
        }
    }

    public function updateNotice($id, RequestInterface $request){
        $noticeItem = $this->noticeModel->find($id);
        if(isset($noticeItem)){
            $inputs = $request->getPost();
            $inputs['public_flg'] = get_public_id($inputs['public_flg']);
            $noticeItem->fill($inputs);

            $this->noticeModel->save($noticeItem);
            $files = $request->getFiles();
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $noticeFile = new NoticeFile([
                            'notice_id' => esc($id),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->noticeFileModel->save($noticeFile);
                    }
                }
            }
        }
    }

    public function deleteNotice($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->noticeModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->noticeModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}