<?php
namespace App\Services;

use App\Entities\OrderInfo;
use App\Helpers\FileHelper;
use App\Models\OrderInfoModel;
use CodeIgniter\HTTP\RequestInterface;

class OrderInfoService extends BaseService {
    
    // public function saveOrderInfo(RequestInterface $request,$loginId){

    public function saveOrderInfo(RequestInterface $request){
        //Save notice
        $notice = new OrderInfo();
        $inputs = $request->getPost();
        $inputs['active_flg'] = get_public_id($inputs['active_flg']);
        $inputs['member_code'] = $loginId;
        $notice->fill($inputs);
        //var_dump ($notice);
        //exit;
    }

    public function updateOrderInfo($id, RequestInterface $request){
        $noticeItem = $this->orderInfoModel->find($id);
        if(isset($noticeItem)){
            $inputs = $request->getPost();
            $inputs['active_flg'] = get_public_id($inputs['active_flg']);
            $noticeItem->fill($inputs);

            $this->orderInfoModel->save($noticeItem);
        }
    }

    public function deleteOrderInfo($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->noticeModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->noticeModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }

}