<?php
namespace App\Services;

use App\Entities\PackagingUnit;
use App\Helpers\FileHelper;
use App\Models\PackagingUnitModel;
use CodeIgniter\HTTP\RequestInterface;

class PackagingUnitService extends BaseService {
    public function savePackagingUnit(RequestInterface $request){

        $packagingunit = new PackagingUnit();
        $inputs = $request->getPost();
        // $inputs['active_flg'] = get_active_id($inputs['active_flg']);
        $packagingunit->fill($inputs);

        $insertId = $this->packagingUnitModel->insert($packagingunit, true);
    }

    public function updatePackagingUnit($packing_id, RequestInterface $request){
        $packagingunitItem = $this->packagingUnitModel->find($packing_id);
        if(isset($packagingunitItem)){
            $inputs = $request->getPost();
            // $inputs['active_flg'] = get_active_id($inputs['active_flg']);
            $packagingunitItem->fill($inputs);

            $this->packagingUnitModel->save($packagingunitItem);
        }
    }

    public function deletePackagingUnit($packing_ids){
        if(isset($packing_ids)){
            try{
                $this->db->transBegin();
                foreach ($packing_ids as $packing_id){
                    $item = $this->packagingUnitModel->find($packing_id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->packagingUnitModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}