<?php
namespace App\Services;

use App\Entities\RefundInfo;
use App\Helpers\FileHelper;
use App\Models\RefundInfoModel;
use CodeIgniter\HTTP\RequestInterface;

class RefundInfoService extends BaseService {
    
    // public function saveRefundInfo(RequestInterface $request,$loginId){


    public function saveRefundInfo(RequestInterface $request){
        //Save refund
        $refund = new RefundInfo();
        $inputs = $request->getPost();
        $inputs['active_flg'] = get_public_id($inputs['active_flg']);
        $inputs['member_code'] = $loginId;
        $refund->fill($inputs);
        //var_dump ($refund);
        //exit;
    }

    public function updateRefundInfo($id, RequestInterface $request){

        //var_dump ($request);
        //exit;

        $refundItem = $this->refundInfoModel->find($id);
        if(isset($refundItem)){
            $inputs = $request->getPost();
            $inputs['active_flg'] = get_public_id($inputs['active_flg']);
            $refundItem->fill($inputs);

            $this->refundInfoModel->save($refundItem);
        }
    }

    public function deleteRefundInfo($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->refundInfoModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->refundInfoModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }

}