<?php
namespace App\Services;

use App\Entities\ReviewFile;
use App\Entities\Review;
use App\Helpers\FileHelper;
use App\Models\ReviewModel;
use CodeIgniter\HTTP\RequestInterface;

class ReviewService extends BaseService {
    // public function saveReview(RequestInterface $request,$loginId){
    public function saveReview(RequestInterface $request){
        //Save review
        $review = new Review();
        $inputs = $request->getPost();
        $inputs['public_flg'] = get_public_id($inputs['public_flg']);
        $inputs['account_manager_id'] = $loginId;
        $review->fill($inputs);
        //var_dump ($review);
        //exit;
        $insertId = $this->reviewModel->insert($review, true);
        if($insertId > 0){
            $files = $request->getFiles();;
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $reviewFile = new ReviewFile([
                            'review_id' => esc($insertId),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->reviewFileModel->save($reviewFile);
                    }
                }
            }
        }
    }

    public function updateReview($id, RequestInterface $request){
        $reviewItem = $this->reviewModel->find($id);
        if(isset($reviewItem)){
            $inputs = $request->getPost();
            $inputs['public_flg'] = get_public_id($inputs['public_flg']);
            $reviewItem->fill($inputs);

            $this->reviewModel->save($reviewItem);
            $files = $request->getFiles();
            if(isset($files)){
                foreach ($files as $file){
                    $fileName = $file->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        $filePath = FileHelper::saveFile($file, FileHelper::FOLDER_PATH_UPLOAD_NEWS, $insertId);
                        $reviewFile = new ReviewFile([
                            'review_id' => esc($id),
                            'file_name' => esc($fileName),
                            'file_dir' => esc($filePath)
                        ]);
                        $this->reviewFileModel->save($reviewFile);
                    }
                }
            }
        }
    }

    public function deleteReview($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->reviewModel->find($id);
                    if(isset($item)){
                        $item->del_flg = PUBLIC_FLG_ON;
                        $this->reviewModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}