<?php
namespace App\Services;

use App\Entities\CartInfo;
use App\Entities\Showwindow;
use App\Helpers\ArrayHelper;
use App\Helpers\DateHelper;
use App\Helpers\FileHelper;
use App\Models\ShowwindowModel;
use CodeIgniter\HTTP\RequestInterface;
use League\Flysystem\Exception;
use phpDocumentor\Reflection\DocBlock\Tags\Throws;

class ShowWindowService extends BaseService {

    public function saveProductList(RequestInterface $request){

        try{
            $this->db->transBegin();
            $product = new Showwindow();
            $inputs = $request->getPost();
            $product->fill($inputs);
            $product->updated_at = '';

            $manufactureId = $product->id;
            $manufacturer = $this->manufacturerModel->findById($manufactureId);
            $manufacturer_name = preg_replace("/\s+/", "", $manufacturer->name);

            if ($product->api_code) {
                $product->part_number_sequence = $product->api_code.$manufacturer_name.$product->part_number.$product->product_api_id;
            } else {
                $product->part_number_sequence = $manufacturer_name.$product->part_number.$product->product_api_id;
            }

            if ($product->qty > 0) {
                $product->qty_flag = '1';
            } else {
                $product->qty_flag = '0';
            }

            $vrpntem = "$product->part_number.$product->product_api_id.$product->product_code.$manufacturer_name";
            $str = preg_replace("/\s+/", "", $vrpntem);
            $vrpartnumber = str_replace(array("/", "-", "_", "[", "]", "(", ")", "."), '', $str);
            $product->virtualpn= $vrpartnumber;

            $insertId = $this->showwindowModel->insert($product, true);
            
            if($insertId > 0){
                $productDb = $this->showwindowModel->find($insertId);
                $fileImage = $request->getFile('image_file');

                if(isset($fileImage) && !empty($fileImage->getClientName())){
                    $fileImagePath = FileHelper::saveImageItem($fileImage, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $insertId);
                    $productDb->image_dir = $fileImagePath[FileHelper::IMAGE_ORIGIN_NAME];
                    $this->showwindowModel->save($productDb);
                }

                $productdetail = new Showwindowdetail();
                $productdetail->product_code = $productDb->product_code;
                $productdetail->api_flg = $productDb->api_flg;
                $productdetail->api_code = $productDb->api_code;
                $productdetail->product_api_id = $productDb->product_api_id;


                $product_doc = $request->getPost('product_doc');
                $fileImage1 = $request->getFile('product_image1');
                $fileImage2 = $request->getFile('product_image2');
                $filePdf = $request->getFile('product_pdf');

                if ($product_doc) {
                    $productdetail->product_doc = $product_doc;
                }

                $detailid = $this->productdetailModel->insert($productdetail, true);

                $productdetail = $this->productdetailModel->find($detailid);

                if(isset($fileImage1)){
                    $fileName1 = $fileImage1->getClientName();
                    if(isset($fileName1) && !empty($fileName1)){
                        $fileImage1Path = FileHelper::saveFile($fileImage1, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $insertId);
                        $productdetail->product_image1 = $fileImage1Path;
                        $this->productdetailModel->save($productdetail);
                    }
                }

                if(isset($fileImage2)){
                    $fileName2 = $fileImage2->getClientName();
                    if(isset($fileName2) && !empty($fileName2)){
                        $fileImage2Path = FileHelper::saveFile($fileImage2, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $insertId);
                        $productdetail->product_image2 = $fileImage2Path;
                        $this->productdetailModel->save($productdetail);
                    }
                }

                if(isset($fileImage3)){
                    $fileName3 = $fileImage3->getClientName();
                    if(isset($fileName3) && !empty($fileName3)){
                        $fileImage3Path = FileHelper::saveFile($fileImage3, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $insertId);
                        $productdetail->product_image3 = $fileImage3Path;
                        $this->productdetailModel->save($productdetail);
                    }
                }

                if(isset($fileImage4)){
                    $fileName4 = $fileImage4->getClientName();
                    if(isset($fileName4) && !empty($fileName4)){
                        $fileImage4Path = FileHelper::saveFile($fileImage4, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $insertId);
                        $productdetail->product_image4 = $fileImage4Path;
                        $this->productdetailModel->save($productdetail);
                    }
                }

                if(isset($fileImage5)){
                    $fileName5 = $fileImage5->getClientName();
                    if(isset($fileName5) && !empty($fileName5)){
                        $fileImage5Path = FileHelper::saveFile($fileImage5, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $insertId);
                        $productdetail->product_image5 = $fileImage5Path;
                        $this->productdetailModel->save($productdetail);
                    }
                }

                if(isset($filePdf)){
                    $pdfName = $filePdf->getClientName();
                    if(isset($pdfName) && !empty($pdfName)){
                        $filePdfPath = FileHelper::saveFile($filePdf, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $insertId);
                        $productdetail->product_pdf = $filePdfPath;
                        $this->productdetailModel->save($productdetail);
                    }
                }

            }
            
            $this->db->transComplete();
            return true;

        } catch (\Throwable $ex) {
            
            $this->db->transRollback();
            throw $ex;
        }
    }

    
    public function uploadProductList($id, RequestInterface $request){

        try{
            $this->db->transBegin();

            $product = $this->showwindowModel->find($id);
            $product_code = $product->product_code;

            if(isset($product)){

                $inputs = $request->getPost();
                $product->fill($inputs);
                
                $newproduct_chk = $request->getPost('newproduct_chk');
                if ($newproduct_chk == '1') {
                    $product->newproduct_chk = '1';
                } else {
                    $product->newproduct_chk = '0';
                }

                $bestproduct_chk = $request->getPost('bestproduct_chk');
                if ($bestproduct_chk == '1') {
                    $product->bestproduct_chk = '1';
                } else {
                    $product->bestproduct_chk = '0';
                }

                $recomproduct_chk = $request->getPost('recomproduct_chk');
                if ($recomproduct_chk == '1') {
                    $product->recomproduct_chk = '1';
                } else {
                    $product->recomproduct_chk = '0';
                }

                $brandproduct_chk = $request->getPost('brandproduct_chk');
                if ($brandproduct_chk == '1') {
                    $product->brandproduct_chk = '1';
                } else {
                    $product->brandproduct_chk = '0';
                }

                $situation = $request->getPost('situation');
                if ($situation == '1') {
                    $product->situation = '1';
                } else {
                    $product->situation = '0';
                }

                $exposure = $request->getPost('exposure');
                if ($exposure == '1') {
                    $product->exposure = '1';
                } else {
                    $product->exposure = '0';
                }


                $navershop_chk = $request->getPost('navershop_chk');
                $navershop_status_before = $request->getPost('navershop_status_before');
                if ($navershop_chk == '1') {
                    $product->navershop_chk = '1';
                    if ($navershop_status_before == 'I') {
                        $product->navershop_status = 'U';
                    } else {
                        $product->navershop_status = 'I'; 
                    }
                } else {
                    $product->navershop_chk = '0';
                    if ($navershop_status_before == 'I' || $navershop_status_before == 'U') {
                        $product->navershop_status = 'D';
                    } else {
                        $product->navershop_status = ''; 
                    }
                }

                $fileImage = $request->getFile('image_file');

                if(isset($fileImage)){
                    $fileName = $fileImage->getClientName();
                    if(isset($fileName) && !empty($fileName)){
                        FileHelper::deleteFile($product->image_dir);
                        $fileImagePath = FileHelper::saveImageItem($fileImage, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $id);
                        $product->image_dir = $fileImagePath[FileHelper::IMAGE_ORIGIN_NAME];
                        $this->showwindowModel->save($product);
                    }
                }

                if ($product->old_part_number != $product->part_number) {
                    $manufactureId = $product->id;
                    $manufacturer = $this->manufacturerModel->findById($manufactureId);
                    $manufacturer_newName = $manufacturer->name;

                    $manufacturer_name = preg_replace("/\s+/", "", $manufacturer_newName);
                    if ($product->api_code) {
                        $product->part_number_sequence = $product->api_code.$manufacturer_name.$product->part_number.$product->product_api_id;
                    } else {
                        $product->part_number_sequence = $manufacturer_name.$product->part_number.$product->product_api_id;
                    }

                    $vrpntem = "$product->part_number.$product->product_api_id.$product->product_code.$manufacturer_name";
                    $str = preg_replace("/\s+/", "", $vrpntem);
                    $vrpartnumber = str_replace(array("/", "-", "_", "[", "]", "(", ")", "."), '', $str);
                    $product->virtualpn= $vrpartnumber;
                }

                $this->showwindowModel->save($product);
                // var_dump($product_code);
                
                $productdetail = $this->productdetailModel->where('product_code',$product_code)->first();
                $product_doc_old = $productdetail->product_doc;
                $product_image1_old = $productdetail->product_image1;
                $product_image2_old = $productdetail->product_image2;
                $product_image3_old = $productdetail->product_image3;
                $product_image4_old = $productdetail->product_image4;
                $product_image5_old = $productdetail->product_image5;
                $product_pdf_old = $productdetail->product_pdf;

                $product_doc = $request->getPost('product_doc');
                $fileImage1 = $request->getFile('product_image1');
                $fileImage2 = $request->getFile('product_image2');
                $filePdf = $request->getFile('product_pdf');

                if($product_doc != $product_doc_old){
                    $productdetail->product_doc = $product_doc;
                    $this->productdetailModel->save($productdetail);
                }

                if(isset($fileImage1)){
                    $fileName1 = $fileImage1->getClientName();
                    if(isset($fileName1) && !empty($fileName1)){
                        FileHelper::deleteFile($product_image1_old);
                        $fileImage1Path = FileHelper::saveFile($fileImage1, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $id);
                        $productdetail->product_image1 = $fileImage1Path;
                        $this->productdetailModel->save($productdetail);
                    }
                }

                if(isset($fileImage2)){
                    $fileName2 = $fileImage2->getClientName();
                    if(isset($fileName2) && !empty($fileName2)){
                        FileHelper::deleteFile($product_image2_old);
                        $fileImage2Path = FileHelper::saveFile($fileImage2, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $id);
                        $productdetail->product_image2 = $fileImage2Path;
                        $this->productdetailModel->save($productdetail);
                    }
                }

                if(isset($fileImage3)){
                    $fileName3 = $fileImage3->getClientName();
                    if(isset($fileName3) && !empty($fileName3)){
                        FileHelper::deleteFile($product_image3_old);
                        $fileImage3Path = FileHelper::saveFile($fileImage3, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $id);
                        $productdetail->product_image3 = $fileImage3Path;
                        $this->productdetailModel->save($productdetail);
                    }
                }

                if(isset($fileImage4)){
                    $fileName4 = $fileImage4->getClientName();
                    if(isset($fileName4) && !empty($fileName4)){
                        FileHelper::deleteFile($product_image4_old);
                        $fileImage4Path = FileHelper::saveFile($fileImage4, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $id);
                        $productdetail->product_image4 = $fileImage4Path;
                        $this->productdetailModel->save($productdetail);
                    }
                }

                if(isset($fileImage5)){
                    $fileName5 = $fileImage5->getClientName();
                    if(isset($fileName5) && !empty($fileName5)){
                        FileHelper::deleteFile($product_image5_old);
                        $fileImage5Path = FileHelper::saveFile($fileImage5, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $id);
                        $productdetail->product_image5 = $fileImage5Path;
                        $this->productdetailModel->save($productdetail);
                    }
                }

                if(isset($filePdf)){
                    $pdfName = $filePdf->getClientName();
                    if(isset($pdfName) && !empty($pdfName)){
                        FileHelper::deleteFile($product_pdf_old);
                        $filePdfPath = FileHelper::saveFile($filePdf, FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS, $id);
                        $productdetail->product_pdf = $filePdfPath;
                        $this->productdetailModel->save($productdetail);
                    }
                }

                $this->db->transComplete();
            }

            return true;

        }catch (\Throwable $ex){
            $this->db->transRollback();
            throw $ex;
        }
    }


    public function deleteProduct($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $product = $this->showwindowModel->find($id);
                    if(isset($product)){
                        $pathFolder = null;
                        if(isset($product->image_dir)) $pathFolder = pathinfo($product->image_dir, PATHINFO_DIRNAME);
                        if($pathFolder == null && isset($product->pdf_dir)) $pathFolder = pathinfo($product->pdf_dir, PATHINFO_DIRNAME);
                        FileHelper::deleteFile($product->image_dir);
                        FileHelper::deleteFile($product->pdf_dir);
                        if($pathFolder != null) FileHelper::deleteFile($pathFolder);
                        $fileHtml = FileHelper::FOLDER_PATH_UPLOAD.'/'.FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS.'/'.$id.'index.html';
                        FileHelper::deleteFile($fileHtml);
                        $this->showwindowModel->delete($id);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }

    public function deleteAllProduct(){
        ini_set('display_errors',1);
        try{
            $this->db->transBegin();
            $this->showwindowModel->truncate();
            $pathFolder = FileHelper::FOLDER_PATH_UPLOAD.'/'.FileHelper::FOLDER_PATCH_UPLOAD_PRODUCTS;
            FileHelper::deleteFile($pathFolder);
            $this->db->transComplete();
            return true;
        }catch (\Throwable $ex){
            $this->db->transRollback();
            throw $ex;
        }
    }

    public function importProduct($inputs, $data, $headerColumns){
        ini_set('display_errors',1);
        $message = [
            'status' => 1,
            'error' => 'Format file incorrect'
        ];
        if(isset($data) && is_array($data) && count($data) > 0){
            $uploadType = $inputs['upload_type'];
            $columnManufacturer = 'id';
            $columnPartNumber = 'part_number';
            $columnProductId = 'product_id';
            $tableColumns = [];
            //Check header
            $headerData = $data[0];
            $sameColumnNum = 0;
            foreach ($headerColumns as $keyValue => $column){
                $columns = explode('|',$column);
                if(is_array($columns) && count($columns) > 0){
                    foreach ($columns as $columnProduct){
                        foreach ($headerData as $index => $header){
                            if(trim(strtolower($header)) == trim(strtolower($columnProduct))){
                                $tableColumns[$keyValue] = $index;
                                break;
                            }
                        }
                    }
                }
            }
            if(count($tableColumns) != count($headerColumns)) return $message;
            //Import data
            $dataInserts = [];
            $mapManufacturerNames = [];
            $mapPartNumber = [];
            $mapProductId = [];
            for($index = 1 ; $index < count($data) ; $index ++){
                $dataProducts = [];
                foreach ($tableColumns as $tableColumn => $indexData){
                    $dataProducts[$tableColumn] = $data[$index][$indexData];
                }
                if(!in_array($dataProducts[$columnManufacturer], $mapManufacturerNames)) $mapManufacturerNames[] = $dataProducts[$columnManufacturer];
                $mapPartNumber[] = $dataProducts[$columnPartNumber];
                if(EXCEL_UPLOAD_TYPE_OVERWRITE == $uploadType){
                    $mapProductId[] = $dataProducts[$columnProductId];
                }
                $dataInserts[] = $dataProducts;
            }
            $manufacturers = $this->manufacturerModel->findAllByName($mapManufacturerNames);
            $mapManufacturers = ArrayHelper::parseListObjectToArrayKey($manufacturers, 'name');
            $mapProducts = [];
            if(EXCEL_UPLOAD_TYPE_OVERWRITE == $uploadType){
                $productExits = $this->showwindowModel->getByProductNo($mapProductId);
                $mapProducts = ArrayHelper::parseListObjectToArrayKey($productExits, $columnProductId);
            }
            //Insert Data To DB
            $countInsert = 0;
            $countUpdate = 0;

            foreach ($dataInserts as $dataInsert){
                $manufacturer = $mapManufacturers[$dataInsert[$columnManufacturer]];
                if(isset($manufacturer)){
                    if(EXCEL_UPLOAD_TYPE_ADDING == $uploadType){ //Mode add product

                            $product = new Product($dataInsert);
                            $product->maker_seq = $manufacturer->maker_seq;

                            $timestr = date(time());
                            $codestr = substr($timestr, 4);

                            $codecount = str_pad($countInsert, 6, "0", STR_PAD_LEFT);
                            //var_dump ($codecount);
                            //exit;

                            $product->product_code = "M".$codestr.$codecount;

                            $categorylevel1 = $this->categorylevel1Model->findByCategoryInfo($product->part_category);
                            // var_dump ($categorylevel1['categorylevel1_code']);
                            $product->part_category = $categorylevel1['categorylevel1_code'];

                            $categorylevel2 = $this->categorylevel2Model->findByCategoryInfo($product->part_category2);
                            // var_dump ($categorylevel2['categorylevel2_code']);
                            $product->part_category2 = $categorylevel2['categorylevel2_code'];

                            $categorylevel3 = $this->categorylevel3Model->findByCategoryInfo($product->part_category3);
                            // var_dump ($categorylevel3['categorylevel3_code']);
                            $product->part_category3 = $categorylevel3['categorylevel3_code'];
                            // exit;

                            // var_dump ($product);
                            // exit;
                            $this->showwindowModel->save($product);
                            $countInsert++;

                    }else if(EXCEL_UPLOAD_TYPE_OVERWRITE == $uploadType){
                        $product = $mapProducts[$dataInsert[$columnProductId]];
                        if(isset($product)){
                            $product->qty = $dataInsert['qty'];
                            $this->showwindowModel->save($product);
                            $countUpdate++;
                        }
                    }
                }
            }
            $message = 'Upload add success ' . $countInsert . ' records';
            if(EXCEL_UPLOAD_TYPE_OVERWRITE == $uploadType) { //Mode add product
                $message = 'Upload overwrite success ' . $countUpdate . ' records';
            }
            return [
                'status' => 0,
                'message' => $message
            ];
        }
        return $message;
    }

    public function saveInputSaveProduct($products){
        try{
            $this->db->transBegin();
            foreach ($products as $product){
                //Delete check duplicate
                //if($this->showwindowModel->findByPartNumber($product['part_number'])) continue;
                $entityProduct = new Product();
                $entityProduct->fill($product);
                $this->showwindowModel->save($entityProduct);
            }
            $this->db->transComplete();
        }catch (\Throwable $ex){
            $this->db->transRollback();
            throw $ex;
        }
    }


    public function acceptProduct($ids, $navershop_chk = "1"){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->showwindowModel->find($id);
                    if(isset($item)){
                        $item->navershop_chk = $navershop_chk;

                        if ($item->navershop_status == 'I') {
                            $item->navershop_status = 'U';
                        } else {
                            $item->navershop_status = 'I';
                        }

                        $this->showwindowModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }

    public function acceptProductId($id, $navershop_chk = "1"){
        if(isset($id)){
            try{
                $this->db->transBegin();
                    $item = $this->showwindowModel->find($id);
                    if(isset($item)){
                        $item->navershop_chk = $navershop_chk;

                        if ($item->navershop_status == 'I') {
                            $item->navershop_status = 'U';
                        } else {
                            $item->navershop_status = 'I';
                        }

                        $this->showwindowModel->save($item);
                    }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }

    public function notAcceptProduct($ids){
        if(isset($ids)){
            try{
                $this->db->transBegin();
                foreach ($ids as $id){
                    $item = $this->showwindowModel->find($id);
                    if(isset($item)){
                    
                        if ($item->navershop_status == 'I' || $item->navershop_status == 'U') {
                            $item->navershop_chk = '2';
                            $item->navershop_status = 'D';
                        } else {
                            $item->navershop_chk = '0';
                            $item->navershop_status = 'N';
                        }

                        $this->showwindowModel->save($item);
                    }
                }
                $this->db->transComplete();
                return true;
            }catch (\Throwable $ex){
                $this->db->transRollback();
                throw $ex;
            }
        }
        return false;
    }
}