<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_apiinfos('update')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('lte/icheck-bootstrap.min.css')?>" rel="stylesheet">

    <style>
        .ck-editor__editable[role="textbox"] {
          min-height: 400px;
        }
      
        .ck-content .image {
          max-width: 80%;
          margin: 20px auto;
        }
    </style>

<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_admin_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script>
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <?=$breadcrumb->render('admin.apiinfos.update')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                        <form method="post" action="<?=route_admin('apiinfos.update',$item->id)?>" enctype="multipart/form-data" id="form">
                            <div class="card">
                                <div class="card-header">
                                    <i class="fa fa-edit"></i> <?=lang_apiinfos('update')?>
                                    <div class="card-header-actions float-right">
                                        <a class="btn btn-block btn-secondary" href="<?=route_admin('apiinfos.index')?>">
                                            <?=lang_common('back')?>
                                        </a>
                                    </div>
                                </div>
                                    <div class="card-body">
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_apiinfos('api_code')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                                <input class="form-control" id="text-input" value="<?=old_value('title',$item->api_code)?>" type="text" name="api_code" placeholder="<?=lang_apiinfos('api_code')?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_apiinfos('provider_name')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                                <input class="form-control" id="text-input" value="<?=old_value('title',$item->provider_name)?>" type="text" name="provider_name" placeholder="<?=lang_apiinfos('provider_name')?>">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_apiinfos('delivery_days')?>
                                                <span class="color-red">*</span>
                                            </label>
                                            <div class="col-md-10">
                                            <input class="form-control" id="text-input" value="<?=old_value('title',$item->delivery_days)?>" type="text" name="delivery_days" placeholder="<?=lang_apiinfos('delivery_days')?>">
                                            </div>
                                        </div>
                                    </div>
                                <div class="card-footer text-center">
                                    <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('update')?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
