
<!DOCTYPE html>

<html lang="en">
<head>
    <base href="./">
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <meta name="description" content="SHOP admin manager">
    <meta name="author" content="SHOP">
    <meta name="keyword" content="SHOP admin manager">
    <link id="favicon" rel="shortcut icon" href="<?php asset_public('images/favicon.ico') ?>" type="image/x-icon" />
    <link rel="shortcut icon" href="<?php asset_public('images/favicon.ico') ?>">
    <link rel="apple-touch-icon" href=<?php asset_public('images/favicon.ico') ?> />
    <link rel="apple-touch-icon" sizes="152x152" href="<?php asset_public('images/favicon.ico') ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php asset_public('images/favicon.ico') ?>">
    <link rel="apple-touch-icon-precomposed" href="<?php asset_public('images/favicon.ico') ?>" />
    <title>SHOP - Login</title>

    <link href="<?=asset_admin_css('plugins/coreui-icons.min.css')?>" rel="stylesheet">
    <link href="<?=asset_admin_css('plugins/flag-icon.min.css')?>" rel="stylesheet">
    <link href="<?=asset_admin_css('plugins/font-awesome.min.css')?>" rel="stylesheet">
    <link href="<?=asset_admin_css('plugins/simple-line-icons.css')?>" rel="stylesheet">

    <link href="<?=asset_admin_css('plugins/style.css')?>" rel="stylesheet">
    <link href="<?=asset_admin_css('plugins/pace.min.css')?>" rel="stylesheet">
    <script>
        (function(i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function() {
                (i[r].q = i[r].q || []).push(arguments)
            }, i[r].l = 1 * new Date();
            a = s.createElement(o), m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', 'https://www.google-analytics.com/analytics.js', 'ga');
        ga('create', 'UA-118965717-1', 'auto');
        ga('send', 'pageview');
    </script>
</head>
<body class="app flex-row align-items-center">
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card-group">
                <div class="card">
                    <form method="POST" action="<?=route_admin('login')?>">
                        <div class="card-body">
                            <h1>Login</h1>
                            <p class="text-muted"><?=lang_common('login_title_sign_in')?></p>
                            <?php if(has_error('error_common')): ?>
                                <div class="alert alert-danger">
                                    <p><?=get_error('error_common')?></p>
                                </div>
                            <?php endif?>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <i class="icon-user"></i>
                                    </span>
                                </div>
                                <input name="member_email" class="form-control" type="text" placeholder="<?=lang_common('login_user_name')?>"
                                       value="" required autofocus>
                                <?php if(has_error('member_email')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?=get_error('member_email')?></strong>
                                    </span>
                                <?php endif ?>

                            </div>
                            <div class="input-group mb-2">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <i class="icon-lock"></i>
                                    </span>
                                </div>
                                <input name="password" class="form-control <?=has_error('password') ? 'is-invalid' : '' ?>" type="password" placeholder="<?=lang_common('login_password')?>" required>
                                <?php if(has_error('password')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?=get_error('password')?></strong>
                                    </span>
                                <?php endif ?>
                            </div>
                            <div class="input-group m-3">
                                <div class="form-check form-check-inline">
                                    <input name="remember" class="form-check-input" style="transform: scale(1.5);" id="inline-checkbox1" type="checkbox" value="1">
                                    <label class="form-check-label pl-2" for="inline-checkbox1">Keep me Signed in</label>
                                </div>
                            </div>
                            <div class="row text-center">
                                <div class="col-12">
                                    <button class="btn btn-primary px-5" type="submit"><?=lang_common('login')?></button>
                                </div>
<!--                                <div class="col-6 text-right">-->
<!--                                    <button class="btn btn-link px-0" type="button">Quên mật khẩu?</button>-->
<!--                                </div>-->
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
