<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>SHOP Manager - Login</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?=asset_admin_css('lte/plugins/fontawesome-free/css/all.min.css')?>">
    <!-- Ionicons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- icheck bootstrap -->
    <link rel="stylesheet" href="<?=asset_admin_css('lte/icheck-bootstrap.min.css')?>">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?=asset_admin_css('lte/adminlte.min.css')?>">
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
</head>
<body class="hold-transition login-page" style="height: 60vh;">
    <div class="login-box">
        <div class="login-logo">
            <a href="<?=route_admin('home')?>"><b>SHOP</b>Login</a>
        </div>
        <!-- /.login-logo -->
        <div class="card">
            <div class="card-body login-card-body">
                <p class="login-box-msg"><?=lang_common('login_title_sign_in')?></p>
                <?php if(has_error('error_common')): ?>
                    <div class="alert alert-danger">
                        <p><?=get_error('error_common')?></p>
                    </div>
                <?php endif?>

                <form action="<?=route_admin('login')?>" method="post">
                    <div class="input-group mb-3">
                        <input type="text" class="form-control <?=has_error('member_email') ? 'is-invalid' : '' ?>" name="member_email"
                              value="<?=old('login_user_name')?>" placeholder="<?=lang_common('login_user_name')?>">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-envelope"></span>
                            </div>
                        </div>
                        <?php if(has_error('member_email')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?=get_error('member_email')?></strong>
                            </span>
                        <?php endif ?>
                    </div>
                    <div class="input-group mb-3">
                        <input type="password" class="form-control <?=has_error('password') ? 'is-invalid' : '' ?>" name="password" placeholder="<?=lang_common('login_password')?>" placeholder="Password">
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-lock"></span>
                            </div>
                        </div>
                        <?php if(has_error('password')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?=get_error('password')?></strong>
                            </span>
                        <?php endif ?>
                    </div>
                    <div class="row">
                        <div class="col-8">
                            <div class="icheck-primary">
                                <input type="checkbox" id="remember" name="remember">
                                <label for="remember">
                                    <?=lang_common('login_remember')?>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="social-auth-links text-center mb-3">
                        <button type="submit" class="btn btn-block btn-primary">
                            <?=lang_common('login')?>
                        </button>
                    </div>
                </form>
            </div>
            <!-- /.login-card-body -->
        </div>
    </div>
    <!-- /.login-box -->

    <!-- jQuery -->
    <script src="<?=asset_admin_js('lte/jquery.min.js')?>"></script>
    <!-- Bootstrap 4 -->
    <script src="<?=asset_admin_js('lte/bootstrap.bundle.min.js')?>"></script>
    <!-- AdminLTE App -->
    <script src="<?=asset_admin_js('lte/adminlte.min.js')?>"></script>

</body>
</html>
