<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_category3('category2create')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('lte/icheck-bootstrap.min.css')?>" rel="stylesheet">
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_admin_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('category2', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <?=$breadcrumb->render('admin.category3.category1category2')?>
    <div class="container-fluid">
        <div id="ui-view">
            <div>
                <div class="animated fadeIn">
                    <div class="row">
                        <div class="col-md-12">
                            <form method="post" action="<?=route_admin('category3s.category1create')?>" enctype="multipart/form-data" id="form">
                            <div class="card">
                                    <div class="card-header">
                                        <i class="fa fa-edit"></i> <?=lang_category3('category1create')?>
                                        <div class="card-header-actions float-right">
                                            <a class="btn btn-block btn-secondary" href="<?=route_admin('category3.show_create')?>">
                                                <?=lang_common('back')?>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend ">
                                                        <span class="input-group-text width-100"><?=lang_category3('name')?></span>
                                                    </div>
                                                    <input class="form-control" id="category1_name" type="text" name="category1_name" value="<?=$item->category1_name?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend ">
                                                        <span class="input-group-text width-100"><?=lang_category3('name_eng')?></span>
                                                    </div>
                                                    <input class="form-control" id="category1_name_eng" type="text" name="category1_name_eng" value="<?=$item->category1_name_eng?>">
                                                </div>
                                            </div>
                                    </div>

                                    <div class="card-footer text-center">
                                        <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('create')?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?= $this->endSection() ?>
