<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_category3('create')?>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <?=$breadcrumb->render('admin.category3.create')?>
    <div class="container-fluid">
        <div id="ui-view">
            <div>
                <div class="animated fadeIn">
                    <div class="row">
                        <div class="col-md-12">
                            <form method="post" action="<?=route_admin('category3s.create')?>" enctype="multipart/form-data" id="form">
                                <div class="card">
                                    <div class="card-header">
                                        <i class="fa fa-edit"></i> <?=lang_category3('create')?>
                                        <div class="card-header-actions float-right">
                                            <a class="btn btn-block btn-secondary" href="<?=route_admin('category3.index')?>">
                                                <?=lang_common('back')?>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend ">
                                                        <span class="input-group-text width-100"><?=lang_common('category1_name')?></span>
                                                    </div>
                                                    <?php
                                                    // var_dump($category3_category1).'</br>';               
                                                    // echo print_r($category3_category1["category1_id"]).'</br>';
                                                    // echo print_r($category3_category1["category1_name"]).'</br>';
                                                    ?>
                                                    <select name="category1" id="category1" class="form-control input-lg">
                                                        <option value="">Select Category1</option>
                                                        <?php
                                                        
                                                        foreach($category1 as $row)
                                                        {
                                                            echo '<option value="'.$row["category1_id"].'">'.$row["category1_name"].'</option>';
                                                        }
                                                        
                                                        ?>
                                                    </select>

                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend ">
                                                        <span class="input-group-text width-100"><?=lang_common('category2_name')?></span>
                                                    </div>
                                                    <?php
                                                    // var_dump($category3_category2).'</br>';               
                                                    // echo print_r($category3_category2["category2_id"]).'</br>';
                                                    // echo print_r($category3_category2["category2_name"]).'</br>';
                                                    ?>
                                                    <select name="category2_id" id="category2" class="form-control input-lg">
                                                        <option value="">Select Category2</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend ">
                                                        <span class="input-group-text width-100"><?=lang_common('name')?></span>
                                                    </div>
                                                    <input class="form-control" id="category3_name" type="text" name="category3_name" value="<?=$item->category3_name?>">
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text width-100">
                                                        <?=lang_category3('name_eng')?>
                                                        </span>
                                                    </div>
                                                    <input class="form-control" id="category3_name_eng" type="text" name="category3_name_eng" value="<?=$item->category3_name_eng?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text width-100">
                                                        <?=lang_category3('tariff_rate')?>
                                                        </span>
                                                    </div>
                                                    <input class="form-control" id="category3_tariff_rate" type="text" name="tariff_rate" value="<?=$item->tariff_rate?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text width-100">
                                                        <?=lang_category3('margin_rate')?>
                                                        </span>
                                                    </div>
                                                    <input class="form-control" id="category3_margin_rate" type="text" name="margin_rate" value="<?=$item->margin_rate?>">
                                                </div>
                                            </div>

                                    </div>
                                    <div class="card-footer text-center">
                                        <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('create')?></button>
                                    </div>
                                </div>
                            </form>

<!---------------------------->

<script>
$(document).ready(function(){
    $('#category1').change(function(){

        var category1_id = $('#category1').val();
        var action = 'get_category2';

        if(category1_id != '')
        {
            $.ajax({
                url:"<?php echo base_url('/Category3Select/action'); ?>",
                method:"POST",
                data:{category1_id:category1_id, action:action},
                dataType:"JSON",
                success:function(data)
                {
                    var html = '<option value="">Select Category2</option>';
                    for(var count = 0; count < data.length; count++)
                    {
                        html += '<option value="'+data[count].category2_id+'">'+data[count].category2_name+'</option>';
                    }
                    $('#category2').html(html);
                }
            });
        }
        else
        {
            $('#category2').val('');
        }
        $('#category3').val('');
    });

    $('#category2').change(function(){

        var category2_id = $('#category2').val();
        var action = 'get_category3';

        if(category2_id != '')
        {
            $.ajax({
                url:"<?php echo base_url('/Category3Select/action'); ?>",
                method:"POST",
                data:{category2_id:category2_id, action:action},
                dataType:"JSON",
                success:function(data)
                {
                    var html = '<option value="">Select Category3</option>';

                    for(var count = 0; count < data.length; count++)
                    {
                        html += '<option value="'+data[count].category3_id+'">'+data[count].category3_name+'</option>';
                    }
                    $('#category3').html(html);
                }
            });
        }
        else
        {
            $('#category3').val('');
        }
    });
});
</script>

<!-------------------------------->

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?= $this->endSection() ?>
