<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
<?=lang_category3('update')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('lte/icheck-bootstrap.min.css')?>" rel="stylesheet">
    <style>
        input[readonly] { /* For Firefox */
            background-color: #ffffff !important;
        }
    </style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('lte/bootstrap-switch.min.js')?>"></script>
    <script>
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('category2', $(this).prop('checked'));
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.category3.update')?>
<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                        <form method="post" action="<?=route_admin('category3.update', $item->category3_id)?>" enctype="multipart/form-data" id="form">
                            <div class="card">
                            <div class="card-header">
                                <i class="fa fa-edit"></i> <?=lang_category3('update')?>
                                <div class="card-header-actions float-right">
                                    <a class="btn btn-block btn-secondary" href="<?=route_admin('category3.index')?>">
                                        <?=lang_common('back')?>
                                    </a>
                                </div>
                            </div>

                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text width-100">
                                                        <?=lang_category3('code')?>
                                                        </span>
                                                    </div>
                                                    <input readonly class="form-control" id="category3_code" type="text" name="category3_code" value="<?=$item->category3_id?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend ">
                                                        <span class="input-group-text width-100"><?=lang_common('category1_name')?></span>
                                                    </div>
                                                    <?php
                                                    // var_dump($category3_category1).'</br>';               
                                                    // echo print_r($category3_category1["category1_id"]).'</br>';
                                                    // echo print_r($category3_category1["category1_name"]).'</br>';
                                                    ?>

                                                    <!--input readonly class="form-control" id="category1" type="text" name="category1" value="<?= $category3_category1["category1_name"];?>"-->

                                                    <select name="category1" id="category1" class="form-control input-lg">
                                                        <?php
                                                        foreach($category1 as $row) {
                                                            if ($category3_category1["category1_id"] == $row["category1_id"] ) {
                                                                echo '<option value="'.$row["category1_id"].'" selected>'.$row["category1_name"].'</option>';
                                                            }else{
                                                                echo '<option value="'.$row["category1_id"].'">'.$row["category1_name"].'</option>';
                                                            }
                                                        }
                                                        ?>
                                                    </select>

                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend ">
                                                        <span class="input-group-text width-100"><?=lang_common('category2_name')?></span>
                                                    </div>
                                                    <?php
                                                    // var_dump($category3_category2).'</br>';               
                                                    // echo print_r($category3_category2["category2_id"]).'</br>';
                                                    // echo print_r($category3_category2["category2_name"]).'</br>';
                                                    ?>

                                                    <!--input readonly id="text-input" type="hidden" class="form-control" name="category2_id" value="<?= $category3_category2["category2_id"]?>">
                                                    <input readonly id="text-input" type="text" class="form-control" name="category2_name" value="<?= $category3_category2["category2_name"];?>"-->

                                                    <select name="category2_id" id="category2" class="form-control input-lg">
                                                        <?php
                                                        foreach($category2 as $row) {
                                                            if ($category3_category2["category2_id"] == $row["category2_id"] ) {
                                                                echo '<option value="'.$row["category2_id"].'" selected>'.$row["category2_name"].'</option>';
                                                            }else{
                                                                echo '<option value="'.$row["category2_id"].'">'.$row["category2_name"].'</option>';
                                                            }
                                                        }
                                                        ?>
                                                    </select>

                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend ">
                                                        <span class="input-group-text width-100"><?=lang_common('category3_name')?></span>
                                                    </div>
                                                    <?php
                                                    // var_dump($category3_category3).'</br>';
                                                    // echo print_r($category3_category3["category3_id"]).'</br>';
                                                    // echo print_r($category3_category3["category3_name"]).'</br>';
                                                    ?>
                                                    <!--input readonly id="text-input" type="hidden" class="form-control" name="category3_id" value="<?= $category3_category3["category3_id"]?>"-->
                                                    <input id="text-input" type="text" class="form-control" name="category3_name" value="<?= $category3_category3["category3_name"];?>">
                                                    
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text width-100">
                                                        <?=lang_category3('add')?>
                                                        </span>
                                                    </div>
                                                    <input class="form-control" id="category3_add" type="text" name="category3_add" value="<?=$item->category3_add?>">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text width-100">
                                                        <?=lang_category3('tel')?>
                                                        </span>
                                                    </div>
                                                    <input class="form-control" id="category3_tel" type="text" name="category3_tel" value="<?=$item->category3_tel?>">
                                                </div>
                                            </div>

                                        </div>

                                    </div>

                                <div class="card-footer text-center">
                                    <button type="submit" class="btn bg-gradient-primary pl-3 pr-3"><?=lang_common('update')?></button>
                                </div>

                            </div>
                            </form>

                        </div>
                    </div>

                    
<!---------------------------->

<script>
$(document).ready(function(){
    $('#category1').change(function(){

        var category1_id = $('#category1').val();
        var action = 'get_category2';

        if(category1_id != '')
        {
            $.ajax({
                url:"<?php echo base_url('/Category3Select/action'); ?>",
                method:"POST",
                data:{category1_id:category1_id, action:action},
                dataType:"JSON",
                success:function(data)
                {
                    var html = '<option value="">Select Category2</option>';
                    for(var count = 0; count < data.length; count++)
                    {
                        html += '<option value="'+data[count].category2_id+'">'+data[count].category2_name+'</option>';
                    }
                    $('#category2').html(html);
                }
            });
        }
        else
        {
            $('#category2').val('');
        }
        $('#category3').val('');
    });

    $('#category2').change(function(){

        var category2_id = $('#category2').val();
        var action = 'get_category3';

        if(category2_id != '')
        {
            $.ajax({
                url:"<?php echo base_url('/Category3Select/action'); ?>",
                method:"POST",
                data:{category2_id:category2_id, action:action},
                dataType:"JSON",
                success:function(data)
                {
                    var html = '<option value="">Select Category3</option>';
                    for(var count = 0; count < data.length; count++)
                    {
                        html += '<option value="'+data[count].category3_id+'">'+data[count].category3_name+'</option>';
                    }
                    $('#category3').html(html);
                }
            });
        }
        else
        {
            $('#category3').val('');
        }
    });
});
</script>

<!-------------------------------->


                </div>                
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
