<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
<?=lang_productmp('looptmp_upload_title')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>

<link href="<?=asset_admin_css('lte/icheck-bootstrap.min.css')?>" rel="stylesheet">

<style>
    .ck-editor__editable[role="textbox"] {
      min-height: 400px;
    }
  
    .ck-content .image {
      max-width: 80%;
      margin: 20px auto;
    }
</style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_admin_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.productmp.list')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> <?= lang_productmp('upload_title')?>
                    </div>
                    <div class="card-body">

                        <div class="card card-body">
                            <div class="row col-md-12 pl-4">
                                <a href="<?=route_admin('product.loop_upload.download_template')?>">
                                    [ <i class="fas fa-download"></i> 상품정보 등록양식 내려받기 ]
                                </a>
                            </div>
                        </div>


    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">

        <div class="row">

          <div class="col-md-4 col-sm-6 col-12">
            <div class="info-box">

                <div class="card-footer text-center" style="width: 100%;">
					<div class="card-header text-center" style="margin-bottom: 15px;">
						<strong>상품정보 파일을 업로드하기 전 아래 버튼을 클릭하세요.</strong>
					</div>
                    <form action="<?=route_admin('productmp.productmp_upload.deloldfile')?>" method="post" enctype="multipart/form-data">
						<input type="submit" name="submit" value="작업파일삭제" class="btn btn-primary" />
					</form>
                </div>

            </div>
            <!-- /.info-box -->
          </div>

          <!-- /.col -->
          <div class="col-md-4 col-sm-6 col-12">
            <div class="info-box">

                <div class="card-footer text-center" style="width: 100%;">
                    <form method="post" id="form" enctype="multipart/form-data" action="<?=route_admin('productmp.productmp_upload.import')?>">
                        <div class="form-group row">
                            <label class="col-md-2 col-form-label" for="text-input">
                                <?=lang_common('file_upload')?>
                            </label>
                            <div class="col-md-10 file_upload">
                                <?php for($i =1 ; $i <= $maxFiles ; $i ++): ?>
                                    <div class="input-group pb-2 file_item <?php if($i > 1) echo 'hide'?>">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" id="files_<?=$i?>" name="files_<?=$i?>" maxsizeMb="3" accept=".csv,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-exce">
                                            <label class="custom-file-label" for="files_<?=$i?>">파일선택</label>
                                        </div>
                                        <div class="file_action">
                                            <?php if($i > 1): ?>
                                                <a href="javascript:void(0)" class="button-delete color-red">
                                                    <i class="fa fa-minus-square"></i>
                                                </a>
                                            <?php else: ?>
                                                <a href="javascript:void(0)" class="button-add">
                                                    <i class="fas fa-plus-circle"></i>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endfor; ?>
                            </div>
                        </div>
                        <div class="text-center">
                        <button class="btn btn-primary" type="submit">파일업로드</button>
                        </div>
                    </form>
                </div>

            </div>
            <!-- /.info-box -->
          </div>


          <!-- /.col -->
          <div class="col-md-4 col-sm-6 col-12">
            <div class="info-box">

                <div class="card-footer text-center" style="width: 100%;">
                    <div class="card-header text-center" style="margin-bottom: 15px;">
						<strong>상품정보 파일을 업로드한 후 아래 버튼을 클릭하세요.</strong>
					</div>
                        <form action="<?=route_admin('productmp.looptmp.importCsvToDb')?>" method="post" enctype="multipart/form-data">
							<input type="submit" name="submit" value="템프등록" class="btn btn-primary" />
						</form>
                </div>

            </div>
            <!-- /.info-box -->
          </div>

          <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>


    <div class="container-fluid">

        <div class="row">

          <!-- /.col -->
          <div class="col-md-4 col-sm-6 col-12">
            <div class="info-box">

                <div class="card-footer text-center" style="width: 100%;">
                    <div class="card-header text-center" style="margin-bottom: 15px;">
						<strong>상품정보 파일의 신규등록 상품을 추가등록합니다.</strong>
					</div>

                    <a class="btn btn-primary" href="<?=route_admin('productmp.looptmp.insertProducts')?>">
                        추가상품등록
                    </a>
                </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>

        <!-- /.col -->
        <div class="col-md-4 col-sm-6 col-12">

        </div>

        <!-- /.col -->
        <div class="col-md-4 col-sm-6 col-12">
            <div class="info-box">

                <div class="card-footer text-center" style="width: 100%;">
                    <div class="card-header text-center" style="margin-bottom: 15px;">
						<strong>상품 제공사별 상품정보를 업데이트합니다.</strong>
					</div>

                    <form action="<?=route_admin('productmp.looptmp.updateProducts')?>" method="post" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-md-2">
                        </div>
                        <div class="col-md-4 text-center col-sm-6 col-12">
                            <select class="form-control" name="api_code">
                                <?php foreach ($apiinfos as $apiinfo): ?>
                                        <option value="<?=$apiinfo->api_code?>">
                                            <?=$apiinfo->provider_name?>
                                        </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-4 text-center col-sm-6 col-12">
                            <input type="submit" name="submit" value="상품정보업데이트" class="btn btn-primary" />
                        </div>
                        <div class="col-md-2">
                        </div>
                    </div>
					</form>


                </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>
          

          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>


                <!-- /.col -->
                </div>
        <!-- /.row -->
      </div>


            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> 대체품/이벤트 등록
                    </div>
                    <div class="card-body">

                        <div class="card card-body">
                            <div class="row col-md-12 pl-4">
                                <a href="<?=route_admin('productmp.productmp_event.downloadtemp')?>">
                                    [ <i class="fas fa-download"></i> 대체품/이벤트/네이버쇼핑 등록양식 내려받기 ]
                                </a>
                            </div>
                        </div>



        <div class="container-fluid">
            <div class="row">

                <!-- /.col -->
                <div class="col-md-4 col-sm-6 col-12">
                    <div class="info-box">

                    <div class="card-footer text-center" style="width: 100%;">
                        <form method="post" id="form" enctype="multipart/form-data" action="<?=route_admin('productmp.productmp_event.import')?>">
                            <div class="form-group row">
                                <label class="col-md-2 col-form-label" for="text-input">
                                    <?=lang_common('file_upload')?>
                                </label>
                                <div class="col-md-10 file_upload">
                                    <?php for($i =1 ; $i <= $maxFiles ; $i ++): ?>
                                        <div class="input-group pb-2 file_item <?php if($i > 1) echo 'hide'?>">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" id="files_<?=$i?>" name="files_<?=$i?>" maxsizeMb="3" accept=".csv,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-exce">
                                                <label class="custom-file-label" for="files_<?=$i?>">파일선택</label>
                                            </div>
                                            <div class="file_action">
                                                <?php if($i > 1): ?>
                                                    <a href="javascript:void(0)" class="button-delete color-red">
                                                        <i class="fa fa-minus-square"></i>
                                                    </a>
                                                <?php else: ?>
                                                    <a href="javascript:void(0)" class="button-add">
                                                        <i class="fas fa-plus-circle"></i>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endfor; ?>
                                </div>
                            </div>
                        <div class="text-center">
                            <a class="btn btn-primary" href="<?=route_admin('productmp.productmp_event.deletefile')?>">
                                작업파일삭제
                            </a>

                            <button class="btn btn-primary" type="submit">파일업로드</button>

                            <a class="btn btn-primary" href="<?=route_admin('productmp.productmp_event.eventcsvtodb')?>">
                                템프등록
                            </a>
                        </div>
                        </form>
                    </div>

                    </div>
                </div>

                <!-- /.col -->
                <div class="col-md-2 col-sm-6 col-12">
                    <div class="info-box">
                        <div class="card-footer text-center" style="width: 100%;">
                            <div class="card-header text-center" style="margin-bottom: 15px;">
                                <strong>대체품 등록합니다.</strong>
                            </div>

                            <a class="btn btn-primary" href="<?=route_admin('productmp.productmp_event.upreplacitems')?>">
                            대체품 등록
                            </a>

                        </div>
                    </div>
                </div>
                
                <!-- /.col -->
                <div class="col-md-2 col-sm-6 col-12">
                    <div class="info-box">
                        <div class="card-footer text-center" style="width: 100%;">
                            <div class="card-header text-center" style="margin-bottom: 15px;">
                                <strong>등록할 이벤트를 선택후 업데이트 하세요.</strong>
                            </div>

                            <form action="<?=route_admin('productmp.event.upeventitems')?>" method="post" enctype="multipart/form-data">
                            <div class="row">
                                <div class="col-md-2">
                                </div>
                                <div class="col-md-4 text-center col-sm-6 col-12">
                                    <select class="form-control" id="event_set" name="event_set">
                                            <option value="">이벤트 없음.</option>
                                        <?php foreach ($eventinfos as $eventinfo): ?>
                                            <option value="<?=$eventinfo->id?>"><?=$eventinfo->event_title?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="col-md-4 text-center col-sm-6 col-12">
                                    <input type="submit" name="submit" value="이벤트 등록" class="btn btn-primary" />
                                </div>
                                <div class="col-md-2">
                                </div>
                            </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- /.col -->
                <div class="col-md-2 col-sm-6 col-12">
                    <div class="info-box">
                        <div class="card-footer text-center" style="width: 100%;">
                            <div class="card-header text-center" style="margin-bottom: 15px;">
                                <strong>네이버쇼핑 등록/수정 사항을 선택후 업데이트 하세요.</strong>
                            </div>

                            <form action="<?=route_admin('productmp.event.upnavershop')?>" method="post" enctype="multipart/form-data">
                            <div class="row">
                                <div class="col-md-2">
                                </div>
                                <div class="col-md-4 text-center col-sm-6 col-12">
                                    <select class="form-control" id="navershop_chk" name="navershop_chk">
                                        <option value="">처리선택</option>
                                        <option value="1">등록</option>
                                        <option value="2">품절</option>
                                        <option value="3">업데이트</option>
                                        <option value="0">미노출</option>
                                    </select>
                                </div>
                                <div class="col-md-4 text-center col-sm-6 col-12">
                                    <input type="submit" name="submit" value="네이버쇼핑 등록" class="btn btn-primary" />
                                </div>
                                <div class="col-md-2">
                                </div>
                            </div>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>



						</div>
					</div>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>