<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_orderinfo('list_title')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('plugins/daterangepicker.min.css')?>" rel="stylesheet">
    <style>
        th{text-align: center}
        .checkbox{width: 5%}
        .date{width: 10%}
        .quote_no{width: 10%}
        .amount{width: 10%}
        .name{width: 15%}
        .email{width: 15%}
        .action{width: 10%}
        input[type=checkbox]{
            transform: scale(1.5);
        }
        a.disabled {
            pointer-events: none;
            cursor: default;
        }
    </style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('sale-quote.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/moment.min.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/daterangepicker.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/jquery.maskedinput.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/select2.min.js')?>"></script>
    <script src="<?=asset_admin_js('advanced-forms.js')?>"></script>

<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.home')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> 대시보드
                    </div>
                    <div class="card-body">


    <!-- Main content No1 -->

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">

        <h5 class="mb-2">오늘의 정보</h5>
        <div class="row">

          <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box">
              <span class="info-box-icon bg-info"><i class="far fa-copy"></i></span>

              <div class="info-box-content">
                <span class="info-box-text">당일 주문 (건)</span>
                <span class="info-box-number"><?=\App\Helpers\NumberHelper::format($todayOrder_count)?></span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>
          <!-- /.col -->
          <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box">
              <span class="info-box-icon bg-success"><i class="fas fa-shopping-cart"></i></span>

              <div class="info-box-content">
                <span class="info-box-text">당일 결제 (건)</span>
                <span class="info-box-number"><?=\App\Helpers\NumberHelper::format($todayPay_count)?></span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>
          <!-- /.col -->
          <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box">
              <span class="info-box-icon bg-warning"><i class="fas fa-money-bill"></i></span>
              <i class="far fa-usd-square"></i>
              <div class="info-box-content">
                <span class="info-box-text">당일 매출 (원)</span>
                <span class="info-box-number"><?=\App\Helpers\NumberHelper::format($todaySales)?></span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>
          <!-- /.col -->
          <div class="col-md-3 col-sm-6 col-12">
            <div class="info-box">
              <span class="info-box-icon bg-danger"><i class="far fa-user"></i></span>

              <div class="info-box-content">
                <span class="info-box-text">당일 가입회원 (명)</span>
                <span class="info-box-number"><?=\App\Helpers\NumberHelper::format($todaySignUp_count)?></span>
              </div>
              <!-- /.info-box-content -->
            </div>
            <!-- /.info-box -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>

    <!------------------------------------->
    <!------------------------------------->

    <h5 class="mb-2">이달의 정보 / 검색어 통계</h5>
    <div class="row">

      <div class="col-md-3">
        <!-- Widget: user widget style 2 -->
        <div class="card card-widget widget-user-2">
          <!-- Add the bg color to the header using any of the bg-* classes -->
          <div class="widget-user-header bg-primary">
            <div class="widget-user-image">
              <img class="img-circle elevation-2" src="<?=asset_public('images/user7-128x128.jpg')?>" alt="User Avatar">
            </div>
            <!-- /.widget-user-image -->
            <h3 class="widget-user-username">주문처리상황 (1개월 기준)</h3>
          </div>
          <div class="card-footer p-0">
            <ul class="nav flex-column">
              <li class="nav-item">
                <a href="<?=route_admin('orderinfo.index')?>" class="nav-link" style="text-align: center">
                  주문수
                  <span class="float-right badge bg-primary"><?=\App\Helpers\NumberHelper::format($day30Order_count)?></span>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?=route_admin('orderinfo.index')?>?status_code=4" class="nav-link" style="text-align: center">
                  준비중 <span class="float-right badge bg-dark"><?=\App\Helpers\NumberHelper::format($day30Preparing_count)?></span>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?=route_admin('orderinfo.index')?>?status_code=5" class="nav-link" style="text-align: center">
                  배송중 <span class="float-right badge bg-info"><?=\App\Helpers\NumberHelper::format($day30Shipping_count)?></span>
                </a>
              </li>
              <!--li class="nav-item">
                <a href="<?=route_admin('orderinfo.index')?>?status_code=8" class="nav-link" style="text-align: center">
                  판매완료 <span class="float-right badge bg-success"><?=\App\Helpers\NumberHelper::format($day30Complete_count)?></span>
                </a>
              </li-->
              <li class="nav-item">
                <a href="<?=route_admin('orderinfo.index')?>?status_code=9" class="nav-link" style="text-align: center">
                  주문취소 <span class="float-right badge bg-danger"><?=\App\Helpers\NumberHelper::format($day30Cancel_count)?></span>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?=route_admin('orderinfo.index')?>?status_code=12" class="nav-link" style="text-align: center">
                  교환/반품 <span class="float-right badge bg-warning"><?=\App\Helpers\NumberHelper::format($day30Return_count)?></span>
                </a>
              </li>
              <!--li class="nav-item">
                <a href="<?=route_admin('orderinfo.index')?>?status_code=11" class="nav-link" style="text-align: center">
                  주문무효 <span class="float-right badge bg-secondary"><?=\App\Helpers\NumberHelper::format($day30Nullity_count)?></span>
                </a>
              </li-->
            </ul>
          </div>
        </div>
        <!-- /.widget-user -->
      </div>
      <!-- /.col -->

      <div class="col-md-3">
        <!-- Widget: user widget style 2 -->
        <div class="card card-widget widget-user-2">
          <!-- Add the bg color to the header using any of the bg-* classes -->
          <div class="widget-user-header bg-info">
            <div class="widget-user-image">
              <img class="img-circle elevation-2" src="<?=asset_public('images/user7-128x128.jpg')?>" alt="User Avatar">
            </div>
            <!-- /.widget-user-image -->
            <h3 class="widget-user-username">게시판현황 (1개월 기준)</h3>
          </div>
          <div class="card-footer p-0">
            <ul class="nav flex-column">
              <li class="nav-item">
                <a href="<?=route_admin('one2one.index')?>" class="nav-link" style="text-align: center">
                1:1 상담 <span class="float-right badge bg-primary"><?=\App\Helpers\NumberHelper::format($day30One2one_count)?></span>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?=route_admin('inquiry.index')?>" class="nav-link" style="text-align: center">
                상품문의 <span class="float-right badge bg-info"><?=\App\Helpers\NumberHelper::format($day30Inquiry_count)?></span>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?=route_admin('estimate.index')?>" class="nav-link" style="text-align: center">
                견적문의 <span class="float-right badge bg-success"><?=\App\Helpers\NumberHelper::format($day30Estimate_count)?></span>
                </a>
              </li>
              <!--li class="nav-item">
                <a href="<?=route_admin('deferredpay.index')?>" class="nav-link" style="text-align: center">
                후불문의 <span class="float-right badge bg-danger"><?=\App\Helpers\NumberHelper::format($day30Deferredpay_count)?></span>
                </a>
              </li-->
              <!--li class="nav-item">
                <a href="<?=route_admin('review.index')?>" class="nav-link" style="text-align: center">
                상품후기 <span class="float-right badge bg-warning"><?=\App\Helpers\NumberHelper::format($day30Review_count)?></span>
                </a>
              </li-->
              <li class="nav-item">
                <a href="<?=route_admin('news.index')?>" class="nav-link" style="text-align: center">
                공지사항 <span class="float-right badge bg-secondary"><?=\App\Helpers\NumberHelper::format($day30News_count)?></span>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?=route_admin('news.index')?>" class="nav-link" style="text-align: center">
                  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                </a>
              </li>
            </ul>
          </div>
        </div>
        <!-- /.widget-user -->
      </div>
      <!-- /.col -->

      <div class="col-md-3">
        <!-- Widget: user widget style 2 -->
        <div class="card card-widget widget-user-2">
          <!-- Add the bg color to the header using any of the bg-* classes -->
          <div class="widget-user-header bg-success">
            <div class="widget-user-image">
              <img class="img-circle elevation-2" src="<?=asset_public('images/user7-128x128.jpg')?>" alt="User Avatar">
            </div>
            <!-- /.widget-user-image -->
            <h3 class="widget-user-username">상품정보현황</h3>

            <?php
            foreach ($todayProductStat['lists'] as $key => $todayProductStat_item):
              // echo substr($todayProductStat_item->created_at, 5, 5);
              $allProduct_count = $todayProductStat_item->totalproduct;
              $Event_count = $todayProductStat_item->eventproduct;
              $Newproduct_count = $todayProductStat_item->newproduct;
              $Bestproduct_count = $todayProductStat_item->bestproduct;
              $Recomproduct_count = $todayProductStat_item->recomproduct;
              $Brandproduct_count = $todayProductStat_item->brandproduct;
              $Nshopping_count =$todayProductStat_item->nshopproduct;
            endforeach;
            ?>

          </div>
          <div class="card-footer p-0">
            <ul class="nav flex-column">
              <li class="nav-item">
                <a href="<?=route_admin('product.index')?>" class="nav-link" style="text-align: center">
                  전체상품 <span class="float-right badge bg-primary"><?=\App\Helpers\NumberHelper::format($allProduct_count)?></span>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?=route_admin('product.index')?>?sctype=event" class="nav-link" style="text-align: center">
                이벤트 상품 <span class="float-right badge bg-info"><?=\App\Helpers\NumberHelper::format($Event_count)?></span>
                </a>
              </li>
              <!--li class="nav-item">
                <a href="<?=route_admin('product.index')?>?sctype=newproduct" class="nav-link" style="text-align: center">
                신상품 <span class="float-right badge bg-success"><?=\App\Helpers\NumberHelper::format($Newproduct_count)?></span>
                </a>
              </li-->
              <!--li class="nav-item">
                <a href="<?=route_admin('product.index')?>?sctype=bestproduct" class="nav-link" style="text-align: center">
                베스트상품 <span class="float-right badge bg-danger"><?=\App\Helpers\NumberHelper::format($Bestproduct_count)?></span>
                </a>
              </li-->
              <!--li class="nav-item">
                <a href="<?=route_admin('product.index')?>?sctype=recomproduct" class="nav-link" style="text-align: center">
                추천상품 <span class="float-right badge bg-warning"><?=\App\Helpers\NumberHelper::format($Recomproduct_count)?></span>
                </a>
              </li-->
              <!--li class="nav-item">
                <a href="<?=route_admin('product.index')?>?sctype=brandproduct" class="nav-link" style="text-align: center">
                브랜드상품 <span class="float-right badge bg-secondary"><?=\App\Helpers\NumberHelper::format($Brandproduct_count)?></span>
                </a>
              </li-->
              <li class="nav-item">
                <a href="<?=route_admin('product.index')?>?sctype=navershop" class="nav-link" style="text-align: center">
                네이버쇼핑 상품 <span class="float-right badge bg-dark"><?=\App\Helpers\NumberHelper::format($Nshopping_count)?></span>
                </a>
              </li>
              <li class="nav-item">
                <div class="nav-link" style="text-align: center">
                LCSC API상태 
                <?php
                  if ($lcapierror_count == "0") {
                    echo "<span class='float-right badge bg-secondary'>정상</span>";
                  } else {
                    echo "<span class='float-right badge bg-danger'>비정상</span>";
                  }
                ?>

                </div>
              </li>
              <li class="nav-item">
              <div class="nav-link" style="text-align: center">
                IcKing API상태 
                <?php
                  if ($ickapierror_count == "0") {
                    echo "<span class='float-right badge bg-secondary'>정상</span>";
                  } else {
                    echo "<span class='float-right badge bg-danger'>비정상</span>";
                  }
                ?>
                </div>
              </li>
            </ul>
          </div>
        </div>
        <!-- /.widget-user -->
      </div>
      <!-- /.row -->

      <div class="col-md-3">
        <!-- Widget: user widget style 2 -->
        <div class="card card-widget widget-user-2">
          <!-- Add the bg color to the header using any of the bg-* classes -->
          <div class="widget-user-header bg-warning">
            <div class="widget-user-image">
              <img class="img-circle elevation-2" src="<?=asset_public('images/user7-128x128.jpg')?>" alt="User Avatar">
            </div>
            <!-- /.widget-user-image -->
            <h3 class="widget-user-username">오늘 검색어 TOP5</h3>
          </div>
          <div class="card-footer p-0">
            <ul class="nav flex-column">
                  <?php foreach ($Searchranking['lists'] as $key => $Searchranking_item): ?>
                    <li class="nav-item">
                      <a href="#" class="nav-link" style="text-align: center">
                        <?=$Searchranking_item->word?><span class="float-right badge bg-primary"><?=\App\Helpers\NumberHelper::format($Searchranking_item->count, true)?></span>
                      </a>
                    </li>
                  <?php endforeach ?>
                  <?php if(count($Searchranking['lists']) == 0): ?>
                    <li class="nav-item">
                      <a href="#" class="nav-link" style="text-align: center">
                        <?=lang_common('no_data')?> <span class="float-right badge bg-primary"></span>
                      </a>
                    </li>
                  <?php endif;?>

            </ul>
          </div>
        </div>
        <!-- /.widget-user -->
      </div>
      <!-- /.row -->


    </div>

    <!------------------------------------->

    <script src="https://cdn.jsdelivr.net/npm/chart.js@2.8.0"></script>
  <!-- 부트스트랩 -->
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
  <!-- 차트 -->

        <div class="row">
          
          <div class="col-lg-6">
            <div class="card">
              <div class="card-header border-0">
                <div class="d-flex justify-content-between">
                  <h3 class="card-title">주문 및 신규회원 유입 그래프</h3>
                </div>
              </div>
              <div class="card-body">
                <div class="d-flex">
                  <p class="d-flex flex-column">
                    <span class="text-bold text-lg">월간</span>
                    <!--span>(건수)</span-->
                  </p>
                </div>
                <!-- /.d-flex -->

                <div class="position-relative mb-4">
                  <canvas id="salesChart" height="200"></canvas>
                </div>

                <div class="d-flex flex-row justify-content-end">
                  <span class="mr-2">
                    <i class="fas fa-square text-blue"></i> 판매주문(건)
                  </span>
                  <span>
                    <i class="fas fa-square text-red"></i> 회원가입(건)
                  </span>
                </div>
                
              </div>
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col-md-6 -->
          <div class="col-lg-6">
            <div class="card">
              <div class="card-header border-0">
                <div class="d-flex justify-content-between">
                  <h3 class="card-title">결제 및 매출 그래프</h3>
                  <!--a href="javascript:void(0);">View Report</a-->
                </div>
              </div>
              <div class="card-body">
                <div class="d-flex">
                  <p class="d-flex flex-column">
                    <span class="text-bold text-lg">2주간</span>
                    <!--span>(건/원)</span-->
                  </p>
                </div>
                <!-- /.d-flex -->

                <div class="position-relative mb-4">
                  <canvas id="accountChart" height="200"></canvas>
                </div>

                <div class="d-flex flex-row justify-content-end">
                  <span class="mr-2">
                    <i class="fas fa-square" style="color: #8ae49e"></i> 결제(건)
                  </span>
                  <span>
                    <i class="fas fa-square" style="color: #dc8b42"></i> 매출(천원)
                  </span>
                </div>
              </div>
            </div>
            <!-- /.card -->

          </div>
          <!-- /.col-md-6 -->
        </div>
        <!-- /.row -->


        
  <script>
    // chart colors
    const colors = ['red','yellow','blue','#8ae49e','#dc8b42','#6c757d'];
    var ctx = document.getElementById('salesChart');

    var chartData = {
      labels: [<?php foreach ($todayStat['lists'] as $key => $todayStat_item): ?>
            "<?php echo substr($todayStat_item->created_at, 5, 5); ?>",
            <?php endforeach; ?>],
      datasets: [{
        data: [<?php foreach ($todayStat['lists'] as $key => $todayStat_item): ?>
            "<?=$todayStat_item->todayorder?>",
            <?php endforeach; ?>],
        backgroundColor: colors[2],
        borderColor: colors[2],
        borderWidth: 3,
        pointBackgroundColor: colors[0]
      },
      {
        data: [<?php foreach ($todayStat['lists'] as $key => $todayStat_item): ?>
            "<?=$todayStat_item->todaymember?>",
            <?php endforeach; ?>],
        backgroundColor: colors[0],
        borderColor: colors[0],
        borderWidth: 3,
        pointBackgroundColor: colors[0]
      }
      ]
    };

    var salesChart = new Chart(ctx, {
        // 챠트 종류를 선택
        // type: 'line',
        type: 'bar',
        // 챠트를 그릴 데이타
        data: chartData,
        // 옵션
        options: {
          legend: {
            display: false
          }
        }
    });

    var ctx2 = document.getElementById('accountChart').getContext('2d');;

    var chartData2 = {
      labels: [<?php foreach ($todayStat2['lists'] as $key => $todayStat_item): ?>
            "<?php echo substr($todayStat_item->created_at, 5, 5); ?>",
            <?php endforeach; ?>],
      datasets: [{
        data: [<?php foreach ($todayStat2['lists'] as $key => $todayStat_item): ?>
            "<?=$todayStat_item->todaypayment?>",
            <?php endforeach; ?>],
        backgroundColor: colors[3],
        borderColor: colors[3],
        borderWidth: 3,
        pointBackgroundColor: colors[0]
      },
      {
        data: [<?php foreach ($todayStat2['lists'] as $key => $todayStat_item): ?>
            "<?php 
            $todaysales = $todayStat_item->todaysales;
            $todaysales = substr($todaysales, 0, -3);
            echo $todaysales;
            ?>",
            <?php endforeach; ?>],
        backgroundColor: colors[4],
        borderColor: colors[4],
        borderWidth: 3,
        pointBackgroundColor: colors[0]
      }
      ]
    };

    var accountChart = new Chart(ctx2, {
        // 챠트 종류를 선택
        type: 'bar',
        // 챠트를 그릴 데이타
        data: chartData2,
        // 옵션
        options: {
          legend: {
            display: false
          }
        }
    });
  </script>

    <!------------------------------------->

    <h5 class="mb-2">게시판 정보</h5>
    <div class="row">
      <div class="col-md-4">
        <!-- Widget: user widget style 2 -->
        <div class="card card-widget widget-user-2">
          <!-- Add the bg color to the header using any of the bg-* classes -->
              <div class="card-header border-0">
                <h3 class="card-title">1:1상담 게시판</h3>
                <div class="card-tools">
                  <a href="<?=route_admin('one2one.index')?>" class="btn btn-tool btn-sm">
                    <i class="fas fa-bars"></i>
                  </a>
                </div>
              </div>
              <div class="card-body table-responsive p-0">
                <table class="table table-striped table-valign-middle">
                  <thead>
                  <tr>
                    <th>제목</th>
                    <th>분류</th>
                    <th>등록일</th>
                  </tr>
                  </thead>
                  <tbody>
                  <?php foreach ($One2one['lists'] as $key => $One2one_item): ?>
                    <tr>
                    <td>
                      <?php
                      $one2one_title = $One2one_item->title;
                      echo mb_substr($one2one_title,0,15,'utf-8')."...";
                      ?>
                    </td>
                    <td>
                    <?php 
                      if($One2one_item->situation ==1) {
                          echo lang_common('situation01');
                      } elseif ($One2one_item->situation ==2){
                          echo lang_common('situation02');
                      } elseif ($One2one_item->situation ==3){
                          echo lang_common('situation03');
                      } else {
                          echo lang_common('situation00');
                      }
                    ?>
                    </td>
                    <td>
                      <?=\App\Helpers\DateHelper::toTimeString($One2one_item->created_at)?>
                    </td>
                  </tr>
                  <?php endforeach ?>
                  <?php if(count($One2one['lists']) == 0): ?>
                      <tr>
                          <td colspan="4">
                              <?=lang_common('no_data')?>
                          </td>
                      </tr>
                  <?php endif;?>
                  </tbody>
                </table>
              </div>
        </div>
        <!-- /.widget-user -->
      </div>
      <!-- /.col -->

      <div class="col-md-4">
        <!-- Widget: user widget style 2 -->
        <div class="card card-widget widget-user-2">
          <!-- Add the bg color to the header using any of the bg-* classes -->
          <div class="card-header border-0">
                <h3 class="card-title">견적문의 게시판</h3>
                <div class="card-tools">
                  <a href="<?=route_admin('estimate.index')?>" class="btn btn-tool btn-sm">
                    <i class="fas fa-bars"></i>
                  </a>
                </div>
              </div>
              <div class="card-body table-responsive p-0">
                <table class="table table-striped table-valign-middle">
                  <thead>
                  <tr>
                    <th>제목</th>
                    <th>분류</th>
                    <th>등록일</th>
                  </tr>
                  </thead>
                  <tbody>
                  <?php foreach ($Estimate['lists'] as $key => $estimate_item): ?>
                    <tr>
                    <td>
                      <?php
                      $review_title = $estimate_item->title;
                      echo mb_substr($review_title,0,15,'utf-8')."...";
                      ?>
                    </td>
                    <td>
                    <?php 
                      if($estimate_item->situation ==1) {
                          echo lang_common('situation01');
                      } elseif ($estimate_item->situation ==2){
                          echo lang_common('situation02');
                      } elseif ($estimate_item->situation ==3){
                          echo lang_common('situation03');
                      } else {
                          echo lang_common('situation00');
                      }
                    ?>
                    </td>
                    <td>
                      <?=\App\Helpers\DateHelper::toTimeString($estimate_item->created_at)?>
                    </td>
                  </tr>
                  <?php endforeach ?>
                  <?php if(count($Estimate['lists']) == 0): ?>
                      <tr>
                          <td colspan="4">
                              <?=lang_common('no_data')?>
                          </td>
                      </tr>
                  <?php endif;?>
                  </tbody>
                </table>
              </div>

        </div>
        <!-- /.widget-user -->
      </div>
      <!-- /.col -->

      <div class="col-md-4">
        <!-- Widget: user widget style 2 -->
        <div class="card card-widget widget-user-2">
          <!-- Add the bg color to the header using any of the bg-* classes -->
          <div class="card-header border-0">
                <h3 class="card-title">상품문의</h3>
                <div class="card-tools">
                  <a href="<?=route_admin('inquiry.index')?>" class="btn btn-tool btn-sm">
                    <i class="fas fa-bars"></i>
                  </a>
                </div>
              </div>
              <div class="card-body table-responsive p-0">
                <table class="table table-striped table-valign-middle">
                  <thead>
                  <tr>
                    <th>제목</th>
                    <th>분류</th>
                    <th>등록일</th>
                  </tr>
                  </thead>
                  <tbody>
                  <?php foreach ($Inquiry['lists'] as $key => $Inquiry_item): ?>
                    <tr>
                    <td>
                      <?php
                      $inquiry_title = $Inquiry_item->title;
                      echo mb_substr($inquiry_title,0,15,'utf-8')."...";
                      ?>
                    </td>
                    <td>
                    <?php 
                      if($Inquiry_item->situation ==1) {
                          echo lang_common('situation01');
                      } elseif ($Inquiry_item->situation ==2){
                          echo lang_common('situation02');
                      } elseif ($Inquiry_item->situation ==3){
                          echo lang_common('situation03');
                      } else {
                          echo lang_common('situation00');
                      }
                    ?>
                    </td>
                    <td>
                      <?=\App\Helpers\DateHelper::toTimeString($Inquiry_item->created_at)?>
                    </td>
                  </tr>
                  <?php endforeach ?>
                  <?php if(count($Inquiry['lists']) == 0): ?>
                      <tr>
                          <td colspan="4">
                              <?=lang_common('no_data')?>
                          </td>
                      </tr>
                  <?php endif;?>
                  </tbody>
                </table>
              </div>
        </div>
        <!-- /.widget-user -->
      </div>
      <!-- /.row -->
    </div>

    <!------------------------------------->

      <!-- /.container-fluid -->
    </div>
    <!-- /.content -->

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<script src="<?=asset_admin_css('lte/plugins/chart.js/Chart.min.js')?>"></script>
<script src="<?=asset_admin_js('lte/pages/dashboard3.js')?>"></script>

<?= $this->endSection() ?>