<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
<?=lang_ickinginfo('upload_title')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>

<link href="<?=asset_admin_css('lte/icheck-bootstrap.min.css')?>" rel="stylesheet">

<style>
    .ck-editor__editable[role="textbox"] {
      min-height: 400px;
    }
  
    .ck-content .image {
      max-width: 80%;
      margin: 20px auto;
    }
</style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_admin_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.ickinginfo.list')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> <?= lang_ickinginfo('upload_title')?>
                    </div>
                    <div class="card-body">

                        <div class="card card-body">
                            <div class="row col-md-12 pl-4">
                                <a href="<?=route_admin('product.loop_upload.download_template')?>">
                                    [ <i class="fas fa-download"></i> 재고샘플양식 내려받기 ]
                                </a>
                            </div>
                        </div>


                        <div class="card-footer text-center">
								<div class="card-header text-center">
									<strong>재고 파일을 업로드하기 전 아래 버튼을 클릭하세요.</strong>
								</div>

                                    <div class="mt-2">
                                        <?php if (session()->has('message')){ ?>
                                            <!--div class="alert <?=session()->getFlashdata('alert-class') ?>">
                                                <?=session()->getFlashdata('message') ?>
                                            </div-->
                                        <?php } ?>
                                        <?php $validation = \Config\Services::validation(); ?>
                                    </div>	

                                    <form action="<?=route_admin('ickinginfo.deloldfile')?>" method="post" enctype="multipart/form-data">
										<input type="submit" name="submit" value="작업파일삭제" class="btn btn-primary btn-lg" />
									</form>
                            </div>

                        <!------------------------------------------------------------------------------------------------>
                                <form method="post" id="form" enctype="multipart/form-data" action="<?=route_admin('ickinginfo.import')?>">

                                    <div class="card-body">

                                        <div class="form-group row">
                                            <label class="col-md-2 col-form-label" for="text-input">
                                                <?=lang_common('file_upload')?>
                                            </label>
                                            <div class="col-md-10 file_upload">
                                                <?php for($i =1 ; $i <= $maxFiles ; $i ++): ?>
                                                    <div class="input-group pb-2 file_item <?php if($i > 1) echo 'hide'?>">
                                                        <div class="custom-file">
                                                            <input type="file" class="custom-file-input" id="files_<?=$i?>" name="files_<?=$i?>" maxsizeMb="3" accept=".csv,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-exce">
                                                            <label class="custom-file-label" for="files_<?=$i?>">파일선택</label>
                                                        </div>
                                                        <div class="file_action">
                                                            <?php if($i > 1): ?>
                                                                <a href="javascript:void(0)" class="button-delete color-red">
                                                                    <i class="fa fa-minus-square"></i>
                                                                </a>
                                                            <?php else: ?>
                                                                <a href="javascript:void(0)" class="button-add">
                                                                    <i class="fas fa-plus-circle"></i>
                                                                </a>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                <?php endfor; ?>
                                                <span class="help-block">
                                                    <code>
                                                        <i class="fa fa-exclamation" aria-hidden="true"></i>
                                                        샘플 양식의 CSV 형식에 재고 파일을 첨부하세요.
                                                    </code>
                                                </span>
                                            </div>
                                        </div>
                                        <div class="text-center">
                                        <button class="btn btn-primary btn-lg" type="submit">파일업로드</button>
                                        </div>
                                    </div>
                                </form>

                        <!------------------------------------------------------------------------------------------------>
                            <div class="card-footer text-center">
								<div class="card-header text-center">
									<strong>재고 파일을 업로드한 후 아래 버튼을 클릭하세요.</strong>
								</div>

                                    <div class="mt-2">
                                        <?php if (session()->has('message')){ ?>
                                            <div class="alert <?=session()->getFlashdata('alert-class') ?>">
                                                <?=session()->getFlashdata('message') ?>
                                            </div>
                                        <?php } ?>
                                        <?php $validation = \Config\Services::validation(); ?>
                                    </div>	

                                    <form action="<?=route_admin('ickinginfo.importCsvToDb')?>" method="post" enctype="multipart/form-data">
										<input type="submit" name="submit" value="템프등록" class="btn btn-primary btn-lg" />
									</form>
                            </div>

                            <!--div class="card-footer text-center">
								<div class="card-header text-center">
									<strong>아래 작업할 버튼을 클릭하세요.</strong>
								</div>

                                <div class="card-footer text-center">
                                <a class="btn btn-primary btn-lg" href="<?=route_admin('ickinginfo.looptmp.insertProducts')?>">
                                    추가상품등록
                                </a>
                                <a class="btn btn-primary btn-lg" href="<?=route_admin('ickinginfo.looptmp.updateProducts')?>">
                                    재고 업데이트(SEQ)
                                </a>
                                <a class="btn btn-primary btn-lg" href="<?=route_admin('ickinginfo.looptmp.updateRsProducts')?>">
                                    재고 업데이트(RS_ID)
                                </a>
                                </div>
                            </div-->

						</div>
					</div>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>