<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_lcscproductinfo('list_title')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
<link href="<?=asset_admin_css('plugins/daterangepicker.min.css')?>" rel="stylesheet">
<style>
    th{text-align: center}
    .checkbox{width: 5%}
    th.no{width: 5%}
    th.category{width: 10%}
    th.title{width: 30%}
    th.id{width: 20%}
    th.date{width: 15%}
    th.hit{width: 5%}
    th.action{width: 10%}
    input[type=checkbox]{
        transform: scale(1.5);
    }
</style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
<script src="<?=asset_admin_js('sale-quote.js')?>"></script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.lcscproductinfo')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> <?= lang_lcscproductinfo('list_title')?>

                        <div class="card-header-actions float-right" style="padding-right:10px;">
                            <a class="btn btn-block btn-outline-primary active" href="<?=route_admin('lcscproductinfo.toproductinfo')?>">
                                <?=lang_common('to_products')?>
                            </a>
                        </div>

                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <h5>
                                    <a data-toggle="collapse" href="#collapseSearch" role="button" aria-expanded="<?=$is_search?>" aria-controls="collapseSearc1h">
                                        <?=lang_common('search_info_title')?>
                                    </a>
                                </h5>
                            </div>
                            <div class="col-md-12">
                                <div class="collapse <?=$is_search ? '' : 'show'?>" id="collapseSearch">
                                    <form action="<?=route_admin('lcscproductinfo.index')?>" method="get">
                                        <div class="card card-body">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group row pl-2">
                                                        <label class="col-form-label pl-3" for="date-input">
                                                        Manufacturer Partnumber :
                                                        </label>
                                                        <div class="pl-2 col-md-4">
                                                            <input class="form-control" value="<?="$mpn"?>" type="text" name="mpn">
                                                        </div>
                                                        <div class="pl-3">
                                                            <button type="submit" class="btn btn-block btn-primary pl-5 pr-5" value="<?=lang_common('search')?>">
                                                                <i class="fa fa-search" aria-hidden="true"></i>
                                                                <?=lang_common('search')?>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                            <div class="row">
                                <div class="col-sm-12">
                                    <table class="table table-striped table-bordered datatable dataTable no-footer" id="DataTables_Table_0" role="grid" aria-describedby="DataTables_Table_0_info" style="border-collapse: collapse !important">
                                        <thead>
                                        <tr role="row">
                                            <th class="no">
                                                <?=lang_common('no')?>
                                            </th>
                                            <th class="code" >
                                                Product Code
                                            </th>
                                            <th class="sorting app-col-price">
                                                등록상태
                                            </th>
                                            <th class="code">
                                                <?=lang_common('code')?>
                                            </th>
                                            <th class="image">
                                                <?=lang_product('list_image')?>
                                            </th>
                                            <th class="code" >
                                                Manufacturer Partnumber
                                            </th>
                                            <th class="code" >
                                                LCSC Part #
                                            </th>
                                            <th class="code" >
                                                Packing
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Stock
                                            </th>
                                            <!--th class="sorting app-col-price" >
                                                Currency 1
                                            </th-->
                                            <th class="sorting app-col-price" >
                                                Price 1
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Mini Qty 1
                                            </th>
                                            <!--th class="sorting app-col-price" >
                                                Currency 2
                                            </th-->
                                            <th class="sorting app-col-price" >
                                                Price 2
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Mini Qty 2
                                            </th>
                                            <!--th class="sorting app-col-price" >
                                                Currency 3
                                            </th-->
                                            <th class="sorting app-col-price" >
                                                Price 3
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Mini Qty 3
                                            </th>
                                            <!--th class="sorting app-col-price" >
                                                Currency 4
                                            </th-->
                                            <th class="sorting app-col-price" >
                                                Price 4
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Mini Qty 4
                                            </th>
                                            <!--th class="sorting app-col-price" >
                                                Currency 5
                                            </th-->
                                            <th class="sorting app-col-price" >
                                                Price 5
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Mini Qty 5
                                            </th>
                                            <!--th class="sorting app-col-price" >
                                                Currency 6
                                            </th-->
                                            <th class="sorting app-col-price" >
                                                Price 6
                                            </th>
                                            <th class="sorting app-col-price" >
                                                Mini Qty 6
                                            </th>
                                            <th class="date" >
                                                <?=lang_common('date')?>
                                            </th>

                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach ($lists as $key => $item): ?>

                                        <tr role="row" class="odd">
                                            <td class="text-right">
                                                <?=show_no_row($key+1, $perPage, $currentPage)?>
                                            </td>
                                            <td>
                                                <?=$item->product_code?>
                                            </td>
                                            <td class="text-center">
                                                <?php
                                                if ($item->active_flg == "1"){
                                                    echo "등록";
                                                } else {
                                                    echo "미등록";
                                                }
                                                ?>
                                            </td>
                                            <td >
                                                <?=$item->item_id?>
                                            </td>
                                            <td class="text-center">
                                                <img src="<?=$item->images0?>" width="50"/>
                                            </td>
                                            <td class="">
                                                <?=$item->mpn?>
                                            </td>
                                            <td class="">
                                                <?=$item->item_number?>
                                            </td>
                                            <td class="">
                                                <?=$item->package?>
                                            </td>
                                            <td class="">
                                                <?=$item->quantity?>
                                            </td>
                                            <!--td class="">
                                                <?=$item->prices0_currency?>
                                            </td-->
                                            <td class="">
                                                <?=$item->prices0_price?>
                                            </td>
                                            <td >
                                                <?=$item->prices0_min_qty?>
                                            </td>
                                            <!--td class="">
                                                <?=$item->prices1_currency?>
                                            </td-->
                                            <td class="">
                                                <?=$item->prices1_price?>
                                            </td>
                                            <td >
                                                <?=$item->prices1_min_qty?>
                                            </td>
                                            <!--td class="">
                                                <?=$item->prices2_currency?>
                                            </td-->
                                            <td class="">
                                                <?=$item->prices2_price?>
                                            </td>
                                            <td >
                                                <?=$item->prices2_min_qty?>
                                            </td>
                                            <!--td class="">
                                                <?=$item->prices3_currency?>
                                            </td-->
                                            <td class="">
                                                <?=$item->prices3_price?>
                                            </td>
                                            <td >
                                                <?=$item->prices3_min_qty?>
                                            </td>
                                            <!--td class="">
                                                <?=$item->prices4_currency?>
                                            </td-->
                                            <td class="">
                                                <?=$item->prices4_price?>
                                            </td>
                                            <td >
                                                <?=$item->prices4_min_qty?>
                                            </td>
                                            <!--td class="">
                                                <?=$item->prices5_currency?>
                                            </td-->
                                            <td class="">
                                                <?=$item->prices5_price?>
                                            </td>
                                            <td >
                                                <?=$item->prices5_min_qty?>
                                            </td>
                                            <td class="">
                                                <?=\App\Helpers\DateHelper::toTimeString($item->created_at)?>
                                            </td>

                                        </tr>
                                        <?php endforeach ?>
                                        <?php if(count($lists) == 0): ?>
                                            <tr>
                                                <td colspan="19">
                                                    <?=lang_common('no_data')?>
                                                </td>
                                            </tr>
                                        <?php endif;?>
                                        </tbody>
                                    </table>

                                    <?php if(count($lists) > 0): ?>
                                    <!-- Footer Delete-->
                                    <div class="row">
                                        <div class="col-md-12">
                                            <?= $pager->links() ?>
                                        </div>
                                    </div>
                                    <?php endif;?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
