<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_mallinfo('exchange_list_title')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('plugins/daterangepicker.min.css')?>" rel="stylesheet">
    <style>
        th{text-align: center}
        .checkbox{width: 5%}
        .date{width: 10%}
        .quote_no{width: 10%}
        .amount{width: 10%}
        .name{width: 15%}
        .email{width: 15%}
        .action{width: 10%}
        input[type=checkbox]{
            transform: scale(1.5);
        }
        a.disabled {
            pointer-events: none;
            cursor: default;
        }
    </style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('sale-quote.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/moment.min.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/daterangepicker.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/jquery.maskedinput.js')?>"></script>
    <script src="<?=asset_admin_js('plugins/select2.min.js')?>"></script>
    <script src="<?=asset_admin_js('advanced-forms.js')?>"></script>

<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.mallinfo.exchange')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> <?= lang_mallinfo('exchange_list_title')?>

                        <div class="card-header-actions float-right" style="padding-right:10px;">
                            <a class="btn btn-block btn-outline-primary active" href="<?=route_admin('mallinfo.exchange.show_create')?>">
                                <?=lang_common('create')?>
                            </a>
                        </div>
                        <div class="card-header-actions float-right" style="padding-right:10px;">
                            <a class="btn btn-block btn-outline-primary active" href="<?=route_admin('mallinfo.exchange.deleteold')?>">
                                정보정리
                            </a>
                        </div>

                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <h5>
                                    <a data-toggle="collapse" href="#collapseSearch" role="button" aria-expanded="<?=$is_search?>" aria-controls="collapseSearc1h">
                                        <?=lang_common('search_info_title')?>
                                    </a>
                                </h5>
                            </div>
                            <div class="col-md-12">
                                <div class="collapse <?=$is_search ? 'show' : ''?>" id="collapseSearch">
                                <div class="card card-body">

                                    <form action="<?=route_admin('mallinfo.exchange.index')?>" method="get">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group row pl-2">
                                                    <label class="col-form-label" for="date-input">
                                                        <?=lang_common('search_from_date')?>
                                                    </label>
                                                    <div class="pl-2 pr-3 pb-4">
                                                        <input class="form-control date-single" value="<?=$from_date?>" type="text" name="from_date" placeholder="date">
                                                    </div>
                                                    <label class="col-form-label" for="date-input">
                                                        <?=lang_common('search_to_date')?>
                                                    </label>
                                                    <div class="pl-2">
                                                        <input class="form-control date-single" value="<?=$to_date?>" id="date-single" type="text" name="to_date" placeholder="date">
                                                    </div>
                                                    <div class="pl-3">
                                                        <button type="submit" class="btn btn-block btn-primary pl-5 pr-5" value="<?=lang_common('search')?>">
                                                            <i class="fa fa-search" aria-hidden="true"></i>
                                                            <?=lang_common('search')?>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                    
                                </div>
                                </div>
                            </div>                            
                        </div>

                        <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                            <div class="row">
                                <div class="col-sm-12">
                                    <table class="table table-striped table-bordered datatable dataTable no-footer" id="DataTables_Table_0" role="grid" aria-describedby="DataTables_Table_0_info" style="border-collapse: collapse !important">
                                        <thead>
                                        <tr role="row">
                                            <th class="text-center checkbox">
                                                <input type="checkbox" name="check_all">
                                            </th>
                                            <th class="sorting_asc">
                                                <?=lang_common('no')?>
                                            </th>
                                            <th class="sorting app-col-name" >
                                                지역코드
                                            </th>
                                            <th class="sorting app-col-price" >
                                                기준환율
                                            </th>
                                            <th class="sorting app-col-type" >
                                                <?=lang_common('insert_date')?>
                                            </th>
                                            <th class="update_date" >
                                                <?=lang_common('update_date')?>
                                            </th>
                                            <th class="sorting app-col-action">
                                                <?=lang_common('action')?>
                                            </th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach ($lists as $key => $item): ?>
                                            <tr role="row" class="odd">
                                                <td class="text-center">
                                                    <input type="checkbox" name="check_box" value="<?=$item->id?>">
                                                </td>
                                                <td class="text-right">
                                                    <?=show_no_row($key+1, $perPage, $currentPage)?>
                                                </td>
                                                <td>
                                                    <?=$item->counrty_code?>
                                                </td>
                                                <td >
                                                    <?=$item->standard_amount?>
                                                </td>
                                                <td class="">
                                                    <?=\App\Helpers\DateHelper::toTimeString($item->created_at)?>
                                                </td>
                                                <td class="">
                                                    <?php if(\App\Helpers\DateHelper::toTimeString($item->created_at) != App\Helpers\DateHelper::toTimeString($item->updated_at)):?>
                                                        <?=\App\Helpers\DateHelper::toTimeString($item->updated_at)?>
                                                    <?php endif;?>
                                                </td>
                                                </td>
                                                <td class="text-center">
                                                    <a class="btn btn-info" title="<?=lang_common('detail')?>" href="<?=route_admin('mallinfo.exchange.show_update',$item->id)?>">
                                                        <i class="fa fa-edit"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach ?>
                                        <?php if(count($lists) == 0): ?>
                                            <tr>
                                                <td colspan="8">
                                                    <?=lang_common('no_data')?>
                                                </td>
                                            </tr>
                                        <?php endif;?>
                                        </tbody>
                                    </table>

                                    <?php if(count($lists) > 0): ?>
                                    <!-- Footer Delete-->
                                    <div class="row">
                                        <div class="col-md-3">
                                            <a data-toggle="modal" class="btn btn-danger anchorClick delete"
                                               data-url="<?=route_admin('mallinfo.exchange.delete','')?>"
                                               data-url-origin="<?=route_admin('mallinfo.exchange.delete','')?>"
                                               data-name="<?=lang_mallinfo('title')?>" href="#deleteModal">
                                                <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                <?=lang_common('delete')?>
                                            </a>
                                        </div>
                                        <div class="col-md-9">
                                            <?= $pager->links() ?>
                                        </div>
                                    </div>
                                    <?php endif;?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
