<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
<?=lang_member('update')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
    <link href="<?=asset_admin_css('lte/icheck-bootstrap.min.css')?>" rel="stylesheet">
    <style>
        input[readonly] { /* For Firefox */
            background-color: #ffffff !important;
        }
    </style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('lte/bootstrap-switch.min.js')?>"></script>
    <script>
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<?=$breadcrumb->render('admin.member.update')?>
<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                        <form method="post" action="<?=route_admin('member.update', $item->member_id)?>">
                            <div class="card">
                            <div class="card-header">
                                <i class="fa fa-edit"></i> <?=lang_member('update')?>
                                <div class="card-header-actions float-right">
                                    <a class="btn btn-block btn-secondary" href="<?=route_admin('member.index')?>">
                                        <?=lang_common('back')?>
                                    </a>
                                </div>
                            </div>
                            <div class="card-body">

                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text width-100"><?=lang_member('category')?></span>
                                        </div>
                                        <div class="form-group clearfix" style="display: contents;">
                                            <div class="icheck-primary d-inline pl-2">
                                                <input type="radio" disabled id="category_person" name="category_id" value="<?=MEMBER_CATEGORY_PERSON?>" <?php if($item->category_id == MEMBER_CATEGORY_PERSON) echo 'checked' ?>>
                                                <label for="category_person">
                                                    <?=lang_constant('member_category_person')?>
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline pl-2">
                                                <input type="radio" disabled id="category_company" name="category_id" value="<?=MEMBER_CATEGORY_COMPANY?>" <?php if($item->category_id == MEMBER_CATEGORY_COMPANY) echo 'checked' ?>>
                                                <label for="category_company">
                                                    <?=lang_constant('member_category_company')?>
                                                </label>
                                            </div>
                                            <div class="icheck-primary d-inline pl-2">
                                                <input type="radio" disabled id="category_dealer" name="category_id" value="<?=MEMBER_CATEGORY_DEALER?>" <?php if($item->category_id == MEMBER_CATEGORY_DEALER) echo 'checked' ?>>
                                                <label for="category_dealer">
                                                    <?=lang_constant('member_category_dealer')?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <input type="hidden" name="category_id" value="<?=$item->category_id?>" required/>

                            <?php if($item->category_id == MEMBER_CATEGORY_PERSON): ?>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text width-100">
                                                <?=lang_member('email')?>
                                            </span>
                                        </div>
                                        <input readonly class="form-control" id="member_email" type="text" name="member_email" value="<?=$item->member_email?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('name')?></span>
                                        </div>
                                        <input readonly class="form-control" id="member_name" type="text" name="member_name" value="<?=$item->member_name?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('phone')?></span>
                                        </div>
                                        <input readonly class="form-control" id="member_phone" type="text" name="member_phone" value="<?=$item->member_phone?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('zipcode')?></span>
                                        </div>
                                        <input readonly class="form-control" id="member_zipcode" type="text" name="member_zipcode" value="<?=$item->member_zipcode?>"><!--input type="button" onclick="addr01_execDaumPostcode()" value="우편번호 찾기"-->
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('address1')?></span>
                                        </div>
                                        <input readonly class="form-control" id="member_address1" type="text" name="member_address1" value="<?=$item->member_address1?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('address2')?></span>
                                        </div>
                                        <input readonly class="form-control" id="member_address2" type="text" name="member_address2" value="<?=$item->member_address2?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text width-100"><?=lang_member('accept')?></span>
                                        </div>
                                        <div class="pt-1 pl-2">
                                            <input type="checkbox" name="active_flg" <?php if($item->active_flg == MEMBER_ACCEPT_ON) echo 'checked' ?> data-bootstrap-switch>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text width-100"><?=lang_member('password')?></span>
                                        </div>
                                        <div class="pt-1 pl-2">
                                            <span class="pr-2">
                                                <?=$item->password_random?>
                                            </span>
                                            <a data-toggle="modal" class="btn bg-gradient-green pl-3 pr-3 successPopupClick" style="color: #ffffff"
                                               data-title="<?=lang_common('confirm_reset_password_title')?>"
                                               data-content="<?=lang_common('confirm_reset_password_content')?> for <?=$item->member_name?>"
                                               data-url="<?=route_admin('member.reset_password',$item->member_id)?>" href="#successModal">
                                                <?=lang_member('button_reset_password')?></a>
                                        </div>
                                    </div>
                                </div>
                                <!--div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('last_login')?></span>
                                        </div>
                                        <input readonly class="form-control" id="last_login" type="text" name="last_login" value="<?=\App\Helpers\DateHelper::toTimeString($item->last_login_date)?>">
                                    </div>
                                </div-->

                                <!--------------------------------------->

                                <?php elseif($item->category_id == MEMBER_CATEGORY_COMPANY): ?>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('comname')?></span>
                                        </div>
                                        <input type="text" class="form-control" id="com_name" name="com_name" value="<?=$itemsub->com_name?>" placeholder="<?=lang_member('comname')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('comenglishname')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="com_englishname" name="com_englishname" value="<?=$itemsub->com_englishname?>" placeholder="<?=lang_member('comenglishname')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('biznumber')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="biz_number" name="biz_number" value="<?=$itemsub->biz_number?>" placeholder="<?=lang_member('biznumber')?>">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('ceoname')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="ceo_name" name="ceo_name" value="<?=$itemsub->ceo_name?>" placeholder="<?=lang_member('ceoname')?>">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('comzipcode')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="com_zipcode" name="com_zipcode" value="<?=$itemsub->com_zipcode?>" placeholder="<?=lang_member('comzipcode')?>"><!--input type="button" onclick="addr02_execDaumPostcode()" value="우편번호 찾기"-->
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('comaddress1')?></span>
                                        </div>
                                        <input type="text" class="form-control" id="com_address1" name="com_address1" value="<?=$itemsub->com_address1?>" placeholder="<?=lang_member('comaddress1')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('comaddress2')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="com_address2" name="com_address2" value="<?=$itemsub->com_address2?>" placeholder="<?=lang_member('comaddress2')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('comphone')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="com_phone" name="com_phone" value="<?=$itemsub->com_phone?>" placeholder="<?=lang_member('comphone')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('comfax')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="com_fax" name="com_fax" value="<?=$itemsub->com_fax?>" placeholder="<?=lang_member('comfax')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('homepage')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="homepage" name="homepage" value="<?=$itemsub->homepage?>" placeholder="<?=lang_member('homepage')?>">
                                    </div>
                                </div>                 
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100">담당자 이름</span>
                                        </div>
                                    <input type="text" class="form-control" id="member_name" name="member_name" value="<?=$item->member_name?>" placeholder="<?=lang_member('name')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100">담당자 전화</span>
                                        </div>
                                    <input type="text" class="form-control" id="member_phone" name="member_phone" value="<?=$item->member_phone?>" placeholder="<?=lang_member('phone')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('zipcode')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="member_zipcode" name="member_zipcode" value="<?=$item->member_zipcode?>" placeholder="<?=lang_member('zipcode')?>"> <!--input type="button" onclick="addr01_execDaumPostcode()" value="우편번호 찾기"-->
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('address1')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="member_address1" name="member_address1" value="<?=$item->member_address1?>" placeholder="<?=lang_member('address1')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('address2')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="member_address2" name="member_address2" value="<?=$item->member_address2?>" placeholder="<?=lang_member('address2')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('invoiceemail')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="invoice_email" name="invoice_email" value="<?=$itemsub->invoice_email?>" placeholder="<?=lang_member('invoiceemail')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('sectors')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="sectors" name="sectors" value="<?=$itemsub->sectors?>" placeholder="<?=lang_member('sectors')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('condition')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="condition" name="condition" value="<?=$itemsub->condition?>" placeholder="<?=lang_member('condition')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('accountbankname')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="account_bankname" name="account_bankname" value="<?=$itemsub->account_bankname?>" placeholder="<?=lang_member('accountbankname')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('accountnumber')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="account_number" name="account_number" value="<?=$itemsub->account_number?>" placeholder="<?=lang_member('accountnumber')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('accountdepositor')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="account_depositor" name="account_depositor" value="<?=$itemsub->account_depositor?>" placeholder="<?=lang_member('accountdepositor')?>">
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_common('file_upload')?></span>
                                        </div>
                                        <?php foreach ($files as $index => $fileItem): ?>
                                            <a href="<?=asset_public($fileItem->file_dir)?>" target="<?=open_file_browser($fileItem->file_name)?>">
                                                <?=$fileItem->file_name?>
                                            </a>
                                        <?php endforeach;?>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text width-100"><?=lang_member('accept')?></span>
                                        </div>
                                        <div class="pt-1 pl-2">
                                            <input type="checkbox" name="active_flg" <?php if($item->active_flg == MEMBER_ACCEPT_ON) echo 'checked' ?> data-bootstrap-switch>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text width-100"><?=lang_member('password')?></span>
                                        </div>
                                        <div class="pt-1 pl-2">
                                            <span class="pr-2">
                                                <?=$item->password_random?>
                                            </span>
                                            <a data-toggle="modal" class="btn bg-gradient-green pl-3 pr-3 successPopupClick" style="color: #ffffff"
                                               data-title="<?=lang_common('confirm_reset_password_title')?>"
                                               data-content="<?=lang_common('confirm_reset_password_content')?> for <?=$item->member_name?>"
                                               data-url="<?=route_admin('member.reset_password',$item->member_id)?>" href="#successModal">
                                                <?=lang_member('button_reset_password')?></a>
                                        </div>
                                    </div>
                                </div>
                                <!--div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('last_login')?></span>
                                        </div>
                                        <input readonly class="form-control" id="last_login" type="text" name="last_login" value="<?=\App\Helpers\DateHelper::toTimeString($item->last_login_date)?>">
                                    </div>
                                </div-->

                                <!--------------------------------------->
                                <?php elseif($item->category_id == MEMBER_CATEGORY_DEALER): ?>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('comname')?></span>
                                        </div>
                                        <input type="text" class="form-control" id="com_name" name="com_name" value="<?=$itemsub->com_name?>" placeholder="<?=lang_member('comname')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('comenglishname')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="com_englishname" name="com_englishname" value="<?=$itemsub->com_englishname?>" placeholder="<?=lang_member('comenglishname')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('biznumber')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="biz_number" name="biz_number" value="<?=$itemsub->biz_number?>" placeholder="<?=lang_member('biznumber')?>">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('ceoname')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="ceo_name" name="ceo_name" value="<?=$itemsub->ceo_name?>" placeholder="<?=lang_member('ceoname')?>">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('comzipcode')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="com_zipcode" name="com_zipcode" value="<?=$itemsub->com_zipcode?>" placeholder="<?=lang_member('comzipcode')?>"><!--input type="button" onclick="addr02_execDaumPostcode()" value="우편번호 찾기"-->
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('comaddress1')?></span>
                                        </div>
                                        <input type="text" class="form-control" id="com_address1" name="com_address1" value="<?=$itemsub->com_address1?>" placeholder="<?=lang_member('comaddress1')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('comaddress2')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="com_address2" name="com_address2" value="<?=$itemsub->com_address2?>" placeholder="<?=lang_member('comaddress2')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('comphone')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="com_phone" name="com_phone" value="<?=$itemsub->com_phone?>" placeholder="<?=lang_member('comphone')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('comfax')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="com_fax" name="com_fax" value="<?=$itemsub->com_fax?>" placeholder="<?=lang_member('comfax')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('homepage')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="homepage" name="homepage" value="<?=$itemsub->homepage?>" placeholder="<?=lang_member('homepage')?>">
                                    </div>
                                </div>                 
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100">담당자 <?=lang_member('name')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="member_name" name="member_name" value="<?=$item->member_name?>" placeholder="<?=lang_member('name')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100">담당자 <?=lang_member('phone')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="member_phone" name="member_phone" value="<?=$item->member_phone?>" placeholder="<?=lang_member('phone')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('zipcode')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="member_zipcode" name="member_zipcode" value="<?=$item->member_zipcode?>" placeholder="<?=lang_member('zipcode')?>"> <!--input type="button" onclick="addr01_execDaumPostcode()" value="우편번호 찾기"-->
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('address1')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="member_address1" name="member_address1" value="<?=$item->member_address1?>" placeholder="<?=lang_member('address1')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('address2')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="member_address2" name="member_address2" value="<?=$item->member_address2?>" placeholder="<?=lang_member('address2')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('invoiceemail')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="invoice_email" name="invoice_email" value="<?=$itemsub->invoice_email?>" placeholder="<?=lang_member('invoiceemail')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('sectors')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="sectors" name="sectors" value="<?=$itemsub->sectors?>" placeholder="<?=lang_member('sectors')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('condition')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="condition" name="condition" value="<?=$itemsub->condition?>" placeholder="<?=lang_member('condition')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('accountbankname')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="account_bankname" name="account_bankname" value="<?=$itemsub->account_bankname?>" placeholder="<?=lang_member('accountbankname')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('accountnumber')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="account_number" name="account_number" value="<?=$itemsub->account_number?>" placeholder="<?=lang_member('accountnumber')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('accountdepositor')?></span>
                                        </div>
                                    <input type="text" class="form-control" id="account_depositor" name="account_depositor" value="<?=$itemsub->account_depositor?>" placeholder="<?=lang_member('accountdepositor')?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_common('file_upload')?></span>
                                        </div>
                                        <?php foreach ($files as $index => $fileItem): ?>
                                            <a href="<?=asset_public($fileItem->file_dir)?>" target="<?=open_file_browser($fileItem->file_name)?>">
                                                <?=$fileItem->file_name?>
                                            </a>
                                        <?php endforeach;?>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text width-100"><?=lang_member('accept')?></span>
                                        </div>
                                        <div class="pt-1 pl-2">
                                            <input type="checkbox" name="active_flg" <?php if($item->active_flg == MEMBER_ACCEPT_ON) echo 'checked' ?> data-bootstrap-switch>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text width-100"><?=lang_member('password')?></span>
                                        </div>
                                        <div class="pt-1 pl-2">
                                            <span class="pr-2">
                                                <?=$item->password_random?>
                                            </span>
                                            <a data-toggle="modal" class="btn bg-gradient-green pl-3 pr-3 successPopupClick" style="color: #ffffff"
                                               data-title="<?=lang_common('confirm_reset_password_title')?>"
                                               data-content="<?=lang_common('confirm_reset_password_content')?> for <?=$item->member_name?>"
                                               data-url="<?=route_admin('member.reset_password',$item->member_id)?>" href="#successModal">
                                                <?=lang_member('button_reset_password')?></a>
                                        </div>
                                    </div>
                                </div>
                                <!--div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text width-100"><?=lang_member('last_login')?></span>
                                        </div>
                                        <input readonly class="form-control" id="last_login" type="text" name="last_login" value="<?=\App\Helpers\DateHelper::toTimeString($item->last_login_date)?>">
                                    </div>
                                </div-->
                                <?php endif; ?>
                                
                                <!--------------------------------------->
                            </div>
                            <div class="card-footer text-center">
                                <button type="submit" class="btn bg-gradient-primary pl-3 pr-3"><?=lang_common('update')?></button>
                            </div>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
