<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_navercommerce('list_title')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
<link href="<?=asset_admin_css('plugins/daterangepicker.min.css')?>" rel="stylesheet">
<style>
    th{text-align: center}
    .checkbox{width: 5%}
    .navercommerce_no{width: 5%}
    .image{width: 10%}
    .part_number{width: 10%}
    .manufacturer{width: 10%}
    .description{width: 10%;word-break: break-all;}
    .break-word{word-break: break-word;}
    .qty{width: 10%}
    .insert_date{width: 10%}
    .update_date{width: 10%}
    .action{width: 5%}
    input[type=checkbox]{
        transform: scale(1.5);
    }
    a.disabled {
        pointer-events: none;
        cursor: default;
    }
</style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
<script src="<?=asset_admin_js('sale-quote.js')?>"></script>
<script src="<?=asset_admin_js('plugins/moment.min.js')?>"></script>
<script src="<?=asset_admin_js('plugins/daterangepicker.js')?>"></script>
<script src="<?=asset_admin_js('plugins/jquery.maskedinput.js')?>"></script>
<script src="<?=asset_admin_js('plugins/select2.min.js')?>"></script>
<script src="<?=asset_admin_js('advanced-forms.js')?>"></script>
<script src="<?=asset_admin_js('form.input.number.js')?>"></script>
<script src="<?=asset_admin_js('lte/bs-custom-file-input.min.js')?>"></script>
<script type="text/javascript">
    $(document).ready(function () {
        bsCustomFileInput.init();
    });
</script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.navercommerce.list')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> <?= lang_navercommerce('list_title')?>
                        <div class="card-header-actions float-right">

                        </div>
                    </div>
                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-12">
                                <h5>
                                    <a data-toggle="collapse" href="#collapseSearch" role="button" aria-expanded="<?=$is_search?>" aria-controls="collapseSearc1h">
                                        <?=lang_common('search_info_title')?>
                                    </a>
                                </h5>
                            </div>

                            <div class="col-md-12">
                                <div class="collapse <?=$is_search ? '' : 'show'?>" id="collapseSearch">
                                    <form action="<?=route_admin('navercommerce.index')?>" method="get">

                                        <div class="card card-body">

                                                <div class="col-md-12">
                                                    <div class="form-group row">

                                                        <label class="col-form-label pl-3" for="part_category">
                                                            <?=lang_product('list_part_category1')?> :
                                                        </label>
                                                        <div class="col-md-3">
                                                        <select name="part_category" id="categorylevel1" class="form-control input-lg">
                                                            <option value="">Select Category1</option>
                                                            <?php
                                                            foreach($categorylevel1 as $row)
                                                            {
                                                                echo '<option value="'.$row["categorylevel1_code"].'"';

                                                                if($row["categorylevel1_code"] == $product->part_category) {
                                                                    echo 'selected';
                                                                    }
                                                                
                                                                echo '>'.$row["categorylevel1_name"].'</option>';
                                                            }
                                                            ?>
                                                        </select>
                                                        </div>

                                                        <label class="col-form-label pl-3" for="part_category">
                                                            <?=lang_product('list_part_category2')?> :
                                                        </label>
                                                        <div class="col-md-3">
                                                        <select name="part_category2" id="categorylevel2" class="form-control input-lg">
                                                            <?php
                                                            foreach($categorylevel2 as $row)
                                                            {
                                                                if($row["categorylevel2_code"] == $product->part_category2) {
                                                                    echo '<option value="'.$row["categorylevel2_code"].'" selected>'.$row["categorylevel2_name"].'</option>';
                                                                    }
                                                            }
                                                            ?>
                                                            <option value="">Select Category2</option>
                                                        </select>
                                                        </div>
                                                        <!--label class="col-form-label pl-3" for="part_category3">
                                                            <?=lang_product('list_part_category3')?> :
                                                        </label>
                                                        <div class="col-md-3">
                                                            <select name="part_category3" id="categorylevel3" class="form-control input-lg">
                                                                <?php
                                                                foreach($categorylevel3 as $row)
                                                                {
                                                                    if($row["categorylevel3_code"] == $product->part_category3) {
                                                                        echo '<option value="'.$row["categorylevel3_code"].'" selected>'.$row["categorylevel3_name"].'</option>';
                                                                        }
                                                                }
                                                                ?>
                                                                <option value="">Select Category3</option>
                                                            </select>
                                                        </div-->
                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-12">
                                                    <div class="form-group row">

                                                        <label class="col-form-label pl-3" for="anufacturer_id">
                                                            <?=lang_product('list_manufacturer')?> :
                                                        </label>
                                                        <div class="col-md-3">
                                                            <select class="form-control" id="maker_seq" name="maker_seq">
                                                                <option value="">제조사 선택</option>
                                                                <?php foreach ($manufacturers as $manufacturer): ?>
                                                                    <option value="<?=$manufacturer->maker_seq?>"><?=$manufacturer->name?></option>
                                                                <?php endforeach; ?>
                                                            </select>
                                                        </div>
                                                        <label class="col-form-label pl-3" for="part_number">
                                                        <?=lang_navercommerce('list_part_number')?> :
                                                        </label>
                                                        <div class="pl-2 col-md-3">
                                                            <input class="form-control" value="<?=$part_number?>" type="text" name="part_number">
                                                        </div>
                                                        <div class="pl-3">
                                                            <button type="submit" class="btn btn-block btn-primary pl-5 pr-5" value="<?=lang_common('search')?>">
                                                                <i class="fa fa-search" aria-hidden="true"></i>
                                                                <?=lang_common('search')?>
                                                            </button>
                                                        </div>
                                                        <div class="col-form-label pl-5">
                                                            <input class="form-check-input" type="checkbox" name="qty_chk" value="Y" id="qty_chk">재고상품
                                                        </div>
                                                        <div class="col-form-label pl-5">
                                                            <input class="form-check-input" type="checkbox" name="price_chk" value="Y" id="price_chk">가격상품
                                                        </div>
                                                        <div class="col-form-label pl-5">
                                                            <input class="form-check-input" type="checkbox" name="ep_chk" value="Y" id="ep_chk">EP등록상품
                                                        </div>

                                                    </div>
                                                </div>

                                        </div>
                                    </form>
                                </div>
                            </div>

                        </div>

                        <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                            <div class="row">
                                <div class="col-sm-12">
                                    <?php if(count($lists) > 0): ?>
                                    <!-- Header Delete-->
                                    <?php endif;?>
                                    <table class="table table-striped table-bordered datatable dataTable no-footer" id="DataTables_Table_0" role="grid" aria-describedby="DataTables_Table_0_info" style="border-collapse: collapse !important">
                                        <thead>
                                        <tr role="row">
                                            <th class="text-center checkbox">
                                                <input type="checkbox" name="check_all">
                                            </th>
                                            <th class="navercommerce_no">
                                                <?=lang_navercommerce('list_navercommerce_no')?>
                                            </th>
                                            <th class="image">
                                                <?=lang_navercommerce('list_image')?>
                                            </th>
                                            <th class="part_number" >
                                                <?=lang_navercommerce('list_part_number')?>
                                            </th>
                                            <th class="manufacturer" >
                                                <?=lang_navercommerce('list_manufacturer')?>
                                            </th>
                                            <th class="insert_date">
                                                네이버쇼핑 노출상태
                                            </th>
                                            <th class="qty" >
                                                Class
                                            </th>
                                            <th class="qty" >
                                                <?=lang_navercommerce('list_qty')?>
                                            </th>
                                            <th class="update_date" >
                                                <?=lang_navercommerce('list_price')?>((단가*MOQ)*VAT)
                                            </th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach ($lists as $key => $navercommerce): ?>
                                            <tr role="row" class="odd">
                                                <td class="text-center">
                                                    <input type="checkbox" name="check_box" value="<?=$navercommerce->product_id?>">
                                                </td>
                                                <td class="text-right">
                                                    <?=show_no_row($key+1, $perPage, $currentPage)?>
                                                </td>
                                                <td class="text-center">
                                                    <?php if(isset($navercommerce->image_dir) && $navercommerce->image_dir != ''): ?>

                                                    <?php if(isset($navercommerce->api_flg) && $navercommerce->api_flg == '1'): ?>
                                                        <img src="<?=$navercommerce->image_dir?>" width="50"/>
                                                    <?php else : ?>
                                                        <img src="<?=asset_public($navercommerce->image_dir)?>" width="50"/>
                                                    <?php endif; ?>

                                                    <?php else : ?>
                                                        <img src="<?=asset_public('images/no_image_available.jpg')?>" width="50"/>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="text-center">
                                                    <?=$navercommerce->part_number?>
                                                </td>
                                                <td class="">
                                                    <?=$navercommerce->maker_name?>
                                                </td>
                                                <td class="text-center">
                                                    <?php 
                                                    if ($navercommerce->navershop_chk == '0') {
                                                        echo "미등록";
                                                    } elseif ($navercommerce->navershop_chk == '2') {
                                                        echo "품절처리";
                                                    } elseif ($navercommerce->navershop_chk == '3') {
                                                        echo "업데이트";
                                                    } else {
                                                        echo "등록";
                                                    }
                                                    ?>
                                                    (<?=$navercommerce->navershop_chk?>)
                                                </td>
                                                <td class="text-right">
                                                    <?=$navercommerce->navershop_status?>
                                                </td>
                                                <td class="text-right">
                                                    <?=\App\Helpers\NumberHelper::format($navercommerce->qty, true)?>
                                                </td>
                                                <td class="text-center">
                                                    <?php
                                                        $selling_price = $navercommerce->selling_price1*$navercommerce->moq;
                                                        $selling_price_vat = round($selling_price*1.1);
                                                        echo number_format($selling_price_vat)."원";
                                                    ?>
                                                </td>
                                            </tr>
                                        <?php endforeach ?>
                                        <?php if(count($lists) == 0): ?>
                                            <tr>
                                                <td colspan="10">
                                                    <?=lang_common('no_data')?>
                                                </td>
                                            </tr>
                                        <?php endif;?>
                                        </tbody>
                                    </table>

                                    <?php if(count($lists) > 0): ?>
                                    <!-- Footer Delete-->
                                    <div class="row">
                                        <div class="col-md-3">
                                            <a data-toggle="modal" class="btn btn-success successPopupClick btn-accept"
                                               data-title="<?=lang_common('confirm_accept_title')?>"
                                               data-content="<?=lang_common('confirm_accept_content')?> : <?=lang_navercommerce('title')?>"
                                               data-url="<?=route_admin('navercommerce.accept','')?>"
                                               data-url-origin="<?=route_admin('navercommerce.accept','')?>"
                                               data-name="<?=lang_navercommerce('title')?>" href="#successModal">
                                                <i class="fa fa-check" aria-hidden="true"></i>
                                                노출등록
                                            </a>

                                            <a data-toggle="modal" class="btn btn-dark successPopupClick btn-not-accept"
                                               data-title="<?=lang_common('confirm_not_accept_title')?>"
                                               data-content="<?=lang_common('confirm_not_accept_content')?> : <?=lang_navercommerce('title')?>"
                                               data-url="<?=route_admin('navercommerce.not_accept','')?>"
                                               data-url-origin="<?=route_admin('navercommerce.not_accept','')?>"
                                               data-name="<?=lang_navercommerce('title')?>" href="#successModal">
                                                <i class="fa fa-check" aria-hidden="true"></i>
                                                노출해제
                                            </a>
                                            <a class="btn btn-primary download" href="<?=route_admin('navercommerce.download')?>">
                                                <i class="fa fa-download" aria-hidden="true"></i>
                                                EP 파일생성
                                            </a>
                                            <a class="btn btn-primary download" href="<?=route_admin('navercommerce.download_tsv')?>">
                                                <i class="fa fa-download" aria-hidden="true"></i>
                                                EP 파일받기
                                            </a>
                                            <a class="btn btn-primary download" href="<?=route_admin('navercommerce.suppliercodeinfo')?>">
                                                <i class="fa fa-download" aria-hidden="true"></i>
                                                SEQ 파일받기
                                            </a>
                                        </div>
                                        <div class="col-md-2">
                                            <b>EP에 등록된 상품 : <?=$nshoppingDataCount?>개</b>
                                        </div>
                                        <div class="col-md-2">
                                            <b>EP에 가격 없는 상품 : <?=$nshoppingNotpriceCount?>개</b>
                                        </div>
                                        <div class="col-md-2">
                                            <b>EP로 제출될 상품 : <?=$nshoppingCount?>개</b>
                                        </div>
                                        <div class="col-md-3">
                                            <?= $pager->links() ?>
                                        </div>
                                    </div>
                                    <!--form method="post" id="form" enctype="multipart/form-data" action="<?=route_admin('navercommerce.importid')?>">
                                        <div class="row">
                                            <div class="col-md-2">
                                                <div class="input-group">
                                                    <div class="custom-file">
                                                    <input type="file" class="custom-file-input" id="files" name="files" maxsizeMb="10"  accept=".csv,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-exce">
                                                    <label class="custom-file-label" for="files"> Chose File</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-1">
                                                <button class="btn btn-primary download" type="submit">API ID로 EP등록</button>
                                            </div>    
                                        </div>
                                    </form-->

<!---------------------------->

    <div class="card card-body">
            <div class="row col-md-12 pl-4" style="margin-bottom: 15px;">
                <a href="<?=route_admin('productmp.productmp_event.downloadtemp')?>">
                    [ <i class="fas fa-download"></i> 대체품/이벤트/네이버쇼핑 등록양식 내려받기 ]
                </a>
            </div>

            <div class="row">
                <!-- /.col -->
                <div class="col-md-3 col-sm-6 col-12">
                    <div class="info-box">

                    <div class="card-footer text-center" style="width: 100%;">
                        <form method="post" id="form" enctype="multipart/form-data" action="<?=route_admin('navercommerce.event.import')?>">
                            <div class="form-group row">
                                <label class="col-md-2 col-form-label" for="text-input">
                                    <?=lang_common('file_upload')?>
                                </label>
                                <div class="col-md-10 file_upload">
                                    <?php for($i =1 ; $i <= $maxFiles ; $i ++): ?>
                                        <div class="input-group pb-2 file_item <?php if($i > 1) echo 'hide'?>">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" id="files_<?=$i?>" name="files_<?=$i?>" maxsizeMb="3" accept=".csv,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-exce">
                                                <label class="custom-file-label" for="files_<?=$i?>">파일선택</label>
                                            </div>
                                            <div class="file_action">
                                                <?php if($i > 1): ?>
                                                    <a href="javascript:void(0)" class="button-delete color-red">
                                                        <i class="fa fa-minus-square"></i>
                                                    </a>
                                                <?php else: ?>
                                                    <a href="javascript:void(0)" class="button-add">
                                                        <i class="fas fa-plus-circle"></i>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endfor; ?>
                                </div>
                            </div>
                            <div class="text-center">
                                <a class="btn btn-primary" href="<?=route_admin('navercommerce.event.deletefile')?>">작업파일삭제</a>
                                <button class="btn btn-primary" type="submit">파일업로드</button>
                                <a class="btn btn-primary" href="<?=route_admin('navercommerce.event.eventcsvtodb')?>">템프등록</a>
                            </div>
                        </form>
                    </div>

                    </div>
                </div>


                <!-- /.col -->
                <div class="col-md-2 col-sm-6 col-12">
                    <div class="info-box">
                        <div class="card-footer text-center" style="width: 100%;">
                            <div class="card-header text-center" style="margin-bottom: 15px;">
                                <strong>네이버쇼핑 등록/수정 사항을 선택후 업데이트</strong>
                            </div>
                            <form action="<?=route_admin('navercommerce.event.upnavershop')?>" method="post" enctype="multipart/form-data">
                                <div class="row">
                                    <div class="col-md-2">
                                    </div>
                                    <div class="col-md-4 text-center col-sm-6 col-12">
                                        <select class="form-control" id="navershop_chk" name="navershop_chk">
                                            <option value="">처리선택</option>
                                            <option value="1">등록</option>
                                            <option value="2">품절</option>
                                            <option value="3">업데이트</option>
                                            <option value="0">미노출</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4 text-center col-sm-6 col-12">
                                        <input type="submit" name="submit" value="네이버쇼핑 등록" class="btn btn-primary" />
                                    </div>
                                    <div class="col-md-2">
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                                <!-- /.col -->
                <div class="col-md-3 col-sm-6 col-12">
                    <div class="info-box">

                    <div class="card-footer text-center" style="width: 100%;">
                        <form method="post" id="form" enctype="multipart/form-data" action="<?=route_admin('navercommerce.event.import')?>">
                            <div class="form-group row">
                                <label class="col-md-2 col-form-label" for="text-input">
                                    <?=lang_common('file_upload')?>
                                </label>
                                <div class="col-md-10 file_upload">
                                    <?php for($i =1 ; $i <= $maxFiles ; $i ++): ?>
                                        <div class="input-group pb-2 file_item <?php if($i > 1) echo 'hide'?>">
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" id="files_<?=$i?>" name="files_<?=$i?>" maxsizeMb="3" accept=".csv,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-exce">
                                                <label class="custom-file-label" for="files_<?=$i?>">파일선택</label>
                                            </div>
                                            <div class="file_action">
                                                <?php if($i > 1): ?>
                                                    <a href="javascript:void(0)" class="button-delete color-red">
                                                        <i class="fa fa-minus-square"></i>
                                                    </a>
                                                <?php else: ?>
                                                    <a href="javascript:void(0)" class="button-add">
                                                        <i class="fas fa-plus-circle"></i>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endfor; ?>
                                </div>
                            </div>
                            <div class="text-center">
                                <a class="btn btn-primary" href="<?=route_admin('navercommerce.event.deletefile')?>">작업파일삭제</a>
                                <button class="btn btn-primary" type="submit">파일업로드</button>
                                <a class="btn btn-primary" href="<?=route_admin('navercommerce.event.navertoinsert')?>">네이버쇼핑등록</a>
                            </div>
                        </form>
                    </div>

                    </div>
                </div>


            </div>
        </div>
<!---------------------------->                             




                                    <?php endif;?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!---------------------------->
<script>
$(document).ready(function(){
    $('#categorylevel1').change(function(){
        var categorylevel1_code = $('#categorylevel1').val();
        var action = 'get_categorylevel2';
        if(categorylevel1_code != '')
        {
            $.ajax({
                url:"<?php echo base_url('/CategorylevelSelect/action'); ?>",
                method:"POST",
                data:{categorylevel1_code:categorylevel1_code, action:action},
                dataType:"JSON",
                success:function(data)
                {
                    var html = '<option value="">Select Categorylevel2</option>';
                    for(var count = 0; count < data.length; count++)
                    {
                        html += '<option value="'+data[count].categorylevel2_code+'">'+data[count].categorylevel2_name+'</option>';
                    }
                    $('#categorylevel2').html(html);
                }
            });
        }
        else
        {
            $('#categorylevel2').val('');
        }
        $('#categorylevel3').val('');
    });

    $('#categorylevel2').change(function(){
        var categorylevel2_code = $('#categorylevel2').val();
        var action = 'get_categorylevel3';
        if(categorylevel2_code != '')
        {
            $.ajax({
                url:"<?php echo base_url('/CategorylevelSelect/action'); ?>",
                method:"POST",
                data:{categorylevel2_code:categorylevel2_code, action:action},
                dataType:"JSON",
                success:function(data)
                {
                    var html = '<option value="">Select Categorylevel3</option>';
                    for(var count = 0; count < data.length; count++)
                    {
                        html += '<option value="'+data[count].categorylevel3_code+'">'+data[count].categorylevel3_name+'</option>';
                    }

                    $('#categorylevel3').html(html);
                }
            });
        }
        else
        {
            $('#categorylevel3').val('');
        }
    });
});

</script>
<!-------------------------------->

<?= $this->endSection() ?>
