<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_sale('input_title')?>
<?= $this->endSection() ?>

<?= $this->section('head.first_css') ?>
    <link rel="stylesheet" href="<?=asset_admin_css('lte/select2.min.css')?>">
    <link rel="stylesheet" href="<?=asset_admin_css('lte/select2-bootstrap4.min.css')?>">
<?= $this->endSection() ?>
<?= $this->section('head.css') ?>
    <style>
        th{text-align: center}
        .table td, .table th{padding: .25rem}
    </style>
<?= $this->endSection() ?>

<?= $this->section('content') ?>

<?=$breadcrumb->render('admin.sale.input')?>
<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="card">
                    <div class="card-header">
                        <i class="fa fa-edit"></i> <?= lang_sale('input_title')?>
                    </div>
                    <div class="card-body">
                        <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap4 no-footer">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card card-body">
                                        <div class="row col-md-12">
                                            <?=lang_sale('input_note_header_one')?>
                                        </div>
                                        <div class="row col-md-12">
                                            <?=lang_sale('input_note_header_two')?>
                                        </div>
                                    </div>
                                    <form method="POST" action="<?= route_admin('sale.item.create')?>" id="frmItems">
                                        <table class="table table-condensed">
                                            <thead>
                                            <tr>
                                                <th>Part no</th>
                                                <th>Manufacture</th>
                                                <th>Description</th>
                                                <th>Quantity</th>
                                            </tr>
                                            </thead>
                                            <tbody id="tbodyItems">
                                            <?php for($i=1;$i <= $dataRow;$i++):?>
                                                <?php
                                                $partNo = 'part_number['.$i.']';
                                                $manufactureId = 'id['.$i.']';
                                                $description = 'description['.$i.']';
                                                $quantity = 'qty['.$i.']';
                                                ?>
                                                <tr class="trPartNo">
                                                    <td>
                                                        <input class="form-control part_number" id="<?=$partNo?>" type="text" name="<?=$partNo?>">
                                                    </td>
                                                    <td>
                                                        <select class="form-control select2" name="<?=$manufactureId?>" style="width: 100%;">
                                                            <?php foreach ($manufacturers as $manufacturer):?>
                                                                <option value="<?=$manufacturer->maker_seq?>"><?=$manufacturer->name?></option>
                                                            <?php endforeach;?>
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <input class="form-control description" id="text-input" type="text" name="<?=$description?>">
                                                    </td>
                                                    <td>
                                                        <input class="form-control qty text-right number" id="<?=$quantity?>" type="text" name="<?=$quantity?>">
                                                    </td>
                                                </tr>
                                            <?php endfor;?>
                                            </tbody>
                                        </table>

                                        <div class="row col-md-12 pl-4 pb-2">
                                            <span class="color-red">
                                                <i class="fa fa-exclamation" aria-hidden="true"></i>
                                                <?=lang_sale('input_note_footer')?></span>
                                        </div>
                                        <div class="card-footer text-right">
                                            <button class="btn btn-primary pl-5 pr-5"a type="button" id="other"><?=lang_common('insert')?></button>
<!--                                            <button class="btn btn-sm btn-primary" type="button" id="other"> Submit</button>-->
                                            <a class="btn btn-danger" href="<?=route_admin('admin.sale.input.index')?>" type="reset" id="resetForm"><?=lang_common('reset')?></a>
                                        </div>
                                    </form>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('form.input.number.js')?>"></script>
    <script src="<?=asset_admin_js('lte/select2.full.min.js')?>"></script>
    <script>
        var validator = null;
        function getFieldValidateForm(rulesOrMessage){
            let objValidate = {};
            let fieldClassValidate = {};
            if(rulesOrMessage == 'rules'){
                fieldClassValidate =  <?=$validation['str_rules']?>;
            }else{
                fieldClassValidate =  <?=$validation['str_messages']?>;
            }
            let trPartNoDOM = $(".trPartNo");
            trPartNoDOM.each((index,trPartNo)=>{
                let inputPartNumber = $(trPartNo).find('input.part_number');
                let inputQuantity = $(trPartNo).find('input.qty');
                if (inputPartNumber.val() != '' || inputQuantity.val() != ''){
                    for (let property in fieldClassValidate){
                        objValidate[`${property}[${index+1}]`] = fieldClassValidate[property]
                    }
                }
            });
            return objValidate;
        }
        function resetForm(trElement = null){
            if (trElement == null || trElement == undefined){
                let trItems = $("tbody#tbodyItems").find("tr.trPartNo");
                trItems.each((index,trItem)=>{
                    $(trItem).find("input.part_number").val('');
                    $(trItem).find("input.qty").val('');
                    $(trItem).find("input.description").val('');
                });
                return;
            }
            $(trElement).find('input.qty').val('');
        }
        function checkAllFormRequired(){
            let check = false;
            let trItems = $("tbody#tbodyItems").find("tr.trPartNo");
            trItems.each((index,trItem)=>{
                let part_number = $(trItem).find('input.part_number').val();
                let qty = $(trItem).find('input.qty').val();
                if (part_number != '' || qty != ''){
                    check = true;
                    return false;
                }
            });
            return check;
        }
        function initDefaultValueView(){
            validator = $( "#frmItems" ).validate();
        }
        $(document).ready(function () {
            initDefaultValueView();
            $('.select2').select2();
            $( "#other" ).on('click',function() {
                if(checkAllFormRequired()){
                    validator.destroy();
                    validator = $( "#frmItems" ).validate({
                        'errorClass' : 'is-invalid',
                        'errorElement' : 'span',
                        'errorElementClass' : 'error invalid-feedback',
                        rules:getFieldValidateForm('rules'),
                        messages:getFieldValidateForm('messages')
                    });
                    if(validator.valid()){
                        $("#frmItems").submit();
                    }
                }
            });
            $(".part_number").on('input',function () {
                if($(this).val() == ''){
                    let trElement = $(this).parent().parent();
                    resetForm(trElement);
                }
            });
            $("button#resetForm").on('click',function () {
                resetForm();
            });
        });
    </script>

<?= $this->endSection() ?>