<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
    <?=lang_sale('list_update')?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_admin_js('form.input.number.js')?>"></script>
    <script src="<?=asset_admin_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            bsCustomFileInput.init();
        });
    </script>
    <?php if(isset($validation)): ?>
        <script>
            $("#form").validate({
                'errorClass' : 'is-invalid',
                <?=$validation['rules']?>,
                <?=$validation['messages']?>
        </script>
    <?php endif?>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<?=$breadcrumb->render('admin.sale.update')?>
<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                        <form method="post" action="<?=route_admin('sale.update',$item->item_id)?>" enctype="multipart/form-data" id="form">
                            <div class="card">
                                <div class="card-header">
                                    <i class="icon-note"></i> <?=lang_sale('list_update')?>
                                    <div class="card-header-actions float-right">
                                        <a class="btn btn-block btn-secondary" href="<?=route_admin('sale.index')?>">
                                            <?=lang_common('back')?>
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="part_number">
                                                    <?=lang_sale('list_part_number')?>
                                                </label>
                                                <div class="col-md-9">
                                                    <input class="form-control" id="part_number" type="text" disabled value="<?=old_value('part_number', $item->part_number)?>">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="id">
                                                    <?=lang_sale('list_manufacturer')?>
                                                </label>
                                                <div class="col-md-9">
                                                    <select class="form-control" id="maker_seq" name="maker_seq">
                                                        <?php foreach ($manufacturers as $manufacturer): ?>
                                                            <option value="<?=$manufacturer->maker_seq?>" <?php if($manufacturer->maker_seq == $item->maker_seq) echo 'selected';?> ><?=$manufacturer->name?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="qty">
                                                    <?=lang_sale('list_qty')?>
                                                </label>
                                                <div class="col-md-9">
                                                    <input class="form-control number text-right" id="qty" type="text" name="qty" value="<?=\App\Helpers\NumberHelper::format(old_value('qty', $item->qty))?>" >
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label">
                                                    <?=lang_sale('list_pdf_file')?>
                                                </label>
                                                <div class="col-md-9">
                                                    <div class="input-group">
                                                        <div class="custom-file">
                                                            <input type="file" class="custom-file-input" id="pdf_file" name="pdf_file" maxsizeMb="10" accept=".pdf,application/pdf">
                                                            <label class="custom-file-label" for="pdf_file"> <?=show_text_dot($item->pdf_dir,50)?></label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-3 col-form-label" for="description">
                                                    <?=lang_sale('list_description')?>
                                                </label>
                                                <div class="col-md-9">
                                                    <textarea class="form-control" id="description" name="description" rows="9"><?=old_value('description', $item->description)?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="box box-warning">
                                                <div class="box-body">
                                                    <div class="upload__area-image">
                                                <span>
                                                    <?php if(isset($item->image_dir) && $item->image_dir != ''): ?>
                                                        <img id="imgHandle" src="<?=asset_public($item->image_dir)?>">
                                                    <?php else:?>
                                                        <img id="imgHandle" src="<?=asset_public('images/no_image_available.jpg')?>">
                                                    <?php endif;?>
                                                    <label for="imgAnchorInput">Upload image</label>
                                                </span>
                                                        <p>
                                                            <small>(Please upload a file of type: jpeg, png, jpg, gif, svg.)</small><br/>
                                                            <small class="color-red hide" id="message_image">(Please upload a file of type: jpeg, png, jpg, gif, svg.)</small>
                                                        </p>
                                                    </div>
                                                    <div class="form__upload">
                                                        <div class="form-inline-simple">
                                                            <input type="file" name="image_file" class="form-control" accept="image/*" maxsizeMb="1" id="imgAnchorInput" onchange="loadFile(event)">
                                                        </div>
                                                        <script>
                                                            var loadFile = function(event) {
                                                                var output = document.getElementById('imgHandle');
                                                                var file = event.target.files[0];
                                                                var size = file.size;
                                                                var exactSize = size/1024/1024;
                                                                // var fSExt = new Array('Bytes', 'KB', 'MB', 'GB'),
                                                                //     i=0;while(size>900){size/=1000;i++;}
                                                                // var exactSize = (Math.round(size*100)/100)+' '+fSExt[i];
                                                                console.log(exactSize);
                                                                if(exactSize >= 2){
                                                                    var message = "File size must not exceed 2 MB";
                                                                    document.getElementById('message_image').innerHTML = message;
                                                                    event.target.value = '';
                                                                    $('#message_image').removeClass('hide');
                                                                }else{
                                                                    $('#message_image').addClass('hide');
                                                                    output.src = URL.createObjectURL(file);
                                                                }
                                                            };
                                                        </script>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer text-center">
                                    <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('update')?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
