<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
<?=lang_sale('quote_detail')?>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<?=$breadcrumb->render('admin.sale.quote.detail')?>
<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card ">
                            <div class="card-header">
                                <i class="fas fa-edit"></i> <?=lang_sale('quote_detail')?>
                                <div class="card-header-actions float-right">
                                    <a class="btn btn-block btn-secondary" href="<?=route_admin('sale.quote.index')?>">
                                        <?=lang_common('back')?>
                                    </a>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold"><?=lang_sale('quote_no')?></label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$item->quote_no?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold"><?=lang_common('date')?></label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=\App\Helpers\DateHelper::toTimeString($item->created_at,'yyyy-MM-dd')?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold"><?=lang_common('name')?></label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$item->member_name?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold"><?=lang_common('id')?></label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$item->member_email?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="card card-secondary">
                                    <div class="card-header font-weight-bold">
                                        <?=lang_sale('quote_detail_item')?>
                                    </div>
                                    <div class="card-body" style="padding: 10px">
                                        <table class="table table-responsive-sm">
                                            <thead>
                                            <tr>
                                                <th><?=lang_common('part_no')?></th>
                                                <th><?=lang_manufacture('manufacture')?></th>
                                                <th><?=lang_common('qty')?></th>
                                                <th><?=lang_common('target_price')?></th>
                                                <th><?=lang_common('amount')?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php foreach ($details as $detail): ?>
                                                <tr>
                                                    <td><?=$detail->part_number?></td>
                                                    <td><?=$detail->name?></td>
                                                    <td>
                                                        <?=\App\Helpers\NumberHelper::format($detail->qty)?>
                                                    </td>
                                                    <td>
                                                        <?=\App\Helpers\NumberHelper::format($detail->price)?>
                                                    </td>
                                                    <td>
                                                        <?=\App\Helpers\NumberHelper::format($detail->price)?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-10 col-8 text-right">
                                        <label class="col-form-label font-weight-bold"><?=lang_common('amount')?></label>
                                    </div>
                                    <div class="col-md-2 col-4 text-right">
                                        <label class="col-form-label pr-2">
                                            <?=\App\Helpers\NumberHelper::format($item->amount)?>
                                        </label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-10 col-8 text-right">
                                        <label class="col-form-label font-weight-bold"><?=lang_common('vat')?></label>
                                    </div>
                                    <div class="col-md-2 col-4 text-right">
                                        <label class="col-form-label pr-2">
                                            <?=\App\Helpers\NumberHelper::format($item->total_vat)?>
                                        </label>
                                    </div>
                                </div>
                                <hr/>
                                <div class="row">
                                    <div class="col-md-10 col-8 text-right">
                                        <label class="col-form-label font-weight-bold"><?=lang_common('total')?></label>
                                    </div>
                                    <div class="col-md-2 col-4 text-right">
                                        <label class="col-form-label pr-2">
                                            <span class="badge badge-danger" style="font-size: 100%">
                                                <?=\App\Helpers\NumberHelper::format($item->total_amount)?>
                                            </span>
                                        </label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label for="textarea-input" class="font-weight-bold"><?=lang_sale('quote_memo')?></label>
                                            <textarea readonly style="background-color:#ffffff" class="form-control" id="textarea-input" name="textarea-input" rows="9"><?=$item->quote_memo?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer text-center">
                                <a class="btn btn-danger pl-5 pr-5" href="<?=route_admin('sale.quote.index')?>">
                                    <?=lang_common('list')?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>
