<?= $this->extend('admin/layouts/layout') ?>

<?= $this->section('head.title') ?>
<?=lang_sale('quote_detail')?>
<?= $this->endSection() ?>

<?= $this->section('head.css') ?>
<link href="<?=asset_admin_css('plugins/daterangepicker.min.css')?>" rel="stylesheet">
<style>
    th{text-align: center}
    .checkbox{width: 5%}
    .product_no{width: 5%}
    .image{width: 10%}
    .part_number{width: 10%}
    .manufacturer{width: 10%}
    .description{width: 10%;word-break: break-all;}
    .break-word{word-break: break-word;}
    .qty{width: 10%}
    .insert_date{width: 10%}
    .update_date{width: 10%}
    .action{width: 5%}
    input[type=checkbox]{
        transform: scale(1.5);
    }
    a.disabled {
        pointer-events: none;
        cursor: default;
    }
</style>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
<script src="<?=asset_admin_js('sale-quote.js')?>"></script>
<script src="<?=asset_admin_js('plugins/moment.min.js')?>"></script>
<script src="<?=asset_admin_js('plugins/daterangepicker.js')?>"></script>
<script src="<?=asset_admin_js('plugins/jquery.maskedinput.js')?>"></script>
<script src="<?=asset_admin_js('plugins/select2.min.js')?>"></script>
<script src="<?=asset_admin_js('advanced-forms.js')?>"></script>

<?= $this->endSection() ?>

<?= $this->section('content') ?>
<?=$breadcrumb->render('admin.taxinvoice.detail')?>

<div class="container-fluid">
    <div id="ui-view">
        <div>
            <div class="animated fadeIn">
                <div class="row">
                    <div class="col-md-12">
                        <div class="card ">
                            <div class="card-header">
                                <i class="fas fa-edit"></i> <?=lang_sale('quote_detail')?>
                                <div class="card-header-actions float-right">
                                    <a class="btn btn-block btn-secondary" href="<?=route_admin('taxinvoice.index')?>">
                                        <?=lang_common('back')?>
                                    </a>
                                </div>
                            </div>
                            <div class="card-body">

                    <div class="card card-secondary">
                        <div class="card-header font-weight-bold">
                            계산서 발행요청 내역
                        </div>
                        <div class="card-body" style="padding: 10px">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group row">
                                        <label class="col-md-3 col-form-label font-weight-bold">회사명</label>
                                        <div class="col-md-9">
                                            <label class="col-form-label">
                                                <?=$orderInfo->invoice_com?>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group row">
                                        <label class="col-md-3 col-form-label font-weight-bold">사업자번호</label>
                                        <div class="col-md-9">
                                            <label class="col-form-label">
                                                <?=$orderInfo->invoice_biznum?>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group row">
                                        <label class="col-md-3 col-form-label font-weight-bold">대표자명</label>
                                        <div class="col-md-9">
                                            <label class="col-form-label">
                                                <?=$orderInfo->invoice_ceo?>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

    
                    <div class="card card-secondary">

                        <div class="card-header font-weight-bold">
                                        주문내역
                                    </div>
                                    <div class="card-body" style="padding: 10px">

                                    <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">주문번호</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$orderInfo->order_code?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group row">
                                            <label class="col-md-6 col-form-label font-weight-bold">결제수단</label>
                                            <div class="col-md-6">
                                                <label class="col-form-label">
                                                <?php 
                                                    if($orderInfo->payment_flg =="Card") {
                                                        echo "이니페이 신용카드";
                                                    } elseif ($orderInfo->payment_flg == "Directbank"){
                                                        echo "이니페이 실시간이체";
                                                    } elseif ($orderInfo->payment_flg == "vbank"){
                                                        echo "이니페이 가상계좌";
                                                    } elseif ($orderInfo->payment_flg == "onlynaverpay"){
                                                        echo "이니페이 네이버페이";
                                                    } elseif ($orderInfo->payment_flg == "onlykakaopay"){
                                                        echo "이니페이 카카오페이";
                                                    } elseif ($orderInfo->payment_flg == "NPay"){
                                                        echo "네이버N페이";
                                                    } elseif ($orderInfo->payment_flg == "Tran"){
                                                        echo "무통장입금";
                                                    }
                                                ?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group row">
                                            <label class="col-md-5 col-form-label font-weight-bold">결제일시</label>
                                            <div class="col-md-7">
                                                <label class="col-form-label">
                                                    <?=$orderInfo->payment_date?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group row">
                                            <label class="col-md-5 col-form-label font-weight-bold">등록일시</label>
                                            <div class="col-md-7">
                                                <label class="col-form-label">
                                                    <?=\App\Helpers\DateHelper::toTimeString($orderInfo->created_at,'yyyy-MM-dd HH:mm')?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">발송예정</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$orderInfo->delivery_date?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">주문전체상태</label>
                                            <div class="col-md-9">
                                                    <?php
                                                    foreach ($orderstatus as $order_status):
                                                    if($order_status->status_code == $orderInfo->order_status) echo $order_status->status_info;
                                                    endforeach;
                                                    ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">이니페이 수단</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$orderInfo->payMethod?> (<?=$orderInfo->resultCode?> : <?=$orderInfo->resultMsg?>)
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <?php
                                if ($orderInfo->payMethod == "VBank") {
                                    echo "<div class='row'>
                                        <div class='col-md-4'>
                                            <div class='form-group row'>
                                                <label class='col-md-3 col-form-label font-weight-bold'>가상계좌은행</label>
                                                <div class='col-md-9'>
                                                    <label class='col-form-label'>
                                                        ".$orderInfo->vactBankName."
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class='col-md-4'>
                                            <div class='form-group row'>
                                                <label class='col-md-3 col-form-label font-weight-bold'>가상계좌번호</label>
                                                <div class='col-md-9'>
                                                    <label class='col-form-label'>
                                                        ".$orderInfo->VACT_Num."
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class='col-md-4'>
                                            <div class='form-group row'>
                                                <label class='col-md-3 col-form-label font-weight-bold'>>입금마감일</label>
                                                <div class='col-md-9'>
                                                    <label class='col-form-label'>
                                                        ".$orderInfo->VACT_Date."
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>";
                                }else if ($orderInfo->payMethod == "VCard") {
                                    echo "<div class='row'>
                                        <div class='col-md-4'>
                                            <div class='form-group row'>
                                                <label class='col-md-3 col-form-label font-weight-bold'>승인번호</label>
                                                <div class='col-md-9'>
                                                    <label class='col-form-label'>
                                                        ".$orderInfo->applNum."
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>";
                                }else if ($orderInfo->payMethod == "Card") {
                                    echo "<div class='row'>
                                        <div class='col-md-4'>
                                            <div class='form-group row'>
                                                <label class='col-md-3 col-form-label font-weight-bold'>승인번호</label>
                                                <div class='col-md-9'>
                                                    <label class='col-form-label'>
                                                        ".$orderInfo->applNum."
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class='col-md-4'>
                                            <div class='form-group row'>
                                                <label class='col-md-3 col-form-label font-weight-bold'>카드계열</label>
                                                <div class='col-md-9'>
                                                    <label class='col-form-label'>
                                                        ".$orderInfo->P_FN_NM."
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>";
                                }
                                ?>

                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">주문자<?=lang_common('name')?></label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$orderInfo->orderer_name?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">주문자 Email</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$orderInfo->orderer_email?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">주문자 휴대전화</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$orderInfo->orderer_phone?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">받는분</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$orderInfo->shipping_name?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">받는분 휴대전화</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$orderInfo->shipping_phone?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">받는분 전화</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$orderInfo->delivery_phone?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group row">
                                            <label class="col-md-1 col-form-label font-weight-bold">배송주소</label>
                                            <div class="col-md-11">
                                                <label class="col-form-label">
                                                    <?=$orderInfo->shipping_zipocode?>
                                                    <?=$orderInfo->shipping_add1?>
                                                    <?=$orderInfo->shipping_add2?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">배송메시지</label>
                                            <div class="col-md-9">
                                                <label class="col-form-label">
                                                    <?=$orderInfo->shipping_message?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label font-weight-bold">관리자 메모</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group row">
                                            <textarea class="form-control" id="notice" name="notice" rows="9"><?=old_value('notice',$orderInfo->notice)?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>



                        <div class="card card-secondary">
                            <div class="card-header font-weight-bold">
                                <?=lang_sale('quote_detail_item')?>
                            </div>
                            <div class="card-body" style="padding: 10px">

                <?php if (!$lists) :?>

                        <p class="mb-0">등록된 제품정보가 없습니다.</p>

                <?php else: ?>

                    <table class="table table-striped table-bordered datatable dataTable no-footer" id="DataTables_Table_0" role="grid" aria-describedby="DataTables_Table_0_info" style="border-collapse: collapse !important">
                    <thead>
                    <tr role="row">
                        <th style="text-align:center">제품사진</th>
                        <th style="text-align:center">주문상품</th>
                        <th style="text-align:center">단가</th>
                        <th style="text-align:center">주문수량</th>
                        <th style="text-align:center">상품주문상태</th>
                        <th style="text-align:center">공급가액</th>
                        <th style="text-align:center">VAT</th>
                        <th style="text-align:center">금액</th>
                        </th>
                    </tr>
                    </thead>
                    <tbody>

                <form method="post" action="<?=route_admin('taxinvoice.updateinfo',$orderInfo->info_id)?>" enctype="multipart/form-data" id="form">
                <input type="hidden" name="order_code" value="<?=$orderInfo->order_code?>"/>

                <?php 
                    $i = 1;
                    foreach($lists as $item){
                ?>
                    <tr>
                        <td style="text-align:center; vertical-align: middle;">
                        <?php if(isset($item->nowinfo['image_dir']) && $item->nowinfo['image_dir'] != ''): ?>
                            <?php if(isset($item->nowinfo['api_flg']) && $item->nowinfo['api_flg'] == '1'): ?>
                                <img src="<?=$item->nowinfo['image_dir']?>" width="100"/>
                            <?php else : ?>
                                <img src="<?=asset_public($item->nowinfo['image_dir'])?>" width="100"/>
                            <?php endif; ?>
                        <?php else : ?>
                            <img src="<?=asset_public('images/no_image_available.jpg')?>" width="100"/>
                        <?php endif; ?>
                        </td>
                        <td>
                            <div class="flex_sb">
                                <div class="subWrap01subTag01">
                                    제조사 : <?php echo $item->manufacturer_name;?>
                                </div>
                                <div class="subWrap01subTag01">
                                    부품명 : <?php echo $item->part_number;?>
                                </div>
                                <!--div class="subWrap01subTag01">
                                    재고위치 : 
                                    <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                        <?php if($stock_location->location_id == $item->stock_location) echo $stock_location->location_info;?>
                                    <?php endforeach; ?>
                                </div-->
                                <div class="subWrap01subTag01">
                                    공급사 : 
                                    <?php
                                    foreach ($apiinfos as $apiinfo):
                                        if($apiinfo->api_code == $item->nowinfo['api_code']) {
                                            echo $apiinfo->provider_name;
                                        }
                                    endforeach; 
                                    ?>
                                </div>
                                <?php
                                if($item->nowinfo['product_api_id']) {
                                    echo "<div class='subWrap01subTag01'>".$item->nowinfo['api_code']." 제품번호 : ".$item->nowinfo['product_api_id']."</div>";
                                }
                                ?>
                                <div class="subWrap01subTag01">
                                    샵 제품번호 : <?=$item->nowinfo['product_code']?>
                                </div>
                            </div>
                        </td>
                        <td style="text-align:center; vertical-align: middle;">
                            <span class="order_ListPrice"><?=number_format($item->price)?>원</span>
                        </td>
                        <td style="text-align:center; vertical-align: middle;">
                            <?php echo $item->qty;?>
                        </td>
                        <td style="text-align:center; vertical-align: middle;">
                            <?php
                            foreach ($orderstatus as $order_status):
                                if($order_status->status_code == $item->order_status) {
                                echo $order_status->status_info;
                                }
                            endforeach; 
                            ?>
                        </td>
                        <td style="text-align:center; vertical-align: middle;">
                            <span class="order_ListPrice"><?=number_format($item->supply_price)?>원</span>
                        </td>
                        <td style="text-align:center; vertical-align: middle;">
                            <span class="order_ListPrice"><?=number_format($item->vat)?>원</span>
                        </td>
                        <td style="text-align:center; vertical-align: middle;">
                            <span class="order_ListPrice"><?=number_format($item->amount)?>원</span>
                        </td>
                    </tr>

                    <input type="hidden" name="orderpart_count" value="<?=$i?>"/>

                        <?php

                            $all_qty = $all_qty + $item->qty;
                            $all_amount_price = $all_amount_price + $item->supply_price;
                            $all_price_vat = $all_price_vat + $item->vat;
                            $i++; 
                        }
                            $total_all_price = $all_amount_price + $all_price_vat;
                        
                        ?>
                    </tbody>
                </table>

                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group row">
                                            <label class="col-md-5 col-form-label font-weight-bold">상품총수량 : </label>
                                            <div class="col-md-6">
                                                <label class="col-form-label">
                                                <?=$all_qty?>개
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group row">
                                            <label class="col-md-5 col-form-label font-weight-bold">합계금액 : </label>
                                            <div class="col-md-6">
                                                <label class="col-form-label">
                                                <?=number_format($total_all_price)?>원 (VAT포함)
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group row">
                                            <label class="col-md-5 col-form-label font-weight-bold">배송료 : </label>
                                            <div class="col-md-6">
                                                <label class="col-form-label">
                                                <?=number_format($orderInfo->delivery_fee)?>원
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group row">
                                            <label class="col-md-5 col-form-label font-weight-bold">총 결제 금액 : </label>
                                            <div class="col-md-6">
                                                <label class="col-form-label">
                                                <?=number_format($orderInfo->amount_total)?>원
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                    </div>
                </div>
            
        <?php endif;?>

<!-------------------------------------------------------------------------------------------------------------------->


                            <div class="card-footer text-center">
                                <a class="btn btn-primary btn-lg" href="<?=route_admin('taxinvoice.index')?>"><?=lang_common('list')?></a>
                            </div>
                    </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</div>

<?= $this->endSection() ?>
