<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$settingInfo->app_name?>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<section id="siteMain" class="site-main">
    <div class="container">
        <div class="form-forgot">
            <?php if($session->has('message')): ?>
                <div class="alert alert-success">
                    <?=$session->get('message')?>
                </div>
            <?php endif; ?>
            <?php if($session->has('error_message')): ?>
                <div class="alert alert-danger">
                    <?=$session->get('error_message')?>
                </div>
            <?php endif; ?>
            <h2 class="form-title"><?=lang_login('forgot_title')?></h2>
            <form id="form" method="post" action="<?=route_guest('forgot_password.send')?>">
                <?php if(has_error('error_common')): ?>
                    <div class="alert alert-danger">
                        <span><?=get_error('error_common')?></span>
                    </div>
                <?php endif?>
                <div class="form-group">
                    <label for="member_email" class="form-label"><?=lang_login('forgot_content')?></label>
                    <input id="member_email" type="text" class="form-control" name="member_email" autocomplete="off"
                           aria-describedby="member_email" value="<?=old('member_email')?>"/>
                </div>
                <div class="form-action">
                    <button type="submit" class="btn btn-block btn-outline-primary w-100 active" name="submit"><?=lang_login('forgot_button_send')?></button>
                </div>
            </form>
        </div>
    </div>
</section>
<?= $this->endSection() ?>
