<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$settingInfo->app_name?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_guest_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<!--#siteMain-->
<!------------------------------------------------------------------------------------------------------------------->
<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap">

      <nav class="breadcrumb" style='background-color: #ffffff;'>
          <ul>
              <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
              <li><a href="#">회원가입</a></li> 
          </ul>            
      </nav>

        <div class="d-flex">
            <div class="row align-l">
                <h2 class="mb-0 pb-0">회원가입</h2>
                <p class="font-xsm col-gray"> </p>
            </div>
        </div>

        <div class="cart_flow mb-2">
            <div class="flow cartFlow_1second">01 가입유형</div>
            <div class="flow cartFlow_2second">02 가입서작성</div>
            <div class="flow cartFlow_3second">03 가입완료</div>
        </div>

        <form method="post" action="<?=route_guest('register.create')?>" enctype="multipart/form-data" id="form">
        <input type="hidden" name="member_code" value="<?="MBR".date(time())?>" required/>
        <input type="hidden" name="category_id" value="<?=$memCategory?>" required/>
        <input type="hidden" name="api_type" value="0" required/>
        <input type="hidden" name="member_phone" value="<?=$member_phone?>" required/>

        <!-- 주문자 정보 s -->
        <div class="border-light-box">
        <div class="sub_title d-flex">개인회원 정보</div>
            <div class="border-light-box order-form">

                <div class="form-gp">
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('name')?><span class="col-red">*</span></label>
                        <input id="member_name" value="" type="text" class="form-control" name="member_name" aria-describedby="member_name"/>
                    </div>
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('email')?><span class="col-red">*</span></label>
                        <input id="member_email" value="" type="text" class="form-control" name="member_email" aria-describedby="member_email"/>
                    </div>  
                </div>
                <div class="form-gp">
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('password')?><span class="col-red">*</span></label>
                        <input id="password" type="password" class="form-control" name="password" aria-describedby="password"/>
                    </div>
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('confirm_password')?><span class="col-red">*</span></label>
                        <input id="pass_confirm" type="password" class="form-control" name="pass_confirm" aria-describedby="pass_confirm"/>
                    </div>  
                </div>
                <div class="form-gp">
                    <div class="d-flex g-1">
                        <label for=""> </label>
                        <?=lang_register('password_note')?>
                    </div>                
                </div>
                <div class="form-gp">
                    <div class="d-flex g-2">
                        <label for=""><?=lang_register('phone')?><span class="col-red">*</span></label>
                        <input id="member_phone" value="<?=$member_phone?>" disabled type="text" class="form-control" aria-describedby="member_phone"/>
                    </div>
                    <div class="d-flex g-2">
                        <label for="">인증번호<span class="col-red">*</span></label>
                        <input id="certificationMd5" value="<?=$certificationMd5?>" type="hidden" name="certificationMd5" required/>     
                        <input id="certification" class="form-control col-md-4" value="" type="text" name="certification" onchange="check()" required/>
                        <div id="check"><span class="text-danger">인증번호가 일치하지 않습니다.</span></div>
                    </div>  
                </div>
                <div class="form-gp">
                    <div class="d-flex g-2">
                        <label for=""><?=lang_info_edit('zipcode')?><span class="col-red">*</span></label>
                        <div class="group-btn d-flex">
                        <input type="text" id="member_zipcode" name="member_zipcode" value="" placeholder="<?=lang_info_edit('zipcode')?>"/>
                        <input type="button" onclick="addr01_execDaumPostcode()" value="우편번호 찾기" class="btn btn-gray ml-1">
                        </div>
                    </div>
                    <div class="d-flex g-2"> </div>
                </div>
                <div class="form-gp">                
                    <div class="d-flex g-2">
                        <label for=""><?=lang_info_edit('address1')?><span class="col-red">*</span></label>
                        <input type="text" id="member_address1" name="member_address1" value="" placeholder="<?=lang_info_edit('address1')?>" required/>
                    </div>
                </div>
                <div class="form-gp">                
                    <div class="d-flex g-2">
                        <label for=""><?=lang_info_edit('address2')?></label>
                        <input type="text" id="member_address2" name="member_address2"  value="" placeholder="<?=lang_info_edit('address2')?>"/>
                    </div>
                </div>

            </div>
        </div>

        <div class="order-btn-box mt-3 mb-2"> </div>
        <div class="order-btn-box btn-lg-box btn-box align-c">
            <button type="submit" class="btn btn-lg btn-blue w-20 ml-1"><?=lang_common('create')?></button>
        </div>
            
        </form>

<!------------------------------------------------------------------------------------------------------------------->
</div>
</section>
<!-- product details top info e -->
<!------------------------------------------------------------------------------------------------------------------->

    <script>
        function check() {
        <?php
            echo "let certification = $('#certification').val();";
            echo "let certificationMd5 = '$certification';";
        ?>
            if (certification!==certificationMd5) {
                $("#check").show();
            } else{
                $("#check").hide();
            }
        }
            $(document).ready(function() {
            $("#check").hide();
        });
    </script>

        
    <script src="//t1.daumcdn.net/mapjsapi/bundle/postcode/prod/postcode.v2.js"></script>
    <script>
        function addr01_execDaumPostcode() {
            new daum.Postcode({
                oncomplete: function(data) {
                    var addr = ''; // 주소 변수
                    var extraAddr = ''; // 참고항목 변수
                    
                    if (data.userSelectedType === 'R') { // 사용자가 도로명 주소를 선택했을 경우
                        addr = data.roadAddress;
                    } else { // 사용자가 지번 주소를 선택했을 경우(J)
                        addr = data.jibunAddress;
                    }

                    if(data.userSelectedType === 'R'){
                        if(data.bname !== '' && /[동|로|가]$/g.test(data.bname)){
                            extraAddr += data.bname;
                        }

                        if(data.buildingName !== '' && data.apartment === 'Y'){
                            extraAddr += (extraAddr !== '' ? ', ' + data.buildingName : data.buildingName);
                        }

                        if(extraAddr !== ''){
                            extraAddr = ' (' + extraAddr + ')';
                        }

                        document.getElementById("member_address2").value = extraAddr;                    
                    } else {
                        document.getElementById("member_address2").value = '';
                    }
                    document.getElementById('member_zipcode').value = data.zonecode;
                    document.getElementById("member_address1").value = addr;
                    document.getElementById("member_address2").focus();
                }
            }).open();
        }

        function addr02_execDaumPostcode() {
            new daum.Postcode({
                oncomplete: function(data) {
                    var addr = ''; // 주소 변수
                    var extraAddr = ''; // 참고항목 변수
                    
                    if (data.userSelectedType === 'R') { // 사용자가 도로명 주소를 선택했을 경우
                        addr = data.roadAddress;
                    } else { // 사용자가 지번 주소를 선택했을 경우(J)
                        addr = data.jibunAddress;
                    }

                    if(data.userSelectedType === 'R'){
                        if(data.bname !== '' && /[동|로|가]$/g.test(data.bname)){
                            extraAddr += data.bname;
                        }

                        if(data.buildingName !== '' && data.apartment === 'Y'){
                            extraAddr += (extraAddr !== '' ? ', ' + data.buildingName : data.buildingName);
                        }

                        if(extraAddr !== ''){
                            extraAddr = ' (' + extraAddr + ')';
                        }

                        document.getElementById("com_address2").value = extraAddr;                    
                    } else {
                        document.getElementById("com_address2").value = '';
                    }
                    document.getElementById('com_zipcode').value = data.zonecode;
                    document.getElementById("com_address1").value = addr;
                    document.getElementById("com_address2").focus();
                }
            }).open();
        }

    </script>

    <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
    <script>
        swal({
        title: "인증번호를 전송했습니다.",
        text: "등록하신 휴대전화 인증번호를 문자로 받으셨나요?",
        icon: "warning",
        buttons: ["네" , "아니요"]
        })
        .then(function(result){
            console.log(result);
            
            if(result){
                location.href = "/register";
            }
        });
    </script>

<?= $this->endSection() ?>
