<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_cart('title')?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('bootstrap-input-spinner.js')?>"></script>
    <script src="<?=asset_guest_js('form.input.number.js')?>"></script>
    <script src="<?=asset_guest_js('cart.js')?>"></script>
    <script>
        $("input[type='number']").inputSpinner();
        CartJS.init();
    </script>

    <script language="javascript" type="text/javascript">
        var name1 = "";
        var phone1 = "";
        var name2 = "";
        var phone2 = "";
        var name3 = "";
        var phone3 = "";
        var name4 = "";
        var phone4 = "";
        var name5 = "";
        var phone5 = "";
        var name6 = "";
        var phone6 = "";

        function InitValue1(frm){
            name1 = frm.orderer_name1.value;
            phone1 = frm.orderer_phone1.value;
        }
        function ShipToBill1(frm){		
            if(frm.agree1.checked){
                InitValue1(frm);
                document.getElementById("shipping_name1").value = document.getElementById("orderer_name1").value;
                document.getElementById("shipping_phone1").value = document.getElementById("orderer_phone1").value;
            }else{
                frm.shipping_name1.value="";
                frm.shipping_phone1.value="";
            }
        } 

        function InitValue2(frm){
            name2 = frm.orderer_name2.value;
            phone2 = frm.orderer_phone2.value;
        }
        function ShipToBill2(frm){		
            if(frm.agree2.checked){
                InitValue2(frm);
                document.getElementById("shipping_name2").value = document.getElementById("orderer_name2").value;
                document.getElementById("shipping_phone2").value = document.getElementById("orderer_phone2").value;
            }else{
                frm.shipping_name2.value="";
                frm.shipping_phone2.value="";
            }
        }

        function InitValue3(frm){
            name3 = frm.orderer_name3.value;
            phone3 = frm.orderer_phone3.value;
        }
        function ShipToBill3(frm){		
            if(frm.agree3.checked){
                InitValue3(frm);
                document.getElementById("shipping_name3").value = document.getElementById("orderer_name3").value;
                document.getElementById("shipping_phone3").value = document.getElementById("orderer_phone3").value;
            }else{
                frm.shipping_name3.value="";
                frm.shipping_phone3.value="";
            }
        }

        function InitValue4(frm){
            name4 = frm.orderer_name4.value;
            phone4 = frm.orderer_phone4.value;
        }
        function ShipToBill4(frm){		
            if(frm.agree4.checked){
                InitValue4(frm);
                document.getElementById("shipping_name4").value = document.getElementById("orderer_name4").value;
                document.getElementById("shipping_phone4").value = document.getElementById("orderer_phone4").value;
            }else{
                frm.shipping_name4.value="";
                frm.shipping_phone4.value="";
            }
        } 

        function InitValue5(frm){
            name5 = frm.orderer_name5.value;
            phone5 = frm.orderer_phone5.value;
        }
        function ShipToBill5(frm){		
            if(frm.agree5.checked){
                InitValue5(frm);
                document.getElementById("shipping_name5").value = document.getElementById("orderer_name5").value;
                document.getElementById("shipping_phone5").value = document.getElementById("orderer_phone5").value;
            }else{
                frm.shipping_name5.value="";
                frm.shipping_phone5.value="";
            }
        }

        function InitValue6(frm){
            name6 = frm.orderer_name6.value;
            phone6 = frm.orderer_phone6.value;
        }
        function ShipToBill6(frm){		
            if(frm.agree6.checked){
                InitValue6(frm);
                document.getElementById("shipping_name6").value = document.getElementById("orderer_name6").value;
                document.getElementById("shipping_phone6").value = document.getElementById("orderer_phone6").value;
            }else{
                frm.shipping_name6.value="";
                frm.shipping_phone6.value="";
            }
        }
    </script>


    <script type="text/javascript">
        function paybtn() {
            var orderer_name = document.getElementById("orderer_name");
                if (orderer_name.value == "") {
                    alert("주문하는 분 이름을 입력하세요.");
                    orderer_name.focus();
                    return false;
                };
            var orderer_email = document.getElementById("orderer_email");
                if (orderer_email.value == "") {
                    alert("주문하는 분 E-MAIL을 입력하세요.");
                    orderer_email.focus();
                    return false;
                };
            var orderer_phone = document.getElementById("orderer_phone");
                if (orderer_phone.value == "") {
                    alert("주문하는 분 전화번호를 입력하세요.");
                    orderer_phone.focus();
                    return false;
                };
            var shipping_name = document.getElementById("shipping_name");
                if (shipping_name.value == "") {
                    alert("받는 분 이름을 입력하세요.");
                    shipping_name.focus();
                    return false;
                };
            var shipping_phone = document.getElementById("shipping_phone");
                if (shipping_phone.value == "") {
                    alert("받는 분 휴대 전화번호를 입력하세요.");
                    shipping_phone.focus();
                    return false;
                };
            var shipping_zipocode = document.getElementById("shipping_zipocode");
                if (shipping_zipocode.value == "") {
                    alert("배송지 우편번호를 입력하세요.");
                    shipping_zipocode.focus();
                    return false;
                };
            var shipping_add1 = document.getElementById("shipping_add1");
                if (shipping_add1.value == "") {
                    alert("배송지 주소를 입력하세요.");
                    shipping_add1.focus();
                    return false;
                };

            INIStdPay.pay('SendPayForm_id');
        }
    </script>

    <script>
        function chooseForm(radioName) {
        var radios = document.getElementsByName(radioName);
        for (var i = 0, length = radios.length; i < length; i++) {
            document.getElementById('form_' + radios[i].value).style.display = 'none';
            if (radios[i].checked) {
            document.getElementById('form_' + radios[i].value).style.display = 'block';
            }
        }
        }
    </script>

<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb') ?>
    <?php $breadcrumb->render('guest.cart')?>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<!--#siteMain-->

<?php if(AuthHelpers::checkLoginGuest()):?>
<!-- 회원인증 주문서작성 시작 -->
<!------------------------------------------------------------------------------------------------------------------->

    <?php if (!$lists) :?>
        <div class="order_List mb40">
            <p class="mb-0"><?=lang_common('toitem_msg1')?><a href="<?=route_guest('home')?>"><?=lang_common('toitem_msg2')?></a><?=lang_common('toitem_msg3')?></p>
        </div>
    <?php else: ?>
        <!------------------------------------------------------------------------------------------------------------------->
        <!-- product details top info s -->
<section class="sub_wrap">
<div class="content_wrap">

                <div class="d-flex">
                    <div class="row align-l">
                        <h2 class="mb-0 pb-0">주문/결제</h2>
                        <p class="font-xsm col-gray">주문/결제 정보를 정확히 입력해 주세요.</p>
                    </div>
                </div>

                <div class="cart_flow mb-2">
                    <div class="flow cartFlow_1second">01 장바구니</div>
                    <div class="flow cartFlow_2second">02 주문/결제</div>
                    <div class="flow cartFlow_3second">03 주문완료</div>
                </div>
                
                <!-- 결제수단 s -->
                <div class="border-light-box">
                    <div class="sub_title mb-1">결제수단</div>

                    <ul class="tabnav paypay-btn">
                        <li><a href="#tab01">신용카드</a></li>
                        <li><a href="#tab02">실시간 이체</a></li>
                        <li><a href="#tab03">무통장 입금</a></li>
                    </ul>
                </div>
                <!-- 결제수단 e -->

        <div class="tabcontent">
            <div id="tab01" class="order_cnt1">
            <!-- 탭 정보1 s -->

            <form id="SendPayForm_id" name="user_form" method="post" action="<?=route_guest('cart.inipay')?>">
                <!-- 주문 상품정보 s -->
                <div class="border-light-box">
                    <div class="sub_title">주문 상품정보</div>
                    <table class="table_style2 order_list">
                        <thead>
                            <tr>
                                <th>이미지</th>
                                <th>주문상품</th>
                                <th>단가</th>
                                <th>주문수량</th>
                                <th>공급가액</th>
                                <th>VAT</th>
                                <th>금액</th>
                            </tr>
                        </thead>
                        
                        <?php 
                        $all_amount_price = 0;
                        $all_price_vat = 0;
                        $delivery_prices = 0;
                        $all_order_total = 0;
                        $i = 1; 
                        $deliverydays = 0;

                        foreach ($lists as $key => $item) {

                            $item_price = $item->price;
                            $amount_price = $item_price * $item->qty;
                            $price_vat = $amount_price*0.1;
                            $total_price = $amount_price+$price_vat;
                        ?>
                            <tr>
                                <td><p class="prd-img">
                                    <?php if(isset($item->nowinfo['image_dir']) && $item->nowinfo['image_dir'] != ''): ?>
                                <?php if(isset($item->nowinfo['api_flg']) && $item->nowinfo['api_flg'] == '1'): ?>
                                    <img src="<?=$item->nowinfo['image_dir']?>"/>
                                <?php else : ?>
                                    <img src="<?=asset_public($item->nowinfo['image_dir'])?>"/>
                                <?php endif; ?>
                                <?php else : ?>
                                    <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                                <?php endif; ?>
                                </p></td>
                                <td>
                                    <p><label class="badge_blue font-sm">
                                        <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                            <?php if($stock_location->location_id == $item->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                        <?php endforeach; ?>
                                    </label></p>
                                    <p class="col-blue font-sm"><?=$item->name?></p>
                                    <p class="prd-subject"><?=$item->nowinfo['part_number']?></p>
                                    <input type="hidden" name="inquiry_id<?=$i?>" value="<?=$item->inquiry_id?>"/>
                                    <?php $inquiry_id_all = $inquiry_id_all.$item->inquiry_id.","; ?>
                                    <p class="prd-cmt col-gray font-sm"><?=$item->nowinfo['product_code']?></p>
                                    <p class="prd-option col-gray font-sm">
                                        <?php
                                        $brief_description = $item->nowinfo['brief_description'];
                                        $prd_description = explode('|^|', $brief_description);

                                        echo mb_strimwidth($prd_description[1],'0',40,'...','utf-8');
                                        ?>
                                    </p>
                                </td>
                                <td><?=number_format($item_price)?>원</td>
                                <input type="hidden" name="price<?=$i?>" value="<?=$item_price?>"/>
                                <td><?php echo $item->qty;?></td>
                                <input type="hidden" name="qty<?=$i?>" value="<?=$item->qty?>"/>
                                <td><?=number_format($amount_price)?>원</td>
                                <input type="hidden" name="supply_price<?=$i?>" value="<?=$amount_price?>"/>
                                <td><?=number_format($price_vat)?>원</td>
                                <input type="hidden" name="vat<?=$i?>" value="<?=$price_vat?>"/>
                                <td><?=number_format($total_price)?>원</td>
                                <input type="hidden" name="amount<?=$i?>" value="<?=$total_price?>"/>
                            </tr>
                    
                            <?php 
                            if ($i > 1) {
                                $inistgoodname = $item->nowinfo['product_code']." 외 ".count($lists)."개 품목";
                            } else {
                                $inistgoodname = $item->nowinfo['product_code'];
                            }

                            if ($deliverydays > $item->leadtime_info) {
                                $deliverydays = $deliverydays;
                            } else {
                                $deliverydays = $item->leadtime_info;
                            }

                            if ($delivery_prices > $item->delivery_price) {
                                $delivery_prices = $delivery_prices;
                            } else {
                                $delivery_prices = $item->delivery_price;
                            }

                                $all_amount_price = $all_amount_price + $amount_price;
                                $all_price_vat = $all_price_vat + $price_vat;
                                $i++; 
                        }

                            $delivery_free_standard = 30000; // 배송료무료 기준설정

                            if ($all_amount_price > $delivery_free_standard) {
                                $delivery_prices = 0;
                            }
                            
                            $all_order_total = 0;
                            $all_order_total = $all_amount_price + $all_price_vat + $delivery_prices;
                            $deliverytime = strtotime($deliverydays."days");

                            $del_han = $lists[0]->part_number;
                            $firstitem_number = preg_replace("/([^a-zA-Z0-9_\-+])/", "", $del_han); // 영/숫자/지정기호 이외 제거
                            ?>
                        </tbody>
                    </table>

                    
                    <dl class="order_list_mobile">
                        <dt>
                            <?php
                            $i = 1; 
                            $deliverydays = 0;
                            foreach($lists as $item_mobile){
                            ?>
                            <div class="prd-img">
                                <?php if(isset($item_mobile->nowinfo['image_dir']) && $item_mobile->nowinfo['image_dir'] != ''): ?>
                                    <?php if(isset($item_mobile->nowinfo['api_flg']) && $item_mobile->nowinfo['api_flg'] == '1'): ?>
                                        <img src="<?=$item_mobile->nowinfo['image_dir']?>"/>
                                    <?php else : ?>
                                        <img src="<?=asset_public($item_mobile->nowinfo['image_dir'])?>"/>
                                    <?php endif; ?>
                                <?php else : ?>
                                    <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                                <?php endif; ?>
                            </div>

                            <div class="prd-info">
                                <p><label class="badge_blue font-sm">
                                    <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                        <?php if($stock_location->location_id == $item_mobile->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                    <?php endforeach; ?>
                                </label></p>                     
                                <p class="col-blue font-sm"><?=$item_mobile->name;?></p>
                                <p class="prd-subject"><?=$item_mobile->part_number;?></p>
                                <p class="prd-cmt col-gray font-sm"><?=$item_mobile->nowinfo['product_code']?></p>
                                <p class="prd-option col-gray font-sm">
                                        <?php
                                        $brief_description = $item_mobile->nowinfo['brief_description'];
                                        $prd_description = explode('|^|', $brief_description);
                                        echo mb_strimwidth($prd_description[1],'0',30,'...','utf-8');
                                        ?>
                                </p>
                                <p class="prd-subject">단가 : <?=number_format($item_price)?>원</p>
                                <p class="prd-subject">수량 : <?php echo $item->qty;?></p>
                            </div>
                            <?php 
                                $i++; 
                            } 
                            ?>
                        </dt>
                        <dd class="bg-light-gray border-b">
                            <ul>
                                <li>공급가액</li> <li><?=number_format($all_amount_price)?>원</li>
                                <li>VAT</li> <li><?=number_format($all_price_vat)?>원</li>
                                <li>배송비</li> <li><?=number_format($delivery_prices)?></li>
                                <li>총금액</li> <li><?=number_format($all_order_total)?>원</li>
                            </ul>
                        </dd>
                    </dl>

                    <table class="table_style2 order_list_footer">
                        <thead>
                            <tr>
                                <th>공급가액</th>
                                <th>부가세(VAT)</th>
                                <th>배송비</th>
                                <th>총 결제 금액(VAT포함)</th>                        
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><?=number_format($all_amount_price)?>원</td>
                                <td><?=number_format($all_price_vat)?>원</td>
                                <td><?=number_format($delivery_prices)?>원</td>
                                <td><?=number_format($all_order_total)?>원</td>                        
                            </tr>                    
                        </tbody>
                    </table>
                </div>
                
                <input type="hidden" id="supply_price" name="supply_price" value="<?=$all_amount_price?>"/>
                <input type="hidden" id="vat" name="vat" value="<?=$all_price_vat?>"/>
                <input type="hidden" id="delivery_fee" name="delivery_fee" value="<?=$delivery_prices?>"/>
                <input type="hidden" id="amount_total" name="amount_total" value="<?=round($all_order_total)?>"/>

                <!-- 주문 상품정보 e -->
                <input type="hidden" id="inquiry_code" name="inquiry_code" value="<?=$lists[0]->inquiry_code?>">
                <input type="hidden" id="firstitem_number" name="firstitem_number" value="<?=$firstitem_number?>">
                <input type="hidden" id="item_counts" name="item_counts" value="<?=count($lists)?>">
                <input type="hidden" id="dataRow" name="dataRow" value="<?=$i?>">

                        <!-- 주문자 정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">주문자 정보</div>
                            
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">주문자</label>
                                    <input id="orderer_name1" type="text" name="buyername" value="<?=$userinfo->member_name?>" aria-describedby="orderer_name" required/>
                                    <input id="member_code" type="hidden" name="member_code" value="<?=$userinfo->member_code?>"/>
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">이메일</label>
                                    <input id="orderer_email" type="email" name="buyeremail" value="<?=$userinfo->member_email?>"  aria-describedby="orderer_email" required/>
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">주문자 휴대폰 <span class="col-red">*</span></label>
                                    <input id="orderer_phone1" type="text" name="buyertel" value="<?=$userinfo->member_phone?>" aria-describedby="orderer_phone" required/>
                                </div>                
                            </div>
                        </div>
                        <!-- 주문자 정보 e -->
                        <input type="hidden" name="price" value="<?php echo $all_order_total ?>">

                        <!-- 배송지 정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">배송지 정보
                            <label class="input-container ml-1">주문자정보 동일
                                    <input type="checkbox" id="agree1" onclick="ShipToBill1(this.form);"/>
                                    <span class="checkmark"></span>
                                </label>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분 <span class="col-red">*</span></label>
                                    <input id="shipping_name1" type="text" name="shipping_name"  value="<?=$userinfo->member_name?>" aria-describedby="shipping_name" required/>
                                </div>                
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분 휴대폰 <span class="col-red">*</span></label>
                                    <input id="shipping_phone1" type="text" name="shipping_phone" value="<?=$userinfo->member_phone?>" aria-describedby="shipping_phone" required/>
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">받는분 전화 <span class="col-red">*</span></label>
                                    <input id="delivery_phone" type="text" name="delivery_phone" value="<?=$usersubinfo->com_phone?>" aria-describedby="delivery_phone"/>
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">회사명</label>
                                    <input id="company_name" type="text" name="company_name" value="<?=$usersubinfo->com_name?>" placeholder="회사(학교)명을 입력하세요.">
                                </div>
                            </div>
                            <?php
                            if ($usersubinfo->com_zipcode) {
                                $user_zipcode = $usersubinfo->com_zipcode;
                            } else {
                                $user_zipcode = $userinfo->member_zipcode;
                            }
                            if ($usersubinfo->com_address1) {
                                $user_address1 = $usersubinfo->com_address1;
                            } else {
                                $user_address1 = $userinfo->member_address1;
                            }
                            if ($usersubinfo->com_address2) {
                                $user_address2 = $usersubinfo->com_address2;
                            } else {
                                $user_address2 = $userinfo->member_address2;
                            }
                            ?>

                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">우편번호</label>
                                    <div class="group-btn d-flex">
                                    <input id="shipping_zipocode1" type="text" name="shipping_zipocode" value="<?=$user_zipcode?>" placeholder="우편번호">
                                    <input type="button" onclick="execDaumPostcode1()" value="우편번호 찾기" class="btn btn-gray ml-1">
                                    </div>
                                </div>
                                <div class="d-flex g-2"> </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송지</label>
                                    <input id="shipping_add11" type="text" name="shipping_add1" value="<?=$user_address1?>" placeholder="주소" required>
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송지</label>
                                    <input id="shipping_add12" type="text" name="shipping_add2" value="<?=$user_address2?>" placeholder="상세주소">
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송메시지 </label>
                                    <input id="shipping_message" type="text" name="shipping_message"  placeholder="배송메시지를 입력하세요.">
                                </div>
                            </div>
                        </div>
                        <!-- 배송지 정보 e -->
                        <input type="hidden" name="payment_flg" value="Card">

                        <div class="order-btn-box btn-box">
                                <!--button class="btn font-xsm btn-outline-white float-l">거래 명세서 출력하기</button-->            
                                <!--button class="btn font-xsm btn-outline-white float-r ml-1">목록으로</button-->
                                <!--button class="btn font-xsm btn-outline-white float-r">수정하기</button-->                
                        </div>

                <div class="order-btn-box mt-3 mb-2"> </div>
                <div class="order-btn-box btn-lg-box btn-box align-c">
                    <a href="<?=route_guest('cart')?>" class="btn btn-lg btn-outline-white" style="width:47%;">장바구니로</a>
                    <button onclick="paybtn()" type="submit" class="btn btn-lg btn-blue ml-1" style="width:47%;">다음</button>
                </div>
            </form>

            <!-- 탭 정보1 e -->
            </div>

            <!-- 실시간 이체 -->
            <div id="tab02" class="order_cnt2">
            <!-- 탭 정보2 s -->

            <form id="SendPayForm_id" name="user_form" method="post" action="<?=route_guest('cart.inipay')?>">
                <!-- 주문 상품정보 s -->
                <div class="border-light-box">
                    <div class="sub_title">주문 상품정보</div>
                    <table class="table_style2 order_list">
                        <thead>
                            <tr>
                                <th>이미지</th>
                                <th>주문상품</th>
                                <th>단가</th>
                                <th>주문수량</th>
                                <th>공급가액</th>
                                <th>VAT</th>
                                <th>금액</th>
                            </tr>
                        </thead>
                        
                        <?php 
                        $all_amount_price = 0;
                        $all_price_vat = 0;
                        $delivery_prices = 0;
                        $all_order_total = 0;
                        $i = 1; 
                        $deliverydays = 0;

                        foreach ($lists as $key => $item) {

                            $item_price = $item->price;
                            $amount_price = $item_price * $item->qty;
                            $price_vat = $amount_price*0.1;
                            $total_price = $amount_price+$price_vat;
                        ?>
                            <tr>
                                <td><p class="prd-img">
                                    <?php if(isset($item->nowinfo['image_dir']) && $item->nowinfo['image_dir'] != ''): ?>
                                <?php if(isset($item->nowinfo['api_flg']) && $item->nowinfo['api_flg'] == '1'): ?>
                                    <img src="<?=$item->nowinfo['image_dir']?>"/>
                                <?php else : ?>
                                    <img src="<?=asset_public($item->nowinfo['image_dir'])?>"/>
                                <?php endif; ?>
                                <?php else : ?>
                                    <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                                <?php endif; ?>
                                </p></td>
                                <td>
                                    <p><label class="badge_blue font-sm">
                                        <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                            <?php if($stock_location->location_id == $item->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                        <?php endforeach; ?>
                                    </label></p>
                                    <p class="col-blue font-sm"><?=$item->name?></p>
                                    <p class="prd-subject"><?=$item->nowinfo['part_number']?></p>
                                    <input type="hidden" name="inquiry_id<?=$i?>" value="<?=$item->inquiry_id?>"/>
                                    <?php $inquiry_id_all = $inquiry_id_all.$item->inquiry_id.","; ?>
                                    <p class="prd-cmt col-gray font-sm"><?=$item->nowinfo['product_code']?></p>
                                    <p class="prd-option col-gray font-sm">
                                        <?php
                                        $brief_description = $item->nowinfo['brief_description'];
                                        $prd_description = explode('|^|', $brief_description);

                                        echo mb_strimwidth($prd_description[1],'0',40,'...','utf-8');
                                        ?>
                                    </p>
                                </td>
                                <td><?=number_format($item_price)?>원</td>
                                <input type="hidden" name="price<?=$i?>" value="<?=$item_price?>"/>
                                <td><?php echo $item->qty;?></td>
                                <input type="hidden" name="qty<?=$i?>" value="<?=$item->qty?>"/>
                                <td><?=number_format($amount_price)?>원</td>
                                <input type="hidden" name="supply_price<?=$i?>" value="<?=$amount_price?>"/>
                                <td><?=number_format($price_vat)?>원</td>
                                <input type="hidden" name="vat<?=$i?>" value="<?=$price_vat?>"/>
                                <td><?=number_format($total_price)?>원</td>
                                <input type="hidden" name="amount<?=$i?>" value="<?=$total_price?>"/>
                            </tr>
                    
                            <?php 
                            if ($i > 1) {
                                $inistgoodname = $item->nowinfo['product_code']." 외 ".count($lists)."개 품목";
                            } else {
                                $inistgoodname = $item->nowinfo['product_code'];
                            }

                            if ($deliverydays > $item->leadtime_info) {
                                $deliverydays = $deliverydays;
                            } else {
                                $deliverydays = $item->leadtime_info;
                            }

                            if ($delivery_prices > $item->delivery_price) {
                                $delivery_prices = $delivery_prices;
                            } else {
                                $delivery_prices = $item->delivery_price;
                            }

                                $all_amount_price = $all_amount_price + $amount_price;
                                $all_price_vat = $all_price_vat + $price_vat;
                                $i++; 
                        }

                            $delivery_free_standard = 30000; // 배송료무료 기준설정

                            if ($all_amount_price > $delivery_free_standard) {
                                $delivery_prices = 0;
                            }
                            
                            $all_order_total = 0;
                            $all_order_total = $all_amount_price + $all_price_vat + $delivery_prices;
                            $deliverytime = strtotime($deliverydays."days");

                            $del_han = $lists[0]->part_number;
                            $firstitem_number = preg_replace("/([^a-zA-Z0-9_\-+])/", "", $del_han); // 영/숫자/지정기호 이외 제거
                            ?>
                        </tbody>
                    </table>

                    
                    <dl class="order_list_mobile">
                        <dt>
                            <?php
                            $i = 1; 
                            $deliverydays = 0;
                            foreach($lists as $item_mobile){
                            ?>
                            <div class="prd-img">
                                <?php if(isset($item_mobile->nowinfo['image_dir']) && $item_mobile->nowinfo['image_dir'] != ''): ?>
                                    <?php if(isset($item_mobile->nowinfo['api_flg']) && $item_mobile->nowinfo['api_flg'] == '1'): ?>
                                        <img src="<?=$item_mobile->nowinfo['image_dir']?>"/>
                                    <?php else : ?>
                                        <img src="<?=asset_public($item_mobile->nowinfo['image_dir'])?>"/>
                                    <?php endif; ?>
                                <?php else : ?>
                                    <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                                <?php endif; ?>
                            </div>

                            <div class="prd-info">
                                <p><label class="badge_blue font-sm">
                                    <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                        <?php if($stock_location->location_id == $item_mobile->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                    <?php endforeach; ?>
                                </label></p>                     
                                <p class="col-blue font-sm"><?=$item_mobile->name;?></p>
                                <p class="prd-subject"><?=$item_mobile->part_number;?></p>
                                <p class="prd-cmt col-gray font-sm"><?=$item_mobile->nowinfo['product_code']?></p>
                                <p class="prd-option col-gray font-sm">
                                        <?php
                                        $brief_description = $item_mobile->nowinfo['brief_description'];
                                        $prd_description = explode('|^|', $brief_description);
                                        echo mb_strimwidth($prd_description[1],'0',30,'...','utf-8');
                                        ?>
                                </p>
                                <p class="prd-subject">단가 : <?=number_format($item_price)?>원</p>
                                <p class="prd-subject">수량 : <?php echo $item->qty;?></p>
                            </div>
                            <?php 
                                $i++; 
                            } 
                            ?>
                        </dt>
                        <dd class="bg-light-gray border-b">
                            <ul>
                                <li>공급가액</li> <li><?=number_format($all_amount_price)?>원</li>
                                <li>VAT</li> <li><?=number_format($all_price_vat)?>원</li>
                                <li>배송비</li> <li><?=number_format($delivery_prices)?></li>
                                <li>총금액</li> <li><?=number_format($all_order_total)?>원</li>
                            </ul>
                        </dd>
                    </dl>

                    <table class="table_style2 order_list_footer">
                        <thead>
                            <tr>
                                <th>공급가액</th>
                                <th>부가세(VAT)</th>
                                <th>배송비</th>
                                <th>총 결제 금액(VAT포함)</th>                        
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><?=number_format($all_amount_price)?>원</td>
                                <td><?=number_format($all_price_vat)?>원</td>
                                <td><?=number_format($delivery_prices)?>원</td>
                                <td><?=number_format($all_order_total)?>원</td>                        
                            </tr>                    
                        </tbody>
                    </table>
                </div>
                
                <input type="hidden" id="supply_price" name="supply_price" value="<?=$all_amount_price?>"/>
                <input type="hidden" id="vat" name="vat" value="<?=$all_price_vat?>"/>
                <input type="hidden" id="delivery_fee" name="delivery_fee" value="<?=$delivery_prices?>"/>
                <input type="hidden" id="amount_total" name="amount_total" value="<?=round($all_order_total)?>"/>

                <!-- 주문 상품정보 e -->
                <input type="hidden" id="inquiry_code" name="inquiry_code" value="<?=$lists[0]->inquiry_code?>">
                <input type="hidden" id="firstitem_number" name="firstitem_number" value="<?=$firstitem_number?>">
                <input type="hidden" id="item_counts" name="item_counts" value="<?=count($lists)?>">
                <input type="hidden" id="dataRow" name="dataRow" value="<?=$i?>">

                        <!-- 주문자 정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">주문자 정보</div>
                            
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">주문자</label>
                                    <input id="orderer_name2" type="text" name="buyername" value="<?=$userinfo->member_name?>" aria-describedby="orderer_name" required/>
                                    <input id="member_code" type="hidden" name="member_code" value="<?=$userinfo->member_code?>"/>
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">이메일</label>
                                    <input id="orderer_email" type="email" name="buyeremail" value="<?=$userinfo->member_email?>"  aria-describedby="orderer_email" required/>
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">주문자 휴대폰 <span class="col-red">*</span></label>
                                    <input id="orderer_phone2" type="text" name="buyertel" value="<?=$userinfo->member_phone?>" aria-describedby="orderer_phone" required/>
                                </div>                
                            </div>
                        </div>
                        <!-- 주문자 정보 e -->
                        <input type="hidden" name="price" value="<?php echo $all_order_total ?>">

                        <!-- 배송지 정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">배송지 정보
                            <label class="input-container ml-1">주문자정보 동일
                                    <input type="checkbox" id="agree2" onclick="ShipToBill2(this.form);"/>
                                    <span class="checkmark"></span>
                                </label>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분 <span class="col-red">*</span></label>
                                    <input id="shipping_name2" type="text" name="shipping_name"  value="<?=$userinfo->member_name?>" aria-describedby="shipping_name" required/>
                                </div>                
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분 휴대폰 <span class="col-red">*</span></label>
                                    <input id="shipping_phone2" type="text" name="shipping_phone" value="<?=$userinfo->member_phone?>" aria-describedby="shipping_phone" required/>
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">받는분 전화 <span class="col-red">*</span></label>
                                    <input id="delivery_phone" type="text" name="delivery_phone" value="<?=$usersubinfo->com_phone?>" aria-describedby="delivery_phone"/>
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">회사명</label>
                                    <input id="company_name" type="text" name="company_name" value="<?=$usersubinfo->com_name?>" placeholder="회사(학교)명을 입력하세요.">
                                </div>
                            </div>
                            <?php
                            if ($usersubinfo->com_zipcode) {
                                $user_zipcode = $usersubinfo->com_zipcode;
                            } else {
                                $user_zipcode = $userinfo->member_zipcode;
                            }
                            if ($usersubinfo->com_address1) {
                                $user_address1 = $usersubinfo->com_address1;
                            } else {
                                $user_address1 = $userinfo->member_address1;
                            }
                            if ($usersubinfo->com_address2) {
                                $user_address2 = $usersubinfo->com_address2;
                            } else {
                                $user_address2 = $userinfo->member_address2;
                            }
                            ?>

                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">우편번호</label>
                                    <div class="group-btn d-flex">
                                    <input id="shipping_zipocode2" type="text" name="shipping_zipocode" value="<?=$user_zipcode?>" placeholder="우편번호">
                                    <input type="button" onclick="execDaumPostcode2()" value="우편번호 찾기" class="btn btn-gray ml-1">
                                    </div>
                                </div>
                                <div class="d-flex g-2"> </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송지</label>
                                    <input id="shipping_add21" type="text" name="shipping_add1" value="<?=$user_address1?>" placeholder="주소" required>
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송지</label>
                                    <input id="shipping_add22" type="text" name="shipping_add2" value="<?=$user_address2?>" placeholder="상세주소">
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송메시지 </label>
                                    <input id="shipping_message" type="text" name="shipping_message"  placeholder="배송메시지를 입력하세요.">
                                </div>
                            </div>
                        </div>
                        <!-- 배송지 정보 e -->

                        <input type="hidden" name="payment_flg" value="Directbank">

                        <!-- 계산서 발행 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">계산서(현금영수증) 발행</div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">발행구분</label>
                                    <div class="form-check g-2">
                                        <input class="form-check-input" name="invoice_type" type="radio" value="1" checked id="person">
                                        <label class="form-check-label">계산서</label>
                                    </div>
                                    <div class="form-check g-2">
                                        <input class="form-check-input" name="invoice_type" type="radio" value="2" id="company">
                                        <label class="form-check-label">현금영수증</label>
                                    </div>
                                </div>
                                <div class="d-flex g-2"> </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">회사명</label>
                                    <input id="invoice_com" type="text" name="invoice_com" placeholder="회사명">
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">사업자번호</label>
                                    <input id="invoice_biznum" type="text" name="invoice_biznum" placeholder="사업자번호">
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">대표자명</label>
                                    <input id="invoice_ceo" type="text" name="invoice_ceo" placeholder="대표자명">
                                </div>
                            </div>
                        </div>
                        <!-- 계산서 발행 e -->

                <div class="order-btn-box btn-box">
                        <!--button class="btn font-xsm btn-outline-white float-l">거래 명세서 출력하기</button-->            
                        <!--button class="btn font-xsm btn-outline-white float-r ml-1">목록으로</button-->
                        <!--button class="btn font-xsm btn-outline-white float-r">수정하기</button-->                
                </div>

                <div class="order-btn-box mt-3 mb-2"> </div>
                <div class="order-btn-box btn-lg-box btn-box align-c">
                    <a href="<?=route_guest('cart')?>" class="btn btn-lg btn-outline-white" style="width:47%;">장바구니로</a>
                    <button onclick="paybtn()" type="submit" class="btn btn-lg btn-blue ml-1" style="width:47%;">다음</button>
                </div>
            </form>

            <!-- 탭 정보2 e -->
            </div>

            <!-- 무통장 입금 -->
            <div id="tab03" class="order_cnt3">
                <!-- 탭 정보3 s -->


                <form id="SendPayForm_id" name="user_form" method="post" action="<?=route_guest('cart.transfer')?>">
                <?php $order_code = "ORD_TRA_".date(time()); ?>
                <input type="hidden" id="order_code" name="order_code" value="<?=$order_code?>"/>
                <!-- 주문 상품정보 s -->
                <div class="border-light-box">
                    <div class="sub_title">주문 상품정보</div>
                    <table class="table_style2 order_list">
                        <thead>
                            <tr>
                                <th>이미지</th>
                                <th>주문상품</th>
                                <th>단가</th>
                                <th>주문수량</th>
                                <th>공급가액</th>
                                <th>VAT</th>
                                <th>금액</th>
                            </tr>
                        </thead>
                        
                        <?php 
                        $all_amount_price = 0;
                        $all_price_vat = 0;
                        $delivery_prices = 0;
                        $all_order_total = 0;
                        $i = 1; 
                        $deliverydays = 0;

                        foreach ($lists as $key => $item) {

                            $item_price = $item->price;
                            $amount_price = $item_price * $item->qty;
                            $price_vat = $amount_price*0.1;
                            $total_price = $amount_price+$price_vat;
                        ?>
                            <tr>
                                <td><p class="prd-img">
                                    <?php if(isset($item->nowinfo['image_dir']) && $item->nowinfo['image_dir'] != ''): ?>
                                <?php if(isset($item->nowinfo['api_flg']) && $item->nowinfo['api_flg'] == '1'): ?>
                                    <img src="<?=$item->nowinfo['image_dir']?>"/>
                                <?php else : ?>
                                    <img src="<?=asset_public($item->nowinfo['image_dir'])?>"/>
                                <?php endif; ?>
                                <?php else : ?>
                                    <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                                <?php endif; ?>
                                </p></td>
                                <td>
                                    <p><label class="badge_blue font-sm">
                                        <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                            <?php if($stock_location->location_id == $item->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                        <?php endforeach; ?>
                                    </label></p>
                                    <p class="col-blue font-sm"><?=$item->name?></p>
                                    <p class="prd-subject"><?=$item->nowinfo['part_number']?></p>
                                    <input type="hidden" name="inquiry_id<?=$i?>" value="<?=$item->inquiry_id?>"/>
                                    <?php $inquiry_id_all = $inquiry_id_all.$item->inquiry_id.","; ?>
                                    <p class="prd-cmt col-gray font-sm"><?=$item->nowinfo['product_code']?></p>
                                    <p class="prd-option col-gray font-sm">
                                        <?php
                                        $brief_description = $item->nowinfo['brief_description'];
                                        $prd_description = explode('|^|', $brief_description);

                                        echo mb_strimwidth($prd_description[1],'0',40,'...','utf-8');
                                        ?>
                                    </p>
                                </td>
                                <td><?=number_format($item_price)?>원</td>
                                <input type="hidden" name="price<?=$i?>" value="<?=$item_price?>"/>
                                <td><?php echo $item->qty;?></td>
                                <input type="hidden" name="qty<?=$i?>" value="<?=$item->qty?>"/>
                                <td><?=number_format($amount_price)?>원</td>
                                <input type="hidden" name="supply_price<?=$i?>" value="<?=$amount_price?>"/>
                                <td><?=number_format($price_vat)?>원</td>
                                <input type="hidden" name="vat<?=$i?>" value="<?=$price_vat?>"/>
                                <td><?=number_format($total_price)?>원</td>
                                <input type="hidden" name="amount<?=$i?>" value="<?=$total_price?>"/>
                            </tr>
                    
                            <?php 
                            if ($i > 1) {
                                $inistgoodname = $item->nowinfo['product_code']." 외 ".count($lists)."개 품목";
                            } else {
                                $inistgoodname = $item->nowinfo['product_code'];
                            }

                            if ($deliverydays > $item->leadtime_info) {
                                $deliverydays = $deliverydays;
                            } else {
                                $deliverydays = $item->leadtime_info;
                            }

                            if ($delivery_prices > $item->delivery_price) {
                                $delivery_prices = $delivery_prices;
                            } else {
                                $delivery_prices = $item->delivery_price;
                            }

                                $all_amount_price = $all_amount_price + $amount_price;
                                $all_price_vat = $all_price_vat + $price_vat;
                                $i++; 
                        }

                            $delivery_free_standard = 30000; // 배송료무료 기준설정

                            if ($all_amount_price > $delivery_free_standard) {
                                $delivery_prices = 0;
                            }
                            
                            $all_order_total = 0;
                            $all_order_total = $all_amount_price + $all_price_vat + $delivery_prices;
                            $deliverytime = strtotime($deliverydays."days");

                            $del_han = $lists[0]->part_number;
                            $firstitem_number = preg_replace("/([^a-zA-Z0-9_\-+])/", "", $del_han); // 영/숫자/지정기호 이외 제거
                            ?>
                        </tbody>
                    </table>

                    
                    <dl class="order_list_mobile">
                        <dt>
                            <?php
                            $i = 1; 
                            $deliverydays = 0;
                            foreach($lists as $item_mobile){
                            ?>
                            <div class="prd-img">
                                <?php if(isset($item_mobile->nowinfo['image_dir']) && $item_mobile->nowinfo['image_dir'] != ''): ?>
                                    <?php if(isset($item_mobile->nowinfo['api_flg']) && $item_mobile->nowinfo['api_flg'] == '1'): ?>
                                        <img src="<?=$item_mobile->nowinfo['image_dir']?>"/>
                                    <?php else : ?>
                                        <img src="<?=asset_public($item_mobile->nowinfo['image_dir'])?>"/>
                                    <?php endif; ?>
                                <?php else : ?>
                                    <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                                <?php endif; ?>
                            </div>

                            <div class="prd-info">
                                <p><label class="badge_blue font-sm">
                                    <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                        <?php if($stock_location->location_id == $item_mobile->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                    <?php endforeach; ?>
                                </label></p>                     
                                <p class="col-blue font-sm"><?=$item_mobile->name;?></p>
                                <p class="prd-subject"><?=$item_mobile->part_number;?></p>
                                <p class="prd-cmt col-gray font-sm"><?=$item_mobile->nowinfo['product_code']?></p>
                                <p class="prd-option col-gray font-sm">
                                        <?php
                                        $brief_description = $item_mobile->nowinfo['brief_description'];
                                        $prd_description = explode('|^|', $brief_description);
                                        echo mb_strimwidth($prd_description[1],'0',30,'...','utf-8');
                                        ?>
                                </p>
                                <p class="prd-subject">단가 : <?=number_format($item_price)?>원</p>
                                <p class="prd-subject">수량 : <?php echo $item->qty;?></p>
                            </div>
                            <?php 
                                $i++; 
                            } 
                            ?>
                        </dt>
                        <dd class="bg-light-gray border-b">
                            <ul>
                                <li>공급가액</li> <li><?=number_format($all_amount_price)?>원</li>
                                <li>VAT</li> <li><?=number_format($all_price_vat)?>원</li>
                                <li>배송비</li> <li><?=number_format($delivery_prices)?></li>
                                <li>총금액</li> <li><?=number_format($all_order_total)?>원</li>
                            </ul>
                        </dd>
                    </dl>

                    <table class="table_style2 order_list_footer">
                        <thead>
                            <tr>
                                <th>공급가액</th>
                                <th>부가세(VAT)</th>
                                <th>배송비</th>
                                <th>총 결제 금액(VAT포함)</th>                        
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><?=number_format($all_amount_price)?>원</td>
                                <td><?=number_format($all_price_vat)?>원</td>
                                <td><?=number_format($delivery_prices)?>원</td>
                                <td><?=number_format($all_order_total)?>원</td>                        
                            </tr>                    
                        </tbody>
                    </table>
                </div>

                <input type="hidden" id="supply_price" name="supply_price" value="<?=$all_amount_price?>"/>
                <input type="hidden" id="vat" name="vat" value="<?=$all_price_vat?>"/>
                <input type="hidden" id="delivery_fee" name="delivery_fee" value="<?=$delivery_prices?>"/>
                <input type="hidden" id="amount_total" name="amount_total" value="<?=round($all_order_total)?>"/>

                <!-- 주문 상품정보 e -->
                <input type="hidden" id="inquiry_code" name="inquiry_code" value="<?=$lists[0]->inquiry_code?>">
                <input type="hidden" id="firstitem_number" name="firstitem_number" value="<?=$firstitem_number?>">
                <input type="hidden" id="item_counts" name="item_counts" value="<?=count($lists)?>">
                <input type="hidden" id="dataRow" name="dataRow" value="<?=$i?>">

                <input type="hidden" id="delivery_date" name="delivery_date" value="<?php echo  date("Y-m-d", $deliverytime);?>">

                <input type="hidden" id="firstitem_code" name="firstitem_code" value="<?=$lists[0]->part_sequence?>">
                <input type="hidden" id="firstitem_number" name="firstitem_number" value="<?=$lists[0]->part_number?>">
                <input type="hidden" id="firstitem_image" name="firstitem_image" value="<?=$lists[0]->nowinfo['image_dir']?>">
                <input type="hidden" id="item_counts" name="item_counts" value="<?=count($lists)?>">

                        <!-- 주문자 정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">주문자 정보</div>
                            
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">주문자</label>
                                    <input id="orderer_name3" type="text" name="buyername" value="<?=$userinfo->member_name?>" aria-describedby="orderer_name" required/>
                                    <input id="member_code" type="hidden" name="member_code" value="<?=$userinfo->member_code?>"/>
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">이메일</label>
                                    <input id="orderer_email" type="email" name="buyeremail" value="<?=$userinfo->member_email?>"  aria-describedby="orderer_email" required/>
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">주문자 휴대폰 <span class="col-red">*</span></label>
                                    <input id="orderer_phone3" type="text" name="buyertel" value="<?=$userinfo->member_phone?>" aria-describedby="orderer_phone" required/>
                                </div>                
                            </div>
                        </div>
                        <!-- 주문자 정보 e -->
                        <input type="hidden" name="price" value="<?php echo $all_order_total ?>">

                        <!-- 배송지 정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">배송지 정보
                            <label class="input-container ml-1">주문자정보 동일
                                    <input type="checkbox" id="agree3" onclick="ShipToBill3(this.form);"/>
                                    <span class="checkmark"></span>
                                </label>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분 <span class="col-red">*</span></label>
                                    <input id="shipping_name3" type="text" name="shipping_name"  value="<?=$userinfo->member_name?>" aria-describedby="shipping_name" required/>
                                </div>                
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분 휴대폰 <span class="col-red">*</span></label>
                                    <input id="shipping_phone3" type="text" name="shipping_phone" value="<?=$userinfo->member_phone?>" aria-describedby="shipping_phone" required/>
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">받는분 전화 <span class="col-red">*</span></label>
                                    <input id="delivery_phone" type="text" name="delivery_phone" value="<?=$usersubinfo->com_phone?>" aria-describedby="delivery_phone"/>
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">회사명</label>
                                    <input id="company_name" type="text" name="company_name" value="<?=$usersubinfo->com_name?>" placeholder="회사(학교)명을 입력하세요.">
                                </div>
                            </div>
                            <?php
                            if ($usersubinfo->com_zipcode) {
                                $user_zipcode = $usersubinfo->com_zipcode;
                            } else {
                                $user_zipcode = $userinfo->member_zipcode;
                            }
                            if ($usersubinfo->com_address1) {
                                $user_address1 = $usersubinfo->com_address1;
                            } else {
                                $user_address1 = $userinfo->member_address1;
                            }
                            if ($usersubinfo->com_address2) {
                                $user_address2 = $usersubinfo->com_address2;
                            } else {
                                $user_address2 = $userinfo->member_address2;
                            }
                            ?>

                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">우편번호</label>
                                    <div class="group-btn d-flex">
                                    <input id="shipping_zipocode3" type="text" name="shipping_zipocode" value="<?=$user_zipcode?>" placeholder="우편번호">
                                    <input type="button" onclick="execDaumPostcode3()" value="우편번호 찾기" class="btn btn-gray ml-1">
                                    </div>
                                </div>
                                <div class="d-flex g-2"> </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송지</label>
                                    <input id="shipping_add31" type="text" name="shipping_add1" value="<?=$user_address1?>" placeholder="주소" required>
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송지</label>
                                    <input id="shipping_add32" type="text" name="shipping_add2" value="<?=$user_address2?>" placeholder="상세주소">
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송메시지 </label>
                                    <input id="shipping_message" type="text" name="shipping_message"  placeholder="배송메시지를 입력하세요.">
                                </div>
                            </div>
                        </div>


                        <!-- 결제정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">결제정보</div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">결제계좌</label>
                                    은행명 : 하나은행
                                    계좌번호 : 138-910044-11204
                                    예금주 : 주식회사셀파세미컴
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">입금자<span class="col-red">*</span></label>
                                    <input id="deposit_name" type="text" name="deposit_name" placeholder="입금자를 입력하세요.">
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">입금예정일<span class="col-red">*</span></label>
                                    <input id="deposit_date" type="text" name="deposit_date" placeholder="예) 2025-01-01"/>
                                </div>
                            </div>
                        </div>
                        <!-- 결제정보 e -->
                        <input type="hidden" name="payment_flg" value="Tran">

                        <!-- 계산서 발행 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">계산서(현금영수증) 발행</div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">발행구분</label>
                                    <div class="form-check g-2">
                                        <input class="form-check-input" name="invoice_type" type="radio" value="1" checked id="person">
                                        <label class="form-check-label">계산서</label>
                                    </div>
                                    <div class="form-check g-2">
                                        <input class="form-check-input" name="invoice_type" type="radio" value="2" id="company">
                                        <label class="form-check-label">현금영수증</label>
                                    </div>
                                </div>
                                <div class="d-flex g-2"> </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">회사명</label>
                                    <input id="invoice_com" type="text" name="invoice_com" placeholder="회사명">
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">사업자번호</label>
                                    <input id="invoice_biznum" type="text" name="invoice_biznum" placeholder="사업자번호">
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">대표자명</label>
                                    <input id="invoice_ceo" type="text" name="invoice_ceo" placeholder="대표자명">
                                </div>
                            </div>
                        </div>
                        <!-- 계산서 발행 e -->

                <div class="order-btn-box btn-box">
                        <!--button class="btn font-xsm btn-outline-white float-l">거래 명세서 출력하기</button-->            
                        <!--button class="btn font-xsm btn-outline-white float-r ml-1">목록으로</button-->
                        <!--button class="btn font-xsm btn-outline-white float-r">수정하기</button-->                
                </div>

                <div class="order-btn-box mt-3 mb-2"> </div>
                <div class="order-btn-box btn-lg-box btn-box align-c">
                    <a href="<?=route_guest('cart')?>" class="btn btn-lg btn-outline-white" style="width:47%;">장바구니로</a>
                    <button onclick="paybtn()" type="submit" class="btn btn-lg btn-blue ml-1" style="width:47%;">다음</button>
                </div>
            </form>
            <!-- 탭 정보3 e -->
            </div>
        </div>

</div>
</section>
    <!-- product details top info e -->
    <!------------------------------------------------------------------------------------------------------------------->
    <?php endif;?>

<!-- 회원인증 주문서작성 끝 -->
<?php else: ?>

    <?php if($nonmember == "YES"):?>
    <!-- 비회원 주문서작성 시작 -->
        <!------------------------------------------------------------------------------------------------------------------->

    <?php if (!$lists) :?>
        <div class="order_List mb40">
            <p class="mb-0"><?=lang_common('toitem_msg1')?><a href="<?=route_guest('home')?>"><?=lang_common('toitem_msg2')?></a><?=lang_common('toitem_msg3')?></p>
        </div>
    <?php else: ?>
        <!------------------------------------------------------------------------------------------------------------------->
        <!-- product details top info s -->
<section class="sub_wrap">
<div class="content_wrap">

                <div class="d-flex">
                    <div class="row align-l">
                        <h2 class="mb-0 pb-0">주문/결제</h2>
                        <p class="font-xsm col-gray">주문/결제 정보를 정확히 입력해 주세요.</p>
                    </div>
                </div>

                <div class="cart_flow mb-2">
                    <div class="flow cartFlow_1second">01 장바구니</div>
                    <div class="flow cartFlow_2second">02 주문/결제</div>
                    <div class="flow cartFlow_3second">03 주문완료</div>
                </div>
                
                <!-- 결제수단 s -->
                <div class="border-light-box">
                    <div class="sub_title mb-1">결제수단</div>

                    <ul class="tabnav paypay-btn">
                        <li><a href="#tab01">신용카드</a></li>
                        <li><a href="#tab02">실시간 이체</a></li>
                        <li><a href="#tab03">무통장 입금</a></li>
                    </ul>
                </div>
                <!-- 결제수단 e -->

        <div class="tabcontent">
            <div id="tab01" class="order_cnt1">
            <!-- 탭 정보1 s -->

            <form id="SendPayForm_id" name="user_form" method="post" action="<?=route_guest('cart.inipay')?>">
                <!-- 주문 상품정보 s -->
                <div class="border-light-box">
                    <div class="sub_title">주문 상품정보</div>
                    <table class="table_style2 order_list">
                        <thead>
                            <tr>
                                <th>이미지</th>
                                <th>주문상품</th>
                                <th>단가</th>
                                <th>주문수량</th>
                                <th>공급가액</th>
                                <th>VAT</th>
                                <th>금액</th>
                            </tr>
                        </thead>
                        
                        <?php 
                        $all_amount_price = 0;
                        $all_price_vat = 0;
                        $delivery_prices = 0;
                        $all_order_total = 0;
                        $i = 1; 
                        $deliverydays = 0;

                        foreach ($lists as $key => $item) {

                            $item_price = $item->price;
                            $amount_price = $item_price * $item->qty;
                            $price_vat = $amount_price*0.1;
                            $total_price = $amount_price+$price_vat;
                        ?>
                            <tr>
                                <td><p class="prd-img">
                                    <?php if(isset($item->nowinfo['image_dir']) && $item->nowinfo['image_dir'] != ''): ?>
                                <?php if(isset($item->nowinfo['api_flg']) && $item->nowinfo['api_flg'] == '1'): ?>
                                    <img src="<?=$item->nowinfo['image_dir']?>"/>
                                <?php else : ?>
                                    <img src="<?=asset_public($item->nowinfo['image_dir'])?>"/>
                                <?php endif; ?>
                                <?php else : ?>
                                    <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                                <?php endif; ?>
                                </p></td>
                                <td>
                                    <p><label class="badge_blue font-sm">
                                        <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                            <?php if($stock_location->location_id == $item->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                        <?php endforeach; ?>
                                    </label></p>
                                    <p class="col-blue font-sm"><?=$item->name?></p>
                                    <p class="prd-subject"><?=$item->nowinfo['part_number']?></p>
                                    <input type="hidden" name="inquiry_id<?=$i?>" value="<?=$item->inquiry_id?>"/>
                                    <?php $inquiry_id_all = $inquiry_id_all.$item->inquiry_id.","; ?>
                                    <p class="prd-cmt col-gray font-sm"><?=$item->nowinfo['product_code']?></p>
                                    <p class="prd-option col-gray font-sm">
                                        <?php
                                        $brief_description = $item->nowinfo['brief_description'];
                                        $prd_description = explode('|^|', $brief_description);

                                        echo mb_strimwidth($prd_description[1],'0',40,'...','utf-8');
                                        ?>
                                    </p>
                                </td>
                                <td><?=number_format($item_price)?>원</td>
                                <input type="hidden" name="price<?=$i?>" value="<?=$item_price?>"/>
                                <td><?php echo $item->qty;?></td>
                                <input type="hidden" name="qty<?=$i?>" value="<?=$item->qty?>"/>
                                <td><?=number_format($amount_price)?>원</td>
                                <input type="hidden" name="supply_price<?=$i?>" value="<?=$amount_price?>"/>
                                <td><?=number_format($price_vat)?>원</td>
                                <input type="hidden" name="vat<?=$i?>" value="<?=$price_vat?>"/>
                                <td><?=number_format($total_price)?>원</td>
                                <input type="hidden" name="amount<?=$i?>" value="<?=$total_price?>"/>
                            </tr>
                    
                            <?php 
                            if ($i > 1) {
                                $inistgoodname = $item->nowinfo['product_code']." 외 ".count($lists)."개 품목";
                            } else {
                                $inistgoodname = $item->nowinfo['product_code'];
                            }

                            if ($deliverydays > $item->leadtime_info) {
                                $deliverydays = $deliverydays;
                            } else {
                                $deliverydays = $item->leadtime_info;
                            }

                            if ($delivery_prices > $item->delivery_price) {
                                $delivery_prices = $delivery_prices;
                            } else {
                                $delivery_prices = $item->delivery_price;
                            }

                                $all_amount_price = $all_amount_price + $amount_price;
                                $all_price_vat = $all_price_vat + $price_vat;
                                $i++; 
                        }

                            $delivery_free_standard = 30000; // 배송료무료 기준설정

                            if ($all_amount_price > $delivery_free_standard) {
                                $delivery_prices = 0;
                            }
                            
                            $all_order_total = 0;
                            $all_order_total = $all_amount_price + $all_price_vat + $delivery_prices;
                            $deliverytime = strtotime($deliverydays."days");

                            $del_han = $lists[0]->part_number;
                            $firstitem_number = preg_replace("/([^a-zA-Z0-9_\-+])/", "", $del_han); // 영/숫자/지정기호 이외 제거
                            ?>
                        </tbody>
                    </table>

                    
                    <dl class="order_list_mobile">
                        <dt>
                            <?php
                            $i = 1; 
                            $deliverydays = 0;
                            foreach($lists as $item_mobile){
                            ?>
                            <div class="prd-img">
                                <?php if(isset($item_mobile->nowinfo['image_dir']) && $item_mobile->nowinfo['image_dir'] != ''): ?>
                                    <?php if(isset($item_mobile->nowinfo['api_flg']) && $item_mobile->nowinfo['api_flg'] == '1'): ?>
                                        <img src="<?=$item_mobile->nowinfo['image_dir']?>"/>
                                    <?php else : ?>
                                        <img src="<?=asset_public($item_mobile->nowinfo['image_dir'])?>"/>
                                    <?php endif; ?>
                                <?php else : ?>
                                    <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                                <?php endif; ?>
                            </div>

                            <div class="prd-info">
                                <p><label class="badge_blue font-sm">
                                    <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                        <?php if($stock_location->location_id == $item_mobile->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                    <?php endforeach; ?>
                                </label></p>                     
                                <p class="col-blue font-sm"><?=$item_mobile->name;?></p>
                                <p class="prd-subject"><?=$item_mobile->part_number;?></p>
                                <p class="prd-cmt col-gray font-sm"><?=$item_mobile->nowinfo['product_code']?></p>
                                <p class="prd-option col-gray font-sm">
                                        <?php
                                        $brief_description = $item_mobile->nowinfo['brief_description'];
                                        $prd_description = explode('|^|', $brief_description);
                                        echo mb_strimwidth($prd_description[1],'0',30,'...','utf-8');
                                        ?>
                                </p>
                                <p class="prd-subject">단가 : <?=number_format($item_price)?>원</p>
                                <p class="prd-subject">수량 : <?php echo $item->qty;?></p>
                            </div>
                            <?php 
                                $i++; 
                            } 
                            ?>
                        </dt>
                        <dd class="bg-light-gray border-b">
                            <ul>
                                <li>공급가액</li> <li><?=number_format($all_amount_price)?>원</li>
                                <li>VAT</li> <li><?=number_format($all_price_vat)?>원</li>
                                <li>배송비</li> <li><?=number_format($delivery_prices)?></li>
                                <li>총금액</li> <li><?=number_format($all_order_total)?>원</li>
                            </ul>
                        </dd>
                    </dl>

                    <table class="table_style2 order_list_footer">
                        <thead>
                            <tr>
                                <th>공급가액</th>
                                <th>부가세(VAT)</th>
                                <th>배송비</th>
                                <th>총 결제 금액(VAT포함)</th>                        
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><?=number_format($all_amount_price)?>원</td>
                                <td><?=number_format($all_price_vat)?>원</td>
                                <td><?=number_format($delivery_prices)?>원</td>
                                <td><?=number_format($all_order_total)?>원</td>                        
                            </tr>                    
                        </tbody>
                    </table>
                </div>

                <input type="hidden" id="supply_price" name="supply_price" value="<?=$all_amount_price?>"/>
                <input type="hidden" id="vat" name="vat" value="<?=$all_price_vat?>"/>
                <input type="hidden" id="delivery_fee" name="delivery_fee" value="<?=$delivery_prices?>"/>
                <input type="hidden" id="amount_total" name="amount_total" value="<?=round($all_order_total)?>"/>

                <!-- 주문 상품정보 e -->
                <input type="hidden" id="inquiry_code" name="inquiry_code" value="<?=$lists[0]->inquiry_code?>">
                <input type="hidden" id="firstitem_number" name="firstitem_number" value="<?=$firstitem_number?>">
                <input type="hidden" id="item_counts" name="item_counts" value="<?=count($lists)?>">
                <input type="hidden" id="dataRow" name="dataRow" value="<?=$i?>">

                        <!-- 주문자 정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">주문자 정보</div>
                            
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">주문자</label>
                                    <input id="orderer_name4" type="text" name="buyername" value="<?=$userinfo->member_name?>" aria-describedby="orderer_name" required/>
                                    <input id="member_code" type="hidden" name="member_code" value="<?=$userinfo->member_code?>"/>
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">이메일</label>
                                    <input id="orderer_email" type="email" name="buyeremail" value="<?=$userinfo->member_email?>"  aria-describedby="orderer_email" required/>
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">주문자 휴대폰 <span class="col-red">*</span></label>
                                    <input id="orderer_phone4" type="text" name="buyertel" value="<?=$userinfo->member_phone?>" aria-describedby="orderer_phone" required/>
                                </div>                
                            </div>
                        </div>
                        <!-- 주문자 정보 e -->
                        <input type="hidden" name="price" value="<?php echo $all_order_total ?>">

                        <!-- 배송지 정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">배송지 정보
                            <label class="input-container ml-1">주문자정보 동일
                                    <input type="checkbox" id="agree4" onclick="ShipToBill4(this.form);"/>
                                    <span class="checkmark"></span>
                                </label>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분 <span class="col-red">*</span></label>
                                    <input id="shipping_name4" type="text" name="shipping_name"  value="<?=$userinfo->member_name?>" aria-describedby="shipping_name" required/>
                                </div>                
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분 휴대폰 <span class="col-red">*</span></label>
                                    <input id="shipping_phone4" type="text" name="shipping_phone" value="<?=$userinfo->member_phone?>" aria-describedby="shipping_phone" required/>
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">받는분 전화 <span class="col-red">*</span></label>
                                    <input id="delivery_phone" type="text" name="delivery_phone" value="<?=$usersubinfo->com_phone?>" aria-describedby="delivery_phone"/>
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">회사명</label>
                                    <input id="company_name" type="text" name="company_name" value="<?=$usersubinfo->com_name?>" placeholder="회사(학교)명을 입력하세요.">
                                </div>
                            </div>
                            <?php
                            if ($usersubinfo->com_zipcode) {
                                $user_zipcode = $usersubinfo->com_zipcode;
                            } else {
                                $user_zipcode = $userinfo->member_zipcode;
                            }
                            if ($usersubinfo->com_address1) {
                                $user_address1 = $usersubinfo->com_address1;
                            } else {
                                $user_address1 = $userinfo->member_address1;
                            }
                            if ($usersubinfo->com_address2) {
                                $user_address2 = $usersubinfo->com_address2;
                            } else {
                                $user_address2 = $userinfo->member_address2;
                            }
                            ?>

                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">우편번호</label>
                                    <div class="group-btn d-flex">
                                    <input id="shipping_zipocode4" type="text" name="shipping_zipocode" value="<?=$user_zipcode?>" placeholder="우편번호">
                                    <input type="button" onclick="execDaumPostcode4()" value="우편번호 찾기" class="btn btn-gray ml-1">
                                    </div>
                                </div>
                                <div class="d-flex g-2"> </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송지</label>
                                    <input id="shipping_add41" type="text" name="shipping_add1" value="<?=$user_address1?>" placeholder="주소" required>
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송지</label>
                                    <input id="shipping_add42" type="text" name="shipping_add2" value="<?=$user_address2?>" placeholder="상세주소">
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송메시지 </label>
                                    <input id="shipping_message" type="text" name="shipping_message"  placeholder="배송메시지를 입력하세요.">
                                </div>
                            </div>
                        </div>
                        <!-- 배송지 정보 e -->
                        <input type="hidden" name="payment_flg" value="Card">

                <div class="order-btn-box btn-box">
                        <!--button class="btn font-xsm btn-outline-white float-l">거래 명세서 출력하기</button-->            
                        <!--button class="btn font-xsm btn-outline-white float-r ml-1">목록으로</button-->
                        <!--button class="btn font-xsm btn-outline-white float-r">수정하기</button-->                
                </div>

                <div class="order-btn-box mt-3 mb-2"> </div>
                <div class="order-btn-box btn-lg-box btn-box align-c">
                    <a href="<?=route_guest('cart')?>" class="btn btn-lg btn-outline-white" style="width:47%;">장바구니로</a>
                    <button onclick="paybtn()" type="submit" class="btn btn-lg btn-blue ml-1" style="width:47%;">다음</button>
                </div>
            </form>

            <!-- 탭 정보1 e -->
            </div>

            <!-- 실시간 이체 -->
            <div id="tab02" class="order_cnt2">
            <!-- 탭 정보2 s -->

            <form id="SendPayForm_id" name="user_form" method="post" action="<?=route_guest('cart.inipay')?>">
                <!-- 주문 상품정보 s -->
                <div class="border-light-box">
                    <div class="sub_title">주문 상품정보</div>
                    <table class="table_style2 order_list">
                        <thead>
                            <tr>
                                <th>이미지</th>
                                <th>주문상품</th>
                                <th>단가</th>
                                <th>주문수량</th>
                                <th>공급가액</th>
                                <th>VAT</th>
                                <th>금액</th>
                            </tr>
                        </thead>
                        
                        <?php 
                        $all_amount_price = 0;
                        $all_price_vat = 0;
                        $delivery_prices = 0;
                        $all_order_total = 0;
                        $i = 1; 
                        $deliverydays = 0;

                        foreach ($lists as $key => $item) {

                            $item_price = $item->price;
                            $amount_price = $item_price * $item->qty;
                            $price_vat = $amount_price*0.1;
                            $total_price = $amount_price+$price_vat;
                        ?>
                            <tr>
                                <td><p class="prd-img">
                                    <?php if(isset($item->nowinfo['image_dir']) && $item->nowinfo['image_dir'] != ''): ?>
                                <?php if(isset($item->nowinfo['api_flg']) && $item->nowinfo['api_flg'] == '1'): ?>
                                    <img src="<?=$item->nowinfo['image_dir']?>"/>
                                <?php else : ?>
                                    <img src="<?=asset_public($item->nowinfo['image_dir'])?>"/>
                                <?php endif; ?>
                                <?php else : ?>
                                    <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                                <?php endif; ?>
                                </p></td>
                                <td>
                                    <p><label class="badge_blue font-sm">
                                        <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                            <?php if($stock_location->location_id == $item->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                        <?php endforeach; ?>
                                    </label></p>
                                    <p class="col-blue font-sm"><?=$item->name?></p>
                                    <p class="prd-subject"><?=$item->nowinfo['part_number']?></p>
                                    <input type="hidden" name="inquiry_id<?=$i?>" value="<?=$item->inquiry_id?>"/>
                                    <?php $inquiry_id_all = $inquiry_id_all.$item->inquiry_id.","; ?>
                                    <p class="prd-cmt col-gray font-sm"><?=$item->nowinfo['product_code']?></p>
                                    <p class="prd-option col-gray font-sm">
                                        <?php
                                        $brief_description = $item->nowinfo['brief_description'];
                                        $prd_description = explode('|^|', $brief_description);

                                        echo mb_strimwidth($prd_description[1],'0',40,'...','utf-8');
                                        ?>
                                    </p>
                                </td>
                                <td><?=number_format($item_price)?>원</td>
                                <input type="hidden" name="price<?=$i?>" value="<?=$item_price?>"/>
                                <td><?php echo $item->qty;?></td>
                                <input type="hidden" name="qty<?=$i?>" value="<?=$item->qty?>"/>
                                <td><?=number_format($amount_price)?>원</td>
                                <input type="hidden" name="supply_price<?=$i?>" value="<?=$amount_price?>"/>
                                <td><?=number_format($price_vat)?>원</td>
                                <input type="hidden" name="vat<?=$i?>" value="<?=$price_vat?>"/>
                                <td><?=number_format($total_price)?>원</td>
                                <input type="hidden" name="amount<?=$i?>" value="<?=$total_price?>"/>
                            </tr>
                    
                            <?php 
                            if ($i > 1) {
                                $inistgoodname = $item->nowinfo['product_code']." 외 ".count($lists)."개 품목";
                            } else {
                                $inistgoodname = $item->nowinfo['product_code'];
                            }

                            if ($deliverydays > $item->leadtime_info) {
                                $deliverydays = $deliverydays;
                            } else {
                                $deliverydays = $item->leadtime_info;
                            }

                            if ($delivery_prices > $item->delivery_price) {
                                $delivery_prices = $delivery_prices;
                            } else {
                                $delivery_prices = $item->delivery_price;
                            }

                                $all_amount_price = $all_amount_price + $amount_price;
                                $all_price_vat = $all_price_vat + $price_vat;
                                $i++; 
                        }

                            $delivery_free_standard = 30000; // 배송료무료 기준설정

                            if ($all_amount_price > $delivery_free_standard) {
                                $delivery_prices = 0;
                            }
                            
                            $all_order_total = 0;
                            $all_order_total = $all_amount_price + $all_price_vat + $delivery_prices;
                            $deliverytime = strtotime($deliverydays."days");

                            $del_han = $lists[0]->part_number;
                            $firstitem_number = preg_replace("/([^a-zA-Z0-9_\-+])/", "", $del_han); // 영/숫자/지정기호 이외 제거
                            ?>
                        </tbody>
                    </table>

                    
                    <dl class="order_list_mobile">
                        <dt>
                            <?php
                            $i = 1; 
                            $deliverydays = 0;
                            foreach($lists as $item_mobile){
                            ?>
                            <div class="prd-img">
                                <?php if(isset($item_mobile->nowinfo['image_dir']) && $item_mobile->nowinfo['image_dir'] != ''): ?>
                                    <?php if(isset($item_mobile->nowinfo['api_flg']) && $item_mobile->nowinfo['api_flg'] == '1'): ?>
                                        <img src="<?=$item_mobile->nowinfo['image_dir']?>"/>
                                    <?php else : ?>
                                        <img src="<?=asset_public($item_mobile->nowinfo['image_dir'])?>"/>
                                    <?php endif; ?>
                                <?php else : ?>
                                    <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                                <?php endif; ?>
                            </div>

                            <div class="prd-info">
                                <p><label class="badge_blue font-sm">
                                    <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                        <?php if($stock_location->location_id == $item_mobile->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                    <?php endforeach; ?>
                                </label></p>                     
                                <p class="col-blue font-sm"><?=$item_mobile->name;?></p>
                                <p class="prd-subject"><?=$item_mobile->part_number;?></p>
                                <p class="prd-cmt col-gray font-sm"><?=$item_mobile->nowinfo['product_code']?></p>
                                <p class="prd-option col-gray font-sm">
                                        <?php
                                        $brief_description = $item_mobile->nowinfo['brief_description'];
                                        $prd_description = explode('|^|', $brief_description);
                                        echo mb_strimwidth($prd_description[1],'0',30,'...','utf-8');
                                        ?>
                                </p>
                                <p class="prd-subject">단가 : <?=number_format($item_price)?>원</p>
                                <p class="prd-subject">수량 : <?php echo $item->qty;?></p>
                            </div>
                            <?php 
                                $i++; 
                            } 
                            ?>
                        </dt>
                        <dd class="bg-light-gray border-b">
                            <ul>
                                <li>공급가액</li> <li><?=number_format($all_amount_price)?>원</li>
                                <li>VAT</li> <li><?=number_format($all_price_vat)?>원</li>
                                <li>배송비</li> <li><?=number_format($delivery_prices)?></li>
                                <li>총금액</li> <li><?=number_format($all_order_total)?>원</li>
                            </ul>
                        </dd>
                    </dl>

                    <table class="table_style2 order_list_footer">
                        <thead>
                            <tr>
                                <th>공급가액</th>
                                <th>부가세(VAT)</th>
                                <th>배송비</th>
                                <th>총 결제 금액(VAT포함)</th>                        
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><?=number_format($all_amount_price)?>원</td>
                                <td><?=number_format($all_price_vat)?>원</td>
                                <td><?=number_format($delivery_prices)?>원</td>
                                <td><?=number_format($all_order_total)?>원</td>                        
                            </tr>                    
                        </tbody>
                    </table>
                </div>
                
                <input type="hidden" id="supply_price" name="supply_price" value="<?=$all_amount_price?>"/>
                <input type="hidden" id="vat" name="vat" value="<?=$all_price_vat?>"/>
                <input type="hidden" id="delivery_fee" name="delivery_fee" value="<?=$delivery_prices?>"/>
                <input type="hidden" id="amount_total" name="amount_total" value="<?=round($all_order_total)?>"/>

                <!-- 주문 상품정보 e -->
                <input type="hidden" id="inquiry_code" name="inquiry_code" value="<?=$lists[0]->inquiry_code?>">
                <input type="hidden" id="firstitem_number" name="firstitem_number" value="<?=$firstitem_number?>">
                <input type="hidden" id="item_counts" name="item_counts" value="<?=count($lists)?>">
                <input type="hidden" id="dataRow" name="dataRow" value="<?=$i?>">

                        <!-- 주문자 정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">주문자 정보</div>
                            
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">주문자</label>
                                    <input id="orderer_name5" type="text" name="buyername" value="<?=$userinfo->member_name?>" aria-describedby="orderer_name" required/>
                                    <input id="member_code" type="hidden" name="member_code" value="<?=$userinfo->member_code?>"/>
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">이메일</label>
                                    <input id="orderer_email" type="email" name="buyeremail" value="<?=$userinfo->member_email?>"  aria-describedby="orderer_email" required/>
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">주문자 휴대폰 <span class="col-red">*</span></label>
                                    <input id="orderer_phone5" type="text" name="buyertel" value="<?=$userinfo->member_phone?>" aria-describedby="orderer_phone" required/>
                                </div>                
                            </div>
                        </div>
                        <!-- 주문자 정보 e -->
                        <input type="hidden" name="price" value="<?php echo $all_order_total ?>">

                        <!-- 배송지 정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">배송지 정보
                            <label class="input-container ml-1">주문자정보 동일
                                    <input type="checkbox" id="agree5" onclick="ShipToBill5(this.form);"/>
                                    <span class="checkmark"></span>
                                </label>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분 <span class="col-red">*</span></label>
                                    <input id="shipping_name5" type="text" name="shipping_name"  value="<?=$userinfo->member_name?>" aria-describedby="shipping_name" required/>
                                </div>                
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분 휴대폰 <span class="col-red">*</span></label>
                                    <input id="shipping_phone5" type="text" name="shipping_phone" value="<?=$userinfo->member_phone?>" aria-describedby="shipping_phone" required/>
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">받는분 전화 <span class="col-red">*</span></label>
                                    <input id="delivery_phone" type="text" name="delivery_phone" value="<?=$usersubinfo->com_phone?>" aria-describedby="delivery_phone"/>
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">회사명</label>
                                    <input id="company_name" type="text" name="company_name" value="<?=$usersubinfo->com_name?>" placeholder="회사(학교)명을 입력하세요.">
                                </div>
                            </div>
                            <?php
                            if ($usersubinfo->com_zipcode) {
                                $user_zipcode = $usersubinfo->com_zipcode;
                            } else {
                                $user_zipcode = $userinfo->member_zipcode;
                            }
                            if ($usersubinfo->com_address1) {
                                $user_address1 = $usersubinfo->com_address1;
                            } else {
                                $user_address1 = $userinfo->member_address1;
                            }
                            if ($usersubinfo->com_address2) {
                                $user_address2 = $usersubinfo->com_address2;
                            } else {
                                $user_address2 = $userinfo->member_address2;
                            }
                            ?>

                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">우편번호</label>
                                    <div class="group-btn d-flex">
                                    <input id="shipping_zipocode5" type="text" name="shipping_zipocode" value="<?=$user_zipcode?>" placeholder="우편번호">
                                    <input type="button" onclick="execDaumPostcode5()" value="우편번호 찾기" class="btn btn-gray ml-1">
                                    </div>
                                </div>
                                <div class="d-flex g-2"> </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송지</label>
                                    <input id="shipping_add51" type="text" name="shipping_add1" value="<?=$user_address1?>" placeholder="주소" required>
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송지</label>
                                    <input id="shipping_add52" type="text" name="shipping_add2" value="<?=$user_address2?>" placeholder="상세주소">
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송메시지 </label>
                                    <input id="shipping_message" type="text" name="shipping_message"  placeholder="배송메시지를 입력하세요.">
                                </div>
                            </div>
                        </div>
                        <!-- 배송지 정보 e -->

                        <input type="hidden" name="payment_flg" value="Directbank">

                        <!-- 계산서 발행 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">계산서(현금영수증) 발행</div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">발행구분</label>
                                    <div class="form-check g-2">
                                        <input class="form-check-input" name="invoice_type" type="radio" value="1" checked id="person">
                                        <label class="form-check-label">계산서</label>
                                    </div>
                                    <div class="form-check g-2">
                                        <input class="form-check-input" name="invoice_type" type="radio" value="2" id="company">
                                        <label class="form-check-label">현금영수증</label>
                                    </div>
                                </div>
                                <div class="d-flex g-2"> </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">회사명</label>
                                    <input id="invoice_com" type="text" name="invoice_com" placeholder="회사명">
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">사업자번호</label>
                                    <input id="invoice_biznum" type="text" name="invoice_biznum" placeholder="사업자번호">
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">대표자명</label>
                                    <input id="invoice_ceo" type="text" name="invoice_ceo" placeholder="대표자명">
                                </div>
                            </div>
                        </div>
                        <!-- 계산서 발행 e -->

                <div class="order-btn-box btn-box">
                        <!--button class="btn font-xsm btn-outline-white float-l">거래 명세서 출력하기</button-->            
                        <!--button class="btn font-xsm btn-outline-white float-r ml-1">목록으로</button-->
                        <!--button class="btn font-xsm btn-outline-white float-r">수정하기</button-->                
                </div>

                <div class="order-btn-box mt-3 mb-2"> </div>
                <div class="order-btn-box btn-lg-box btn-box align-c">
                    <a href="<?=route_guest('cart')?>" class="btn btn-lg btn-outline-white" style="width:47%;">장바구니로</a>
                    <button onclick="paybtn()" type="submit" class="btn btn-lg btn-blue ml-1" style="width:47%;">다음</button>
                </div>
            </form>

            <!-- 탭 정보2 e -->
            </div>

            <!-- 무통장 입금 -->
            <div id="tab03" class="order_cnt3">
                <!-- 탭 정보3 s -->


                <form id="SendPayForm_id" name="user_form" method="post" action="<?=route_guest('cart.transfer')?>">
                <?php $order_code = "ORD_TRA_".date(time()); ?>
                <input type="hidden" id="order_code" name="order_code" value="<?=$order_code?>"/>
                <!-- 주문 상품정보 s -->
                <div class="border-light-box">
                    <div class="sub_title">주문 상품정보</div>
                    <table class="table_style2 order_list">
                        <thead>
                            <tr>
                                <th>이미지</th>
                                <th>주문상품</th>
                                <th>단가</th>
                                <th>주문수량</th>
                                <th>공급가액</th>
                                <th>VAT</th>
                                <th>금액</th>
                            </tr>
                        </thead>
                        
                        <?php 
                        $all_amount_price = 0;
                        $all_price_vat = 0;
                        $delivery_prices = 0;
                        $all_order_total = 0;
                        $i = 1; 
                        $deliverydays = 0;

                        foreach ($lists as $key => $item) {

                            $item_price = $item->price;
                            $amount_price = $item_price * $item->qty;
                            $price_vat = $amount_price*0.1;
                            $total_price = $amount_price+$price_vat;
                        ?>
                            <tr>
                                <td><p class="prd-img">
                                    <?php if(isset($item->nowinfo['image_dir']) && $item->nowinfo['image_dir'] != ''): ?>
                                <?php if(isset($item->nowinfo['api_flg']) && $item->nowinfo['api_flg'] == '1'): ?>
                                    <img src="<?=$item->nowinfo['image_dir']?>"/>
                                <?php else : ?>
                                    <img src="<?=asset_public($item->nowinfo['image_dir'])?>"/>
                                <?php endif; ?>
                                <?php else : ?>
                                    <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                                <?php endif; ?>
                                </p></td>
                                <td>
                                    <p><label class="badge_blue font-sm">
                                        <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                            <?php if($stock_location->location_id == $item->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                        <?php endforeach; ?>
                                    </label></p>
                                    <p class="col-blue font-sm"><?=$item->name?></p>
                                    <p class="prd-subject"><?=$item->nowinfo['part_number']?></p>
                                    <input type="hidden" name="inquiry_id<?=$i?>" value="<?=$item->inquiry_id?>"/>
                                    <?php $inquiry_id_all = $inquiry_id_all.$item->inquiry_id.","; ?>
                                    <p class="prd-cmt col-gray font-sm"><?=$item->nowinfo['product_code']?></p>
                                    <p class="prd-option col-gray font-sm">
                                        <?php
                                        $brief_description = $item->nowinfo['brief_description'];
                                        $prd_description = explode('|^|', $brief_description);

                                        echo mb_strimwidth($prd_description[1],'0',40,'...','utf-8');
                                        ?>
                                    </p>
                                </td>
                                <td><?=number_format($item_price)?>원</td>
                                <input type="hidden" name="price<?=$i?>" value="<?=$item_price?>"/>
                                <td><?php echo $item->qty;?></td>
                                <input type="hidden" name="qty<?=$i?>" value="<?=$item->qty?>"/>
                                <td><?=number_format($amount_price)?>원</td>
                                <input type="hidden" name="supply_price<?=$i?>" value="<?=$amount_price?>"/>
                                <td><?=number_format($price_vat)?>원</td>
                                <input type="hidden" name="vat<?=$i?>" value="<?=$price_vat?>"/>
                                <td><?=number_format($total_price)?>원</td>
                                <input type="hidden" name="amount<?=$i?>" value="<?=$total_price?>"/>
                            </tr>
                    
                            <?php 
                            if ($i > 1) {
                                $inistgoodname = $item->nowinfo['product_code']." 외 ".count($lists)."개 품목";
                            } else {
                                $inistgoodname = $item->nowinfo['product_code'];
                            }

                            if ($deliverydays > $item->leadtime_info) {
                                $deliverydays = $deliverydays;
                            } else {
                                $deliverydays = $item->leadtime_info;
                            }

                            if ($delivery_prices > $item->delivery_price) {
                                $delivery_prices = $delivery_prices;
                            } else {
                                $delivery_prices = $item->delivery_price;
                            }

                                $all_amount_price = $all_amount_price + $amount_price;
                                $all_price_vat = $all_price_vat + $price_vat;
                                $i++; 
                        }

                            $delivery_free_standard = 30000; // 배송료무료 기준설정

                            if ($all_amount_price > $delivery_free_standard) {
                                $delivery_prices = 0;
                            }
                            
                            $all_order_total = 0;
                            $all_order_total = $all_amount_price + $all_price_vat + $delivery_prices;
                            $deliverytime = strtotime($deliverydays."days");

                            $del_han = $lists[0]->part_number;
                            $firstitem_number = preg_replace("/([^a-zA-Z0-9_\-+])/", "", $del_han); // 영/숫자/지정기호 이외 제거
                            ?>
                        </tbody>
                    </table>

                    
                    <dl class="order_list_mobile">
                        <dt>
                            <?php
                            $i = 1; 
                            $deliverydays = 0;
                            foreach($lists as $item_mobile){
                            ?>
                            <div class="prd-img">
                                <?php if(isset($item_mobile->nowinfo['image_dir']) && $item_mobile->nowinfo['image_dir'] != ''): ?>
                                    <?php if(isset($item_mobile->nowinfo['api_flg']) && $item_mobile->nowinfo['api_flg'] == '1'): ?>
                                        <img src="<?=$item_mobile->nowinfo['image_dir']?>"/>
                                    <?php else : ?>
                                        <img src="<?=asset_public($item_mobile->nowinfo['image_dir'])?>"/>
                                    <?php endif; ?>
                                <?php else : ?>
                                    <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                                <?php endif; ?>
                            </div>

                            <div class="prd-info">
                                <p><label class="badge_blue font-sm">
                                    <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                        <?php if($stock_location->location_id == $item_mobile->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                    <?php endforeach; ?>
                                </label></p>                     
                                <p class="col-blue font-sm"><?=$item_mobile->name;?></p>
                                <p class="prd-subject"><?=$item_mobile->part_number;?></p>
                                <p class="prd-cmt col-gray font-sm"><?=$item_mobile->nowinfo['product_code']?></p>
                                <p class="prd-option col-gray font-sm">
                                        <?php
                                        $brief_description = $item_mobile->nowinfo['brief_description'];
                                        $prd_description = explode('|^|', $brief_description);
                                        echo mb_strimwidth($prd_description[1],'0',30,'...','utf-8');
                                        ?>
                                </p>
                                <p class="prd-subject">단가 : <?=number_format($item_price)?>원</p>
                                <p class="prd-subject">수량 : <?php echo $item->qty;?></p>
                            </div>
                            <?php 
                                $i++; 
                            } 
                            ?>
                        </dt>
                        <dd class="bg-light-gray border-b">
                            <ul>
                                <li>공급가액</li> <li><?=number_format($all_amount_price)?>원</li>
                                <li>VAT</li> <li><?=number_format($all_price_vat)?>원</li>
                                <li>배송비</li> <li><?=number_format($delivery_prices)?></li>
                                <li>총금액</li> <li><?=number_format($all_order_total)?>원</li>
                            </ul>
                        </dd>
                    </dl>

                    <table class="table_style2 order_list_footer">
                        <thead>
                            <tr>
                                <th>공급가액</th>
                                <th>부가세(VAT)</th>
                                <th>배송비</th>
                                <th>총 결제 금액(VAT포함)</th>                        
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><?=number_format($all_amount_price)?>원</td>
                                <td><?=number_format($all_price_vat)?>원</td>
                                <td><?=number_format($delivery_prices)?>원</td>
                                <td><?=number_format($all_order_total)?>원</td>                        
                            </tr>                    
                        </tbody>
                    </table>
                </div>
                
                <input type="hidden" id="supply_price" name="supply_price" value="<?=$all_amount_price?>"/>
                <input type="hidden" id="vat" name="vat" value="<?=$all_price_vat?>"/>
                <input type="hidden" id="delivery_fee" name="delivery_fee" value="<?=$delivery_prices?>"/>
                <input type="hidden" id="amount_total" name="amount_total" value="<?=round($all_order_total)?>"/>

                <!-- 주문 상품정보 e -->
                <input type="hidden" id="inquiry_code" name="inquiry_code" value="<?=$lists[0]->inquiry_code?>">
                <input type="hidden" id="firstitem_number" name="firstitem_number" value="<?=$firstitem_number?>">
                <input type="hidden" id="item_counts" name="item_counts" value="<?=count($lists)?>">
                <input type="hidden" id="dataRow" name="dataRow" value="<?=$i?>">

                <input type="hidden" id="delivery_date" name="delivery_date" value="<?php echo  date("Y-m-d", $deliverytime);?>">

                <input type="hidden" id="firstitem_code" name="firstitem_code" value="<?=$lists[0]->part_sequence?>">
                <input type="hidden" id="firstitem_number" name="firstitem_number" value="<?=$lists[0]->part_number?>">
                <input type="hidden" id="firstitem_image" name="firstitem_image" value="<?=$lists[0]->nowinfo['image_dir']?>">
                <input type="hidden" id="item_counts" name="item_counts" value="<?=count($lists)?>">

                        <!-- 주문자 정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">주문자 정보</div>
                            
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">주문자</label>
                                    <input id="orderer_name6" type="text" name="buyername" value="<?=$userinfo->member_name?>" aria-describedby="orderer_name" required/>
                                    <input id="member_code" type="hidden" name="member_code" value="<?=$userinfo->member_code?>"/>
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">이메일</label>
                                    <input id="orderer_email" type="email" name="buyeremail" value="<?=$userinfo->member_email?>"  aria-describedby="orderer_email" required/>
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">주문자 휴대폰 <span class="col-red">*</span></label>
                                    <input id="orderer_phone6" type="text" name="buyertel" value="<?=$userinfo->member_phone?>" aria-describedby="orderer_phone" required/>
                                </div>                
                            </div>
                        </div>
                        <!-- 주문자 정보 e -->
                        <input type="hidden" name="price" value="<?php echo $all_order_total ?>">

                        <!-- 배송지 정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">배송지 정보
                            <label class="input-container ml-1">주문자정보 동일
                                    <input type="checkbox" id="agree6" onclick="ShipToBill6(this.form);"/>
                                    <span class="checkmark"></span>
                                </label>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분 <span class="col-red">*</span></label>
                                    <input id="shipping_name6" type="text" name="shipping_name"  value="<?=$userinfo->member_name?>" aria-describedby="shipping_name" required/>
                                </div>                
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">받는분 휴대폰 <span class="col-red">*</span></label>
                                    <input id="shipping_phone6" type="text" name="shipping_phone" value="<?=$userinfo->member_phone?>" aria-describedby="shipping_phone" required/>
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">받는분 전화 <span class="col-red">*</span></label>
                                    <input id="delivery_phone" type="text" name="delivery_phone" value="<?=$usersubinfo->com_phone?>" aria-describedby="delivery_phone"/>
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">회사명</label>
                                    <input id="company_name" type="text" name="company_name" value="<?=$usersubinfo->com_name?>" placeholder="회사(학교)명을 입력하세요.">
                                </div>
                            </div>
                            <?php
                            if ($usersubinfo->com_zipcode) {
                                $user_zipcode = $usersubinfo->com_zipcode;
                            } else {
                                $user_zipcode = $userinfo->member_zipcode;
                            }
                            if ($usersubinfo->com_address1) {
                                $user_address1 = $usersubinfo->com_address1;
                            } else {
                                $user_address1 = $userinfo->member_address1;
                            }
                            if ($usersubinfo->com_address2) {
                                $user_address2 = $usersubinfo->com_address2;
                            } else {
                                $user_address2 = $userinfo->member_address2;
                            }
                            ?>

                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">우편번호</label>
                                    <div class="group-btn d-flex">
                                    <input id="shipping_zipocode6" type="text" name="shipping_zipocode" value="<?=$user_zipcode?>" placeholder="우편번호">
                                    <input type="button" onclick="execDaumPostcode6()" value="우편번호 찾기" class="btn btn-gray ml-1">
                                    </div>
                                </div>
                                <div class="d-flex g-2"> </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송지</label>
                                    <input id="shipping_add61" type="text" name="shipping_add1" value="<?=$user_address1?>" placeholder="주소" required>
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송지</label>
                                    <input id="shipping_add62" type="text" name="shipping_add2" value="<?=$user_address2?>" placeholder="상세주소">
                                </div>
                            </div>
                            <div class="form-gp">                
                                <div class="d-flex g-2">
                                    <label for="">배송메시지 </label>
                                    <input id="shipping_message" type="text" name="shipping_message"  placeholder="배송메시지를 입력하세요.">
                                </div>
                            </div>
                        </div>


                        <!-- 결제정보 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">결제정보</div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">결제계좌</label>
                                    은행명 : 하나은행
                                    계좌번호 : 138-910044-11204
                                    예금주 : 주식회사셀파세미컴
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">입금자<span class="col-red">*</span></label>
                                    <input id="deposit_name" type="text" name="deposit_name" placeholder="입금자를 입력하세요.">
                                </div>
                                <div class="d-flex g-2">
                                    <label for="">입금예정일<span class="col-red">*</span></label>
                                    <input id="deposit_date" type="text" name="deposit_date" placeholder="예) 2025-01-01"/>
                                </div>
                            </div>
                        </div>
                        <!-- 결제정보 e -->
                         
                        <input type="hidden" name="payment_flg" value="Tran">

                        <!-- 계산서 발행 s -->
                        <div class="border-light-box order-form">
                            <div class="sub_title d-flex">계산서(현금영수증) 발행</div>
                            <div class="form-gp">
                                <div class="d-flex g-2">
                                    <label for="">발행구분</label>
                                    <div class="form-check g-2">
                                        <input class="form-check-input" name="invoice_type" type="radio" value="1" checked id="person">
                                        <label class="form-check-label">계산서</label>
                                    </div>
                                    <div class="form-check g-2">
                                        <input class="form-check-input" name="invoice_type" type="radio" value="2" id="company">
                                        <label class="form-check-label">현금영수증</label>
                                    </div>
                                </div>
                                <div class="d-flex g-2"> </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">회사명</label>
                                    <input id="invoice_com" type="text" name="invoice_com" placeholder="회사명">
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">사업자번호</label>
                                    <input id="invoice_biznum" type="text" name="invoice_biznum" placeholder="사업자번호">
                                </div>
                            </div>
                            <div class="form-gp">
                                <div class="d-flex g-1">
                                    <label for="">대표자명</label>
                                    <input id="invoice_ceo" type="text" name="invoice_ceo" placeholder="대표자명">
                                </div>
                            </div>
                        </div>
                        <!-- 계산서 발행 e -->

                <div class="order-btn-box btn-box">
                        <!--button class="btn font-xsm btn-outline-white float-l">거래 명세서 출력하기</button-->            
                        <!--button class="btn font-xsm btn-outline-white float-r ml-1">목록으로</button-->
                        <!--button class="btn font-xsm btn-outline-white float-r">수정하기</button-->                
                </div>

                <div class="order-btn-box mt-3 mb-2"> </div>
                <div class="order-btn-box btn-lg-box btn-box align-c">
                    <a href="<?=route_guest('cart')?>" class="btn btn-lg btn-outline-white" style="width:47%;">장바구니로</a>
                    <button onclick="paybtn()" type="submit" class="btn btn-lg btn-blue ml-1" style="width:47%;">다음</button>
                </div>
            </form>
            <!-- 탭 정보3 e -->
            </div>
        </div>

</div>
</section>
    <!-- product details top info e -->
    <!------------------------------------------------------------------------------------------------------------------->
    <?php endif;?>
    <!----------------------------------------------------------------------------------------------------------------------->
    <!-- 비회원 주문서작성 끝 -->

    <?php else: ?>
        <section id="siteMain" class="site-main">
            <div class="container">
                <div class="form-login">
                    <?php if($session->has('message')): ?>
                        <div class="alert alert-success">
                            <?=$session->get('message')?>
                        </div>
                    <?php endif; ?>
                    <?php if($session->has('error_message')): ?>
                        <div class="alert alert-danger">
                            <?=$session->get('error_message')?>
                        </div>
                    <?php endif; ?>
                    <h2 class="form-title"><?=lang_login('title')?></h2>
                    <form id="form" method="post" action="<?=route_guest('logincatall')?>">
                        <?php if(has_error('error_common')): ?>
                            <div class="alert alert-danger">
                                <span><?=get_error('error_common')?></span>
                            </div>
                        <?php endif?>
                        <div class="form-group">
                            <label for="member_email" class="form-label"><?=lang_login('user_name')?></label>
                            <input id="member_email" type="text" class="form-control" name="member_email"
                                aria-describedby="member_email" value="<?=old('member_email')?>"/>
                        </div>
                        <div class="form-group">
                            <label for="password" class="form-label"><?=lang_login('password')?></label>
                            <input id="password" type="password" class="form-control" name="password" aria-describedby="password"/>
                        </div>
                        <div class="form-group">
                            <div class="form-check">
                                <input class="form-check-input" name="remember" type="checkbox" <?=!empty(old('remember')) ? 'checked' : '' ?> value="<?=REMEMBER_FLG_ON?>" id="remember">
                                <label class="form-check-label" for="remember"><?=lang_login('remember')?></label>
                            </div>
                        </div>
                        <div class="form-action">
                            <button type="submit" class="btn btn-block btn-outline-primary w-100 active" name="submit"><?=lang_login('button_login')?></button>
                        </div>
                        </form>

                        <div class="form-link text-center">
                            <a class="link-register" href="<?=route_guest('register')?>"><?=lang_login('link_register')?></a>&nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;
                            <a class="link-register" href="<?=route_guest('forgot_password')?>"><?=lang_login('link_forgot_password')?></a>
                        </div>

                        <?php
                        define('NAVER_CLIENT_ID', 'bS6uqBpR00835BFLFGDa');
                        define('NAVER_CLIENT_SECRET', 'aETxh2Ecip');

                        // define('NAVER_CALLBACK_URL', 'http://localhost/naverapi/naverinfo');
                        // $naverUrl = "https://nid.naver.com/oauth2.0/authorize?response_type=code&client_id=".NAVER_CLIENT_ID."&redirect_uri=".urlencode(NAVER_CALLBACK_URL);

                        define('NAVER_CALLBACK_URL', 'https://chipdirect.co.kr/naverapi/naverinfo');
                        $naverUrl = "https://nid.naver.com/oauth2.0/authorize?response_type=code&client_id=".NAVER_CLIENT_ID."&redirect_uri=".urlencode(NAVER_CALLBACK_URL);

                        $REST_API_KEY   = "efbf6f87ffc71fde085dec391453d989"; // 내 애플리케이션 > 앱 설정 > 요약 정보
                        $CLIENT_SECRET  = ""; // 내 애플리케이션 > 제품 설정 > 카카오 로그인 > 보안
                        // $REDIRECT_URI  = urlencode("http://localhost/kakaoapi/kakaoinfo");
                        $REDIRECT_URI  = urlencode("https://chipdirect.co.kr/kakaoapi/kakaoinfo");
                        ?>

                        <div class="form-link text-center">
                            <a class="link-register" href="<?=$naverUrl?>"><img width="150" src="<?=asset_public('images/btnW_naver.png')?>"></a>&nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;
                            <a href="https://kauth.kakao.com/oauth/authorize?client_id=<?=$REST_API_KEY?>&response_type=code&redirect_uri=<?=$REDIRECT_URI?>"><img width="150" src="<?=asset_public('images/btnW_kakao.png')?>"></a>
                        </div>
                        <div class="form-link text-center">
                            &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;
                        </div>
                        <div class="form-action">
                            <form id="return_form" action="./sheetall" method="post">
                                <input type="hidden" name="nonmember" value="YES">
                                <button type="submit" class="btn btn-block btn-outline-primary w-100 active" name="submit"><?=lang_login('button_nonmember')?></button>
                            </form>
                        </div>
                </div>
            </div>

            <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
            <script>
                $(document).ready(function () {        
                    <?php if(session()->getFlashdata('status')) {?>
                        swal({
                            title: "<?=session()->getFlashdata('status')?>",
                            text: "<?=session()->getFlashdata('status_text')?>",
                            icon: "<?=session()->getFlashdata('status_icon')?>",
                            buttons: "확인",
                        });
                    <?Php } ?>
                });
            </script>
        </section>
    <?php endif; ?>

<?php endif; ?>

<script src="//t1.daumcdn.net/mapjsapi/bundle/postcode/prod/postcode.v2.js"></script>
    <script>
        function execDaumPostcode1() {
            new daum.Postcode({
                oncomplete: function(data) {
                    var addr = ''; // 주소 변수
                    var extraAddr = ''; // 참고항목 변수
                    
                    if (data.userSelectedType === 'R') { // 사용자가 도로명 주소를 선택했을 경우
                        addr = data.roadAddress;
                    } else { // 사용자가 지번 주소를 선택했을 경우(J)
                        addr = data.jibunAddress;
                    }

                    if(data.userSelectedType === 'R'){
                        if(data.bname !== '' && /[동|로|가]$/g.test(data.bname)){
                            extraAddr += data.bname;
                        }

                        if(data.buildingName !== '' && data.apartment === 'Y'){
                            extraAddr += (extraAddr !== '' ? ', ' + data.buildingName : data.buildingName);
                        }

                        if(extraAddr !== ''){
                            extraAddr = ' (' + extraAddr + ')';
                        }

                        document.getElementById("shipping_add12").value = extraAddr;                    
                    } else {
                        document.getElementById("shipping_add12").value = '';
                    }
                    document.getElementById('shipping_zipocode1').value = data.zonecode;
                    document.getElementById("shipping_add11").value = addr;
                    document.getElementById("shipping_add12").focus();
                }
            }).open();
        }

        function execDaumPostcode2() {
            new daum.Postcode({
                oncomplete: function(data) {
                    var addr = ''; // 주소 변수
                    var extraAddr = ''; // 참고항목 변수
                    
                    if (data.userSelectedType === 'R') { // 사용자가 도로명 주소를 선택했을 경우
                        addr = data.roadAddress;
                    } else { // 사용자가 지번 주소를 선택했을 경우(J)
                        addr = data.jibunAddress;
                    }

                    if(data.userSelectedType === 'R'){
                        if(data.bname !== '' && /[동|로|가]$/g.test(data.bname)){
                            extraAddr += data.bname;
                        }

                        if(data.buildingName !== '' && data.apartment === 'Y'){
                            extraAddr += (extraAddr !== '' ? ', ' + data.buildingName : data.buildingName);
                        }

                        if(extraAddr !== ''){
                            extraAddr = ' (' + extraAddr + ')';
                        }

                        document.getElementById("shipping_add22").value = extraAddr;                    
                    } else {
                        document.getElementById("shipping_add22").value = '';
                    }
                    document.getElementById('shipping_zipocode2').value = data.zonecode;
                    document.getElementById("shipping_add21").value = addr;
                    document.getElementById("shipping_add22").focus();
                }
            }).open();
        }

        function execDaumPostcode3() {
            new daum.Postcode({
                oncomplete: function(data) {
                    var addr = ''; // 주소 변수
                    var extraAddr = ''; // 참고항목 변수
                    
                    if (data.userSelectedType === 'R') { // 사용자가 도로명 주소를 선택했을 경우
                        addr = data.roadAddress;
                    } else { // 사용자가 지번 주소를 선택했을 경우(J)
                        addr = data.jibunAddress;
                    }

                    if(data.userSelectedType === 'R'){
                        if(data.bname !== '' && /[동|로|가]$/g.test(data.bname)){
                            extraAddr += data.bname;
                        }

                        if(data.buildingName !== '' && data.apartment === 'Y'){
                            extraAddr += (extraAddr !== '' ? ', ' + data.buildingName : data.buildingName);
                        }

                        if(extraAddr !== ''){
                            extraAddr = ' (' + extraAddr + ')';
                        }

                        document.getElementById("shipping_add32").value = extraAddr;                    
                    } else {
                        document.getElementById("shipping_add32").value = '';
                    }
                    document.getElementById('shipping_zipocode3').value = data.zonecode;
                    document.getElementById("shipping_add31").value = addr;
                    document.getElementById("shipping_add32").focus();
                }
            }).open();
        }
        function execDaumPostcode4() {
            new daum.Postcode({
                oncomplete: function(data) {
                    var addr = ''; // 주소 변수
                    var extraAddr = ''; // 참고항목 변수
                    
                    if (data.userSelectedType === 'R') { // 사용자가 도로명 주소를 선택했을 경우
                        addr = data.roadAddress;
                    } else { // 사용자가 지번 주소를 선택했을 경우(J)
                        addr = data.jibunAddress;
                    }

                    if(data.userSelectedType === 'R'){
                        if(data.bname !== '' && /[동|로|가]$/g.test(data.bname)){
                            extraAddr += data.bname;
                        }

                        if(data.buildingName !== '' && data.apartment === 'Y'){
                            extraAddr += (extraAddr !== '' ? ', ' + data.buildingName : data.buildingName);
                        }

                        if(extraAddr !== ''){
                            extraAddr = ' (' + extraAddr + ')';
                        }

                        document.getElementById("shipping_add42").value = extraAddr;                    
                    } else {
                        document.getElementById("shipping_add42").value = '';
                    }
                    document.getElementById('shipping_zipocode4').value = data.zonecode;
                    document.getElementById("shipping_add41").value = addr;
                    document.getElementById("shipping_add42").focus();
                }
            }).open();
        }

        function execDaumPostcode5() {
            new daum.Postcode({
                oncomplete: function(data) {
                    var addr = ''; // 주소 변수
                    var extraAddr = ''; // 참고항목 변수
                    
                    if (data.userSelectedType === 'R') { // 사용자가 도로명 주소를 선택했을 경우
                        addr = data.roadAddress;
                    } else { // 사용자가 지번 주소를 선택했을 경우(J)
                        addr = data.jibunAddress;
                    }

                    if(data.userSelectedType === 'R'){
                        if(data.bname !== '' && /[동|로|가]$/g.test(data.bname)){
                            extraAddr += data.bname;
                        }

                        if(data.buildingName !== '' && data.apartment === 'Y'){
                            extraAddr += (extraAddr !== '' ? ', ' + data.buildingName : data.buildingName);
                        }

                        if(extraAddr !== ''){
                            extraAddr = ' (' + extraAddr + ')';
                        }

                        document.getElementById("shipping_add52").value = extraAddr;                    
                    } else {
                        document.getElementById("shipping_add52").value = '';
                    }
                    document.getElementById('shipping_zipocode5').value = data.zonecode;
                    document.getElementById("shipping_add51").value = addr;
                    document.getElementById("shipping_add52").focus();
                }
            }).open();
        }

        function execDaumPostcode6() {
            new daum.Postcode({
                oncomplete: function(data) {
                    var addr = ''; // 주소 변수
                    var extraAddr = ''; // 참고항목 변수
                    
                    if (data.userSelectedType === 'R') { // 사용자가 도로명 주소를 선택했을 경우
                        addr = data.roadAddress;
                    } else { // 사용자가 지번 주소를 선택했을 경우(J)
                        addr = data.jibunAddress;
                    }

                    if(data.userSelectedType === 'R'){
                        if(data.bname !== '' && /[동|로|가]$/g.test(data.bname)){
                            extraAddr += data.bname;
                        }

                        if(data.buildingName !== '' && data.apartment === 'Y'){
                            extraAddr += (extraAddr !== '' ? ', ' + data.buildingName : data.buildingName);
                        }

                        if(extraAddr !== ''){
                            extraAddr = ' (' + extraAddr + ')';
                        }

                        document.getElementById("shipping_add62").value = extraAddr;                    
                    } else {
                        document.getElementById("shipping_add62").value = '';
                    }
                    document.getElementById('shipping_zipocode6').value = data.zonecode;
                    document.getElementById("shipping_add61").value = addr;
                    document.getElementById("shipping_add62").focus();
                }
            }).open();
        }
    </script>

<?= $this->endSection() ?>