<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/masterwin') ?>

<?= $this->section('head.title') ?>
    <?=lang_cart('title')?>
<?= $this->endSection() ?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('bootstrap-input-spinner.js')?>"></script>
    <script src="<?=asset_guest_js('form.input.number.js')?>"></script>
    <script src="<?=asset_guest_js('cart.js')?>"></script>
    <script src="<?=asset_guest_js('calculator.js')?>"></script>
    <script>
        $("input[type='number']").inputSpinner();
        CartJS.init();
    </script>

    <script>
        function info_chk() {
        frm.action='<?=route_guest('cart.deletepart')?>';
        frm.submit();
        return true;
        }
        function info_chk1(frm) {
        frm.action='<?=route_guest('cart.sheetall')?>';
        frm.submit();
        return true;
        }
        function info_chk2(frm) {
        frm.action='<?=route_guest('cart.sheet')?>';
        frm.submit();
        return true;
        }
        function info_chk3(frm) {
        frm.action='<?=route_guest('sale.estifromcart')?>';
        frm.submit();
        return true;
        }
    </script>
    <script type="text/javascript" src="https://wcs.naver.net/wcslog.js"></script>

    <script type="text/javascript">
        function selectAll(selectAll)  {
        const checkboxes 
            = document.querySelectorAll('input[id="pcheckbox"]');
        checkboxes.forEach((checkbox) => {
            checkbox.checked = selectAll.checked
        })
        }
	</script>

    <link rel="stylesheet" href="<?=asset_guest_css('cart.css')?>">
<?= $this->endSection() ?>
<?= $this->section('body.breadcrumb') ?>

<?= $this->endSection() ?>

<?= $this->section('content') ?>
<!--#siteMain-->
<!------------------------------------------------------------------------------------------------------------------->
<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap">

    <?php if (!$lists) :?>
    <div class="order_List mb40">

    <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>

        <script>
            swal({
            title: "담겨진 상품이 없습니다.",
            text: "장바구니에 주문하실 상품을 담으신 후 진행하세요.",
            icon: "warning",
            buttons: "확인"
            }).then(function() {
                window.location = "<?=route_guest('home')?>";
            });
        </script>

    </div>
    <?php else: ?>


        <!-- 견 적 서 s -->
        <div class="border-light-box">
            <div style="text-align: center; font-size: 40px; margin-bottom:1em;">견 적 서</div>
            <form id="SendPayForm_id" name="user_form" method="post" action="<?=route_guest('cart.mailestimate')?>">
            <div class="form-gp">
            <div class="d-flex g-2">
                    <table class="table_estimate">
                        <tr>
                            <th>수신자</th><td>
                            <input id="orderer_name" type="text" name="buyername" value="<?=$userinfo->member_name?>" required/>
                            </td>
                            <input id="member_code" type="hidden" name="member_code" value="<?=$userinfo->member_code?>"/>
                        </tr>
                        <tr>
                            <th>수신 E-Mail</th><td>
                            <input id="orderer_email" type="email" name="buyeremail" value="<?=$userinfo->member_email?>" required/>
                            </td>
                        </tr>
                        <tr>
                            <td style="border-bottom: 0px solid;">&nbsp;</td>
                        </tr>
                        <tr>
                            <td style="border-bottom: 0px solid;">&nbsp;</td>
                        </tr>
                        <!--tr>
                            <td style="border-bottom: 0px solid;">&nbsp;</td>
                        </tr-->
                        <tr>
                        <td colspan='2' style="text-align:left; font-weight:bold;">아래와 같이 견적합니다.</td>
                        </tr>
                    </table>
                </div>
                <div class="d-flex g-2">
                    <table class="table_estimate">
                        <tr>
                            <th>사업자번호</th><td>215-87-35572</td>
                        </tr>
                        <tr>
                            <th>상호</th><td>주식회사 셀파세미컴</td>
                        </tr>
                        <tr>
                            <th>대표자명</th><td>김현철</td>
                        </tr>
                        <tr>
                            <th>주소</th><td>경기도 남양주시 다산중앙로 19번길 21</td>
                        </tr>
                        <tr>
                            <th>전화번호</th><td>031-556-6153</td>
                        </tr>
                        <tr>
                            <th>홈페이지주소</th><td>https://chipdirect.co.kr</td>
                        </tr>
                    </table>
                </div>

            </div>

            <table class="table_style2 order_list">
                <thead>
                    <tr>
                        <th>No.</th>
                        <th>품명</th>
                        <th>수량</th>
                        <th>단가</th>
                        <th>공급가액</th>
                        <th>VAT</th>
                        <th>상품금액합계</th>
                    </tr>
                </thead>
                <tbody>
                <?php 
                $i = 1; 
                $deliverydays = 0;
                
                foreach($lists as $key => $item){
                
                    $item_price = $item->price;
                    $amount_price = $item_price * $item->qty;
                    $price_vat = $amount_price*0.1;
                    $total_price = $amount_price+$price_vat;
                ?>

                    <tr>
                        <td class="text-center">
                            <?=show_no_row($key+1, $perPage, $currentPage)?>
                        </td>

                        <td>
                            <p class="col-blue font-sm"><?php echo $item->name;?>
                                <label class="badge_blue font-sm">
                                    <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                        <?php if($stock_location->location_id == $item->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                    <?php endforeach; ?>
                                </label>
                            </p>
                            <p class="prd-subject"><?php echo $item->part_number;?></p>
                            <p class="prd-cmt col-gray font-sm"><?=$item->nowinfo['product_code']?></p>
                        </td>
                        <td><?php echo $item->qty;?></td>
                        <td><?=number_format($item_price)?>원</td>
                        <td><?=number_format($amount_price)?>원</td>
                        <td><?=number_format($price_vat)?>원</td>
                        <td><?=number_format($total_price)?>원</td>
                    </tr>

                    <?php
                    $all_qty = $all_qty + $item->qty;;
                    $all_amount_price = $all_amount_price + $amount_price;
                    $all_price_vat = $all_price_vat + $price_vat;
 
                    if ($deliverydays > $item->leadtime_info) {
                        $deliverydays = $deliverydays;
                    } else {
                        $deliverydays = $item->leadtime_info;
                    }

                    $i++;

                    }

                    $all_price = $all_amount_price + $all_price_vat;
                    $timestamp = strtotime($deliverydays."days");
                    ?>
                </tbody>
            </table>

            <input type="hidden" name="dataRow" value="<?=$i?>">
            
            <dl class="order_list_mobile">
                <dt>                    
                    <?php
                    $i = 1; 
                    $deliverydays = 0;
                    foreach($lists as $item_mobile){
                    ?>
                    <div class="prd-img">
                        <?php if(isset($item_mobile->nowinfo['image_dir']) && $item_mobile->nowinfo['image_dir'] != ''): ?>
                            <?php if(isset($item_mobile->nowinfo['api_flg']) && $item_mobile->nowinfo['api_flg'] == '1'): ?>
                                <img src="<?=$item_mobile->nowinfo['image_dir']?>"/>
                            <?php else : ?>
                                <img src="<?=asset_public($item_mobile->nowinfo['image_dir'])?>"/>
                            <?php endif; ?>
                        <?php else : ?>
                            <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                        <?php endif; ?>
                    </div>

                    <div class="prd-info">
                        <p><label class="badge_blue font-sm">
                            <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                <?php if($stock_location->location_id == $item_mobile->nowinfo['stock_location']) echo $stock_location->location_info;?>
                            <?php endforeach; ?>
                        </label></p>                     
                        <p class="col-blue font-sm"><?=$item_mobile->name;?> <input id="pcheckbox"  type="checkbox" name="chk<?=$i?>" value="active<?=$i?>"></p>
                        <p class="prd-subject"><?=$item_mobile->part_number;?> <button class="btn font-xsm btn-blue" type="button" onclick="delete_cart(<?php echo $item_mobile->inquiry_id;?>)">삭제</button></p>
                        <p class="prd-cmt col-gray font-sm"><?=$item_mobile->nowinfo['product_code']?></p>
                        <p class="prd-option col-gray font-sm">
                                <?php
                                $brief_description = $item_mobile->nowinfo['brief_description'];
                                $prd_description = explode('|^|', $brief_description);
                                echo mb_strimwidth($prd_description[1],'0',30,'...','utf-8');
                                ?>
                        </p>
                        <p class="prd-subject">단가 : <?=number_format($item_price)?>원</p>
                        <p class="prd-subject">수량 : <?php echo $item->qty;?></p>
                    </div>
                    <?php } ?>
                </dt>
                <dd class="bg-light-gray border-b">
                    <ul>
                        <li>공급가액</li> <li><?=number_format($all_amount_price)?>원</li>
                        <li>부가세액</li> <li><?=number_format($all_price_vat)?>원</li>
                        <li>합계</li> <li><?=number_format($all_price)?>원</li>
                    </ul>
                </dd>
            </dl>

            <table class="table_style2 order_list_footer">
                <tbody>
                    <tr>
                        <td>공급가액: <?=number_format($all_amount_price)?>원</td>
                        <td>부가세액: <?=number_format($all_price_vat)?>원</td>
                        <td> 합 계 : <?=number_format($all_price)?>원</td>                        
                    </tr>                    
                </tbody>
            </table>
            <p  style="text-align:left; font-size: 13px; color: #540d17">
                ※ 메이커상품 중에 옵션에 따라 단가가 변동하는 경우에는 수량이 1개(실제수량) 형식으로 표기됩니다.<br>
                ※ 해당 상품의 가격 정보는 견적일 기준이며, 실 제품 구매시에는 최종 단가를 반드시 확인하시기 바랍니다.<br>
                ※ 견적서 노출 가격은 부가세 포함가격이며, 배송비는 배송방법 및 선/착불에 따라 다르게 노출됩니다.<br>
                칩다이렉트 고객센터 :  031-556-6153<br>
            </p>
        </div>

    </div>

    <?php 
        $estimateMessage1 = "<table width='90%' style='border:2px solid #000;'><tr><td colspan='2'><div style='text-align: center; font-size: 40px; margin-top:1em; margin-bottom:1em;'>견 적 서</div></td></tr><tr><td width='50%'><table width='100%'>";
        // $estimateMessage2 = "<tr><td width='30%' style='text-align:center; border: 1px solid #000;'>수신자</td><td style='text-align:left; border: 1px solid #000;'>&nbsp;</td></tr><tr><td width='30%' style='text-align:center; border: 1px solid #000;'>수신 E-Mail</td><td style='text-align:left; border: 1px solid #000;'>&nbsp;</td></tr>";
        $estimateMessage3 .= "<tr><td style='border-bottom: 0px solid;'>&nbsp;</td></tr><tr><td style='border-bottom: 0px solid;'>&nbsp;</td></tr><tr><td style='border-bottom: 0px solid;'>&nbsp;</td></tr><tr><td colspan='2' style='border-bottom: 0px solid; text-align:left; font-weight:bold;'>아래와 같이 견적합니다.</td></tr>
                    </table></td><td width='50%'><table width='100%'><tr><td width='30%' style='text-align:center; border: 1px solid #000;'>사업자번호</td><td style='text-align:left; border: 1px solid #000;'>215-87-35572</td></tr>
                    <tr><td width='30%' style='text-align:center; border: 1px solid #000;'>상호</td><td style='text-align:left; border: 1px solid #000;'>주식회사 셀파세미컴</td></tr><tr><td width='30%' style='text-align:center; border: 1px solid #000;'>대표자명</td><td style='text-align:left; border: 1px solid #000;'>김현철</td></tr>
                    <tr><td width='30%' style='text-align:center; border: 1px solid #000;'>주소</td><td style='text-align:left; border: 1px solid #000;'>경기도 남양주시 다산중앙로 19번길 21</td></tr><tr><td width='30%' style='text-align:center; border: 1px solid #000;'>전화번호</td><td style='text-align:left; border: 1px solid #000;'>031-556-6153</td></tr>
                    <tr><td width='30%' style='text-align:center; border: 1px solid #000;'>홈페이지주소</td><td style='text-align:left; border: 1px solid #000;'>https://chipdirect.co.kr</td></tr></table></td></tr><tr><td colspan='2'><table width='100%'><thead><tr>
                    <td width='5%' style='text-align:center; border: 1px solid #000;'>No.</td><td width='37%' style='text-align:center; border: 1px solid #000;'>품명</td><td width='10%' style='text-align:center; border: 1px solid #000;'>수량</td><td width='12%' style='text-align:center; border: 1px solid #000;'>단가</td>
                    <td width='12%' style='text-align:center; border: 1px solid #000;'>공급가액</td><td width='12%' style='text-align:center; border: 1px solid #000;'>VAT</td><td width='12%' style='text-align:center; border: 1px solid #000;'>상품금액합계</td></tr></thead><tbody>";

                    $i = 1; 
                    $deliverydays = 0;
                    foreach($lists as $key => $item){
                        $item_price = $item->price;
                        $amount_price = $item_price * $item->qty;
                        $price_vat = $amount_price*0.1;
                        $total_price = $amount_price+$price_vat;
        $estimateMessage3 .= "<tr><td style='text-align:center; border: 1px solid #000;'>".show_no_row($key+1, $perPage, $currentPage)."</td><td style='border: 1px solid #000;'><p>".$item->name;
                            foreach ($stocklocationcategorys as $stock_location): 
                                if($stock_location->location_id == $item->nowinfo['stock_location']) 
        $estimateMessage3 .= " (".$stock_location->location_info.")";
                            endforeach;
        $estimateMessage3 .= "</p><p>".$item->part_number."</p><p>".$item->nowinfo['product_code']."</p></td><td style='text-align:center; border: 1px solid #000;'>".$item->qty."</td><td style='text-align:center; border: 1px solid #000;'>".number_format($item_price)."원</td><td style='text-align:center; border: 1px solid #000;'>".number_format($amount_price)."원</td>
                    <td style='text-align:center; border: 1px solid #000;'>".number_format($price_vat)."원</td><td style='text-align:center; border: 1px solid #000;'>".number_format($total_price)."원</td></tr>";

                    $mailall_qty = $mailall_qty + $item->qty;;
                    $mailall_amount_price = $mailall_amount_price + $amount_price;
                    $mailall_price_vat = $mailall_price_vat + $price_vat;
                    if ($deliverydays > $item->leadtime_info) {
                        $deliverydays = $deliverydays;
                    } else {
                        $deliverydays = $item->leadtime_info;
                    }
                    $i++;
                    }
                    $mailall_price = $mailall_amount_price + $mailall_price_vat;
                    $timestamp = strtotime($deliverydays.'days');

        $estimateMessage3 .= "</tbody></table><table width='100%' style='border:1px solid #000;'><tbody><tr><td style='text-align:center;'>공급가액: ".number_format($mailall_amount_price)."원</td><td style='text-align:center;'>부가세액: ".number_format($mailall_price_vat)."원</td><td style='text-align:center;'> 합 계 : ".number_format($mailall_price)."원</td></tr></tbody></table>
                    <p  style='text-align:left; font-size: 13px; color: #540d17'>※ 메이커상품 중에 옵션에 따라 단가가 변동하는 경우에는 수량이 1개(실제수량) 형식으로 표기됩니다.<br>※ 해당 상품의 가격 정보는 견적일 기준이며, 실 제품 구매시에는 최종 단가를 반드시 확인하시기 바랍니다.<br>
                    ※ 견적서 노출 가격은 부가세 포함가격이며, 배송비는 배송방법 및 선/착불에 따라 다르게 노출됩니다.<br>칩다이렉트 고객센터 :  031-556-6153<br></p></td></tr></thead>";
    ?>

        <input type="hidden" name="estimatemessage1" value="<?=$estimateMessage1?>"/>
        <!--input type="hidden" name="estimatemessage2" value="<?=$estimateMessage2?>"/-->
        <input type="hidden" name="estimatemessage3" value="<?=$estimateMessage3?>"/>

        <div class="order-btn-box btn-lg-box btn-box align-c mt-3 mb-1">
            <button type="submit" class="btn btn-lg btn-blue w-20 ml-1">확인</button>
        </div>

    </form>

    <?php endif;?>

</section>
<!-- product details top info e -->
        
<!------------------------------------------------------------------------------------------------------------------->
<!------------------------------------------------------------------------------------------------------------------->

<?= $this->endSection() ?>
