<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=yes">
    <link rel="stylesheet" href="<?php echo base_url('/css/guest/bootstrap.min.css'); ?>" >
    <script src="<?php echo base_url('/js/jquery.min.js'); ?>"></script>
    <script src="<?php echo base_url('/js/popper.min.js'); ?>"></script>
    <script src="<?php echo base_url('/js/bootstrap.min.js'); ?>"></script>
    <title>Codeigniter 4 Dynamic Dependent Dropdown with Ajax</title>
</head>
<body>
    <div class="container">
        <h2 class="text-center mt-4 mb-4">Codeigniter 4 Dynamic Dependent Dropdown with Ajax</h2>
        <span id="message"></span>
        <div class="card">
            <div class="card-header">Codeigniter 4 Dynamic Dependent Dropdown with Ajax</div>
            <div class="card-body">
                <div class="row justify-content-md-center">
                    <div class="col col-lg-6">
                        <div class="form-group">
                            <select name="category1" id="category1" class="form-control input-lg">
                                <option value="">Select Category1</option>
                                <?php
                                foreach($category1 as $row)
                                {
                                    echo '<option value="'.$row["category1_id"].'">'.$row["category1_name"].'</option>';
                                }
                                ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <select name="category2" id="category2" class="form-control input-lg">
                                <option value="">Select Category2</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <select name="category3" id="category3" class="form-control input-lg">
                                <option value="">Select Category3</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
 
</body>
</html>

<script>

$(document).ready(function(){

    $('#category1').change(function(){

        var category1_id = $('#category1').val();

        var action = 'get_category2';

        if(category1_id != '')
        {
            $.ajax({
                url:"<?php echo base_url('/Category3Select/action'); ?>",
                method:"POST",
                data:{category1_id:category1_id, action:action},
                dataType:"JSON",
                success:function(data)
                {
                    var html = '<option value="">Select Category2</option>';

                    for(var count = 0; count < data.length; count++)
                    {

                        html += '<option value="'+data[count].category2_id+'">'+data[count].category2_name+'</option>';

                    }

                    $('#category2').html(html);
                }
            });
        }
        else
        {
            $('#category2').val('');
        }
        $('#category3').val('');
    });

    $('#category2').change(function(){

        var category2_id = $('#category2').val();

        var action = 'get_category3';

        if(category2_id != '')
        {
            $.ajax({
                url:"<?php echo base_url('/Category3Select/action'); ?>",
                method:"POST",
                data:{category2_id:category2_id, action:action},
                dataType:"JSON",
                success:function(data)
                {
                    var html = '<option value="">Select Category3</option>';

                    for(var count = 0; count < data.length; count++)
                    {
                        html += '<option value="'+data[count].category3_id+'">'+data[count].category3_name+'</option>';
                    }

                    $('#category3').html(html);
                }
            });
        }
        else
        {
            $('#category3').val('');
        }

    });

});

</script>