<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=yes">
    <link rel="stylesheet" href="<?php echo base_url('/css/guest/bootstrap.min.css'); ?>" >
    <script src="<?php echo base_url('/js/jquery.min.js'); ?>"></script>
    <script src="<?php echo base_url('/js/popper.min.js'); ?>"></script>
    <script src="<?php echo base_url('/js/bootstrap.min.js'); ?>"></script>
    <title>Codeigniter 4 Dynamic Dependent Dropdown with Ajax</title>
</head>
<body>
    <div class="container">
        <h2 class="text-center mt-4 mb-4">Codeigniter 4 Dynamic Dependent Dropdown with Ajax</h2>
        <span id="message"></span>
        <div class="card">
            <div class="card-header">Codeigniter 4 Dynamic Dependent Dropdown with Ajax</div>
            <div class="card-body">
                <div class="row justify-content-md-center">
                    <div class="col col-lg-6">
                        <div class="form-group">
                            <select name="categorylevel1" id="categorylevel1" class="form-control input-lg">
                                <option value="">Select Categorylevel1</option>
                                <?php
                                foreach($categorylevel1 as $row)
                                {
                                    echo '<option value="'.$row["categorylevel1_code"].'">'.$row["categorylevel1_name"].'</option>';
                                }
                                ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <select name="categorylevel2" id="categorylevel2" class="form-control input-lg">
                                <option value="">Select Categorylevel2</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <select name="categorylevel3" id="categorylevel3" class="form-control input-lg">
                                <option value="">Select Categorylevel3</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
 
</body>
</html>

<script>

$(document).ready(function(){

    $('#categorylevel1').change(function(){

        var categorylevel1_code = $('#categorylevel1').val();

        var action = 'get_categorylevel2';

        if(categorylevel1_code != '')
        {
            $.ajax({
                url:"<?php echo base_url('/Categorylevel3Select/action'); ?>",
                method:"POST",
                data:{categorylevel1_code:categorylevel1_code, action:action},
                dataType:"JSON",
                success:function(data)
                {
                    var html = '<option value="">Select Categorylevel2</option>';

                    for(var count = 0; count < data.length; count++)
                    {

                        html += '<option value="'+data[count].categorylevel2_code+'">'+data[count].categorylevel2_name+'</option>';

                    }

                    $('#categorylevel2').html(html);
                }
            });
        }
        else
        {
            $('#categorylevel2').val('');
        }
        $('#categorylevel3').val('');
    });

    $('#categorylevel2').change(function(){

        var categorylevel2_code = $('#categorylevel2').val();

        var action = 'get_categorylevel3';

        if(categorylevel2_code != '')
        {
            $.ajax({
                url:"<?php echo base_url('/Categorylevel3Select/action'); ?>",
                method:"POST",
                data:{categorylevel2_code:categorylevel2_code, action:action},
                dataType:"JSON",
                success:function(data)
                {
                    var html = '<option value="">Select Categorylevel3</option>';

                    for(var count = 0; count < data.length; count++)
                    {
                        html += '<option value="'+data[count].categorylevel3_code+'">'+data[count].categorylevel3_name+'</option>';
                    }

                    $('#categorylevel3').html(html);
                }
            });
        }
        else
        {
            $('#categorylevel3').val('');
        }

    });

});

</script>