<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=lang_contact('news')?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('body.js') ?>
    <script src="<?=asset_guest_js('lte/bootstrap-switch.min.js')?>"></script>
    <script src="<?=asset_guest_js('lte/bs-custom-file-input.min.js')?>"></script>
    <script type="text/javascript">
        $("input[data-bootstrap-switch]").each(function(){
            $(this).bootstrapSwitch('state', $(this).prop('checked'));
        });
        $(document).ready(function () {
            bsCustomFileInput.init();
            $('a.button-add').on('click',function(){
                var divParent = $(this).closest('div.file_upload');
                inputs = divParent.find('div.file_item');
                $.each(inputs,function () {
                    if($(this).hasClass('hide')){
                        $(this).removeClass('hide');
                        return false;
                    }
                });

            });

            $('a.button-delete').on('click',function(){
                var divParent = $(this).closest('div.file_item');
                divParent.find('input[type=file]').val('');
                divParent.find('input[type=file]').removeClass('is-invalid');
                divParent.find('span.is-invalid').remove();
                divParent.find('label').html('Choose file');
                divParent.addClass('hide');
            });
        });
    </script>
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <!--#siteMain-->
    <section id="siteMain" class="site-main">
        <div class="container">

<form method="post" action="<?=route_guest('contact.news.create')?>" enctype="multipart/form-data" id="form">
<div class="card-body">
    <div class="form-group row">
        <label class="col-md-2 col-form-label" for="text-input">
            <?=lang_common('category')?>
        </label>
        <div class="col-md-10">
            <select class="form-control" name="category_id">
                <?php foreach ($categories as $category): ?>
                    <option value="<?=$category->category_id?>">
                        <?=$category->category_name?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
    <div class="form-group row">
        <label class="col-md-2 col-form-label" for="text-input">
            <?=lang_common('title')?>
            <span class="color-red">*</span>
        </label>
        <div class="col-md-10">
            <input class="form-control" id="text-input" type="text" name="title" placeholder="<?=lang_common('title')?>">
        </div>
    </div>
    <div class="form-group row">
        <label class="col-md-2 col-form-label" for="text-input">
            <?=lang_common('file_upload')?>
        </label>
        <div class="col-md-10 file_upload">
            <?php for($i =1 ; $i <= $maxFiles ; $i ++): ?>
                <div class="input-group pb-2 file_item <?php if($i > 1) echo 'hide'?>">
                    <div class="custom-file">
                        <input type="file" class="custom-file-input" id="files_<?=$i?>" name="files_<?=$i?>" maxsizeMb="3" accept="image/*,.pdf,.xlsx,.xls,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel, application/vnd.ms-excel,application/pdf">
                        <label class="custom-file-label" for="files_<?=$i?>">Choose file</label>
                    </div>
                    <div class="file_action">
                        <?php if($i > 1): ?>
                            <a href="javascript:void(0)" class="button-delete color-red">
                                <i class="fa fa-minus-square"></i>
                            </a>
                        <?php else: ?>
                            <a href="javascript:void(0)" class="button-add">
                                <i class="fas fa-plus-circle"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endfor; ?>
            <span class="help-block">
                <code>
                    <i class="fa fa-exclamation" aria-hidden="true"></i>
                    <?=lang_common('file_upload_note')?>
                </code>
            </span>
        </div>
    </div>
    <div class="form-group row">
        <label class="col-md-2 col-form-label" for="text-input">
            <?=lang_common('content')?>
            <span class="color-red">*</span>
        </label>
        <div class="col-md-10">
            <div class="row">
                <div class="col-md-12">
                    <textarea class="form-control" id="content" name="content" rows="8"></textarea>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="form-group text-center">
    <button class="btn btn-primary btn-lg" type="submit"><?=lang_common('create')?></button>
</div>
</div>
</form>

        </div>
    </section>
    <!--/#siteMain-->
<?= $this->endSection() ?>
