<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$item->title?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('content') ?>
<!--#siteMain-->
<section id="siteMain" class="site-main">

    <style>
        .news-detail .item .title {
            text-align: center;
            /*text-transform: uppercase;*/
            background-color: #ddd;
            padding: 10px;
        }
        .news-detail .item .content{
            padding: 10px;
        }
        .news-detail div.row.item{
            border: #E6E6E6 1px solid;
            margin: 0 auto;
        }
        .step-news-detail{
            color: #b00020;
        }
        .news-detail div.row.button{
            padding: 10px;
        }
        .content .hit{
            padding-left: 10px;
        }
    </style>
    <div class="container">
        <!--h6 class="step-news-detail">List <i class="fas fa-angle-right"></i> Detail </h6-->

    <div class="sub07Wrap">
        <div class="wrap">

            <div class="subWrap01Top">
                <div class="sub_category">
                    <div class="sub_categoryName">
                        <p>HOME > <?=lang_deferredpay('title')?>
                    </div>
                    <div class="sub_categoryBtn">
                        <p>서브메뉴 접기 </p>
                        <span><img src="<?=asset_public('images/upbtn.png')?>" alt="접기"></span>
                    </div>
                </div>
                <div class="sub_categoryMenu on">
                    <ul>
                        <li><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li><a href="<?=route_guest('inquiry')?>">상품문의</a></li>
                        <li><a href="<?=route_guest('estimate')?>">견적문의</a></li>
                        <li class="on"><a href="<?=route_guest('deferredpay')?>">후불문의</a></li>
                        <li><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <li><a href="<?=route_guest('review')?>">상품후기</a></li>
                        <li><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <li><a href="<?=route_guest('news')?>">공지사항</a></li>
                    </ul>
                </div>
            </div>

    <?php if ($item->member_code != AuthHelpers::getLoginInfoGuest()->member_code ) {?>
    <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
    <script>
        $(document).ready(function () {
    
            swal({
                title: "정보오류",
                text: "회원정보가 없거나 일치하지 않습니다.",
                icon: "warning",
                button: "확인",
            })
            .then(function(){
                location.href = "/deferredpay";
            });
    
        });
    </script>
    <?php } else {?>

            <div class="order_List inquiry mb40 ">
                <div class="order_ListTh inquiry">
                    <ul>
                        <li class="order_ListTh01"><?=lang_deferredpay('title')?></li>
                        <li class="order_ListTh01"><?=lang_contact('news_hit')?> : 
                        <span><?=\App\Helpers\NumberHelper::format($item->hit_number, true)?></span></li>                   
                    </ul>
                </div>
            </div>
            
            <div class="inquiry">
                <div class="inquiryT">
                    <div class="inquiryWrap">
                        <div class="inquiryLable">
                            <p><?=lang_contact('news_title')?></p>
                        </div>
                        <div class="inquiryText">
                            <?=$item->title?>
                        </div>
                    </div>

                    <!--div class="inquiryT">
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                                <p><?=lang_contact('news_file')?></p>
                            </div>
                            <div class="inquiryText">
                                <p>
                                <?php foreach ($files as $index => $fileItem): ?>
                                    <div class="input-group">
                                        <label>
                                            <a href="<?=route_guest('deferredpay.view_file', $item->id, $fileItem->file_no)?>" target="<?=open_file_browser($fileItem->file_name)?>">
                                                <?=$fileItem->file_name?>
                                            </a>
                                        </label>
                                    </div>
                                <?php endforeach;?>
                                </p>
                            </div>
                        </div>
                    </div-->

                    <div class="inquiryWrapB">
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                            <p><?=lang_contact('news_id')?></p>
                            </div>
                            <div class="inquiryText">
                                <?=$item->user_name?>
                            </div>
                        </div>
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                            <p><?=lang_contact('news_category')?></p>
                            </div>
                            <div class="inquiryText">
                                <?=$item->category_name?>
                            </div>

                        </div>
                        <div class="inquiryWrap">
                            <div class="inquiryLable">
                            <p><?=lang_contact('news_date')?></p>
                            </div>
                            <div class="inquiryText">
                                 <?=\App\Helpers\DateHelper::toTimeString($item->created_at,'yyyy-MM-dd')?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="inquiryWrapD">
                    <div class="inquiryLable100">
                        <p><?=lang_common('question')?></p>
                    </div>
                </div>
                <div class="inquiryContents">
                    <?php echo htmlspecialchars_decode($item->content)?>
                </div>
                <div class="inquiryWrapD">
                    <div class="inquiryLable100">
                        <p><?=lang_common('answer')?></p>
                    </div>
                </div>
                <div class="inquiryContents answerinquiry">
                    <?php echo htmlspecialchars_decode($item->answer_content)?>
                </div>
            </div>

            <div class="inquirybtnList">
                <ul>
                    <!--li><a href="#">이전내용</a></li-->
                    <li class="inquiryList"><a href="<?=route_guest('deferredpay')?>"><?=lang_contact('news_list')?></a></li>
                    <li><a href="<?=route_guest('deferredpay.update', $item->id)?>"><?=lang_common('update')?></a></li>
                    <!--li><a href="#">다음내용</a></li-->
                </ul>
            </div>

        </div>

        <?php } ?>

    </div>
    </div>
</section>  
<?= $this->endSection() ?>
