<?php
use App\Helpers\AuthHelpers;
?>

<?= $this->extend('guest/layouts/master') ?>

<?= $this->section('head.title') ?>
    <?=$item->title?>
<?= $this->endSection() ?>

<?= $this->section('body.breadcrumb')?>

<?=$this->endSection()?>

<?= $this->section('content') ?>
<!--#siteMain-->

<!-- product details top info s -->
<section class="sub_wrap">
    <div class="content_wrap">
<!------------------------------------------------------------------------------------------------------------------->

        <nav class="breadcrumb" style='background-color: #ffffff;'>
            <ul>
            <li><a href='<?=route_guest('home')?>'><img src='<?=asset_public('images/ico-home.png')?>' alt=''></a></li>
            <li><a href="#">마이페이지</a></li>
                <li><a href="#"><?=lang_estimate('title')?></a></li>                
            </ul>            
        </nav>

        <div class="prd-category mt-2">            
            <select name="" id="" class="prd-cate-mo">
                <option value=""><a href="<?=route_guest('one2one')?>">1:1 상담</a></option>
                <option value=""><a href="<?=route_guest('inquiry')?>">상품문의</a></option>
                <option value=""><a href="<?=route_guest('estimate')?>">견적문의</a></option>
                <!--option value=""><a href="<?=route_guest('deferredpay')?>">후불문의</a></option-->
                <option value=""><a href="<?=route_guest('orderinfo')?>">주문내역</a></option>
                <!--option value=""><a href="<?=route_guest('review')?>">상품후기</a></option-->
                <option value=""><a href="<?=route_guest('refundinfo')?>">반품문의</a></option>
                <!--option value=""><a href="<?=route_guest('news')?>">공지사항</a></option-->
            </select>

            <div class="prd-cate-pc">
                <div class="category-toggle">                
                마이페이지
                </div>
                <div class="category-box">
                    <ul>
                        <li class="prd_cate_item"><a href="<?=route_guest('one2one')?>">1:1 상담</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('inquiry')?>">상품문의</a></li>
                        <li class="prd_cate_item"><a href="<?=route_guest('estimate')?>" class="active">견적문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('deferredpay')?>">후불문의</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('orderinfo')?>">주문내역</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('review')?>">상품후기</a></li-->
                        <li class="prd_cate_item"><a href="<?=route_guest('refundinfo')?>">반품문의</a></li>
                        <!--li class="prd_cate_item"><a href="<?=route_guest('news')?>">공지사항</a></li-->
                    </ul>
                </div>
            </div>
        </div>

<!------------------------------------------------------------------------------------------------------------------->
    <!--/div>
</section-->
<!-- product details top info e -->

<!---------------------------------------------------------------------------------------------------------------->


    <?php if ($item->member_code != AuthHelpers::getLoginInfoGuest()->member_code ) {?>
    <script src="<?=asset_guest_js('sweetalert.min.js')?>"></script>
    <script>
        $(document).ready(function () {
    
            swal({
                title: "정보오류",
                text: "회원정보가 없거나 일치하지 않습니다.",
                icon: "warning",
                button: "확인",
            })
            .then(function(){
                location.href = "/estimate";
            });
    
        });
    </script>

    <?php } else {?>

<!---------------------------------------------------------------------------------------------------------------->

                <?php if (!$lists) :?>

                <div class="border-light-box order-form">
                    <div class="sub_title d-flex">견적을 요청하실 상품을 등록하세요!</div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                        견적을 요청하시는 상품이 없습니다.
                        </div>                
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for=""> </label>
                        </div>                
                    </div>
                </div>

                <div class="order-btn-box btn-lg-box btn-box align-c mt-3 mb-1">
                    <a href="<?=route_guest('home')?>"><button class="btn btn-lg btn-blue w-20 ml-1">확인</button></a>
                </div>

                <?php else: ?>

                <!-- 견적 상품정보 s -->
                <div class="border-light-box order-form">
                    <div class="sub_title">견적문의내용</div>
                    <table class="table_style2 order_list">
                        <thead>
                            <tr>
                                <th>이미지</th>
                                <th>견적상품</th>
                                <th>기준단가</th>
                                <th>요청수량</th>
                            </tr>
                        </thead>

                        <?php $i = 1; 
                        foreach($lists as $parts){

                        $parts_price = $parts->nowinfo['selling_price1'];
                        $amount_price = $parts_price * $parts->qty;
                        $price_vat = $amount_price*0.1;
                        $total_price = $amount_price+$price_vat;          
                        ?>
                        <tr>
                        <td><p class="prd-img">
                        <?php if(isset($parts->nowinfo['image_dir']) && $parts->nowinfo['image_dir'] != ''): ?>
                            <?php if(isset($parts->nowinfo['api_flg']) && $parts->nowinfo['api_flg'] == '1'): ?>
                                <img src="<?=$parts->nowinfo['image_dir']?>"/>
                            <?php else : ?>
                                <img src="<?=asset_public($parts->nowinfo['image_dir'])?>"/>
                            <?php endif; ?>
                        <?php else : ?>
                            <img src="<?=asset_public('images/no_image_available.jpg')?>"/>
                        <?php endif; ?>
                        </p></td>
                            <td>
                                <p><label class="badge_blue font-sm">
                                    <?php foreach ($stocklocationcategorys as $stock_location): ?>
                                        <?php if($stock_location->location_id == $parts->nowinfo['stock_location']) echo $stock_location->location_info;?>
                                    <?php endforeach; ?>
                                </label></p>
                                <p class="col-blue font-sm"><?php echo $parts->nowinfo['name'];?></p>
                                <p class="prd-subject"><?php echo $parts->nowinfo['part_number'];?></p>
                                <p class="prd-cmt col-gray font-sm"><?=$parts->nowinfo['product_code']?></p>
                                <!--p><?=$parts->nowinfo['part_number_sequence']?></p-->
                                <p class="prd-option col-gray font-sm">
                                    <?php
                                    $brief_description = $parts->nowinfo['brief_description'];
                                    $prd_description = explode('|^|', $brief_description);

                                    echo mb_strimwidth($prd_description[1],'0',40,'...','utf-8');
                                    ?>
                                </p>
                                <!--p>관련 부품 : <?=$parts->nowinfo['product_related']?></p-->
                                </p>
                            </td>
                            <td>
                            <?php if ($parts->q_price == 0) {?>
                            <?=number_format($parts_price)?>원
                            <?php } else {?>
                            <?=number_format($parts->q_price)?>원<br>
                            <del><?=number_format($parts_price)?>원</del>
                            <?php }?>
                            </td>
                        <td>
                        <?php if ($parts->q_price == 0) {?>
                            <?=number_format($parts->qty)?>
                        <?php } else {?>
                            <?=number_format($parts->q_qty)?><br>
                            <del><?=number_format($parts->qty)?></del>
                        <?php }?>
                        </td>
                    </tr>

                    <?php
                    $i++;
                    }
                    ?>

                        </tbody>
                    </table>


        <?php endif;?>
<!-------------------------------------------------------------------------------------------------------------------->
                    <!--------  s -->
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for="">견적서 번호</label><?=$item->estimate_code?>
                        </div>                
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for=""><?=lang_contact('news_title')?></label>
                            <?=$item->title?>
                        </div>                
                    </div>

                    <div class="form-gp">
                        <div class="d-flex g-2">
                            <label for=""><?=lang_contact('news_id')?></label>
                            <?=$item->user_name?>
                        </div>
                        <div class="d-flex g-2">
                            <label for=""><?=lang_contact('news_date')?></label>
                            <?=\App\Helpers\DateHelper::toTimeString($item->created_at,'yyyy-MM-dd')?>
                        </div>
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for=""><?=lang_contact('news_category')?></label>
                            <?=$item->category_name?>
                        </div>                
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for=""><?=lang_common('question')?></label>
                        </div>                
                    </div>
                    <div class="order_guideWrap mb56">
                        <div class="order_guideWrap02">
                        <?php echo htmlspecialchars_decode($item->content)?>
                        </div>
                    </div>
                    <div class="form-gp">
                        <div class="d-flex g-1">
                            <label for=""><?=lang_common('answer')?></label>
                        </div>                
                    </div>
                    <div class="order_guideWrap mb56">
                        <div class="order_guideWrap02">
                        <?php echo htmlspecialchars_decode($item->answer_content)?>
                        </div>
                    </div>
                </div>
                <!--  e -->
                <div class="order-btn-box btn-box">
                    <a href="<?=route_guest('estimate.downloadbom')?>" class="btn font-xsm btn-outline-white float-l">BOM 양식받기</a>
                    <a href="<?=route_guest('estimate')?>" class="btn font-xsm btn-blue float-r ml-1"><?=lang_contact('news_list')?></a>
                    <a href="<?=route_guest('estimate.update', $item->id)?>" class="btn font-xsm btn-blue float-r"><?=lang_common('update')?></a>
                </div>
            </div>

            <div class="order-btn-box mt-3 mb-2"> </div>

            <!--div class="order-btn-box btn-lg-box btn-box align-c">
                <a href="" class="btn btn-lg btn-outline-white w-20">장바구니로</a>
                <button class="btn btn-lg btn-blue w-20 ml-1">다음</button>
            </div-->

        <?php } ?>

</section>

<!---------------------------------------------------------------------------------------------->
<script>
	$(function () {        
        $('.myMenu ul li').on('mouseenter mouseleave', function () {
            $(this).children('ul').stop(true, false, true).slideToggle(10);
        });
    });

    $(document).ready(function() {
        $('.category-toggle').click(function() {
            $('.category-box').slideToggle(300); // 슬라이드 애니메이션 효과로 펼치고 접기
            $(this).toggleClass('on');
        });
    });

    /* prd category */    
    $(".prd_cate_item a").click(function(){
        $(".prd_cate_item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });

    /* 상품 정렬 */
    $(".align-item a").click(function(){
        $(".align-item a").removeClass("active");
        //this는 함수를 실행하게 만든 그 클릭한 요소다!
        $(this).addClass("active");//그 요소에게 효과주고        
    });
    
</script>
<!---------------------------------------------------------------------------------------------->

<?= $this->endSection() ?>
